/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.apache.flink.util.ReflectionUtil;

@Public
public abstract class ListValue<V extends Value>
implements Value,
List<V> {
    private static final long serialVersionUID = 1L;
    private final Class<V> valueClass = ReflectionUtil.getTemplateType1(this.getClass());
    private final List<V> list;

    public ListValue() {
        this.list = new ArrayList<V>();
    }

    public ListValue(Collection<V> c) {
        this.list = new ArrayList<V>(c);
    }

    @Override
    public Iterator<V> iterator() {
        return this.list.iterator();
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.list.clear();
        try {
            for (int size = in.readInt(); size > 0; --size) {
                Value val = (Value)this.valueClass.newInstance();
                val.read(in);
                this.list.add(val);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.list.size());
        for (Value value : this.list) {
            value.write(out);
        }
    }

    @Override
    public int hashCode() {
        int prime = 41;
        int result2 = 1;
        result2 = 41 * result2 + (this.list == null ? 0 : this.list.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListValue other = (ListValue)obj;
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    @Override
    public void add(int index, V element) {
        this.list.add(index, element);
    }

    @Override
    public boolean add(V e) {
        return this.list.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public V get(int index) {
        return (V)((Value)this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public V remove(int index) {
        return (V)((Value)this.list.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public V set(int index, V element) {
        return (V)((Value)this.list.set(index, element));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

