/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.MutableURLClassLoader;

public final class ChildFirstClassLoader
extends FlinkUserCodeClassLoader {
    private final String[] alwaysParentFirstPatterns;

    public ChildFirstClassLoader(URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler) {
        super(urls, parent, classLoadingExceptionHandler);
        this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
    }

    @Override
    protected Class<?> loadClassWithoutExceptionHandling(String name2, boolean resolve2) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name2);
        if (c == null) {
            for (String alwaysParentFirstPattern : this.alwaysParentFirstPatterns) {
                if (!name2.startsWith(alwaysParentFirstPattern)) continue;
                return super.loadClassWithoutExceptionHandling(name2, resolve2);
            }
            try {
                c = this.findClass(name2);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClassWithoutExceptionHandling(name2, resolve2);
            }
        } else if (resolve2) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name2) {
        URL urlClassLoaderResource = this.findResource(name2);
        if (urlClassLoaderResource != null) {
            return urlClassLoaderResource;
        }
        return super.getResource(name2);
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        Enumeration<URL> urlClassLoaderResources = this.findResources(name2);
        final ArrayList<URL> result2 = new ArrayList<URL>();
        while (urlClassLoaderResources.hasMoreElements()) {
            result2.add(urlClassLoaderResources.nextElement());
        }
        Enumeration<URL> parentResources = this.getParent().getResources(name2);
        while (parentResources.hasMoreElements()) {
            result2.add(parentResources.nextElement());
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = result2.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public MutableURLClassLoader copy() {
        return new ChildFirstClassLoader(this.getURLs(), this.getParent(), this.alwaysParentFirstPatterns, this.classLoadingExceptionHandler);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

