/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.ChildFirstClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.MutableURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FlinkUserCodeClassLoaders {
    private FlinkUserCodeClassLoaders() {
    }

    public static MutableURLClassLoader parentFirst(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler, boolean checkClassLoaderLeak) {
        ParentFirstClassLoader classLoader2 = new ParentFirstClassLoader(urls, parent, classLoadingExceptionHandler);
        return FlinkUserCodeClassLoaders.wrapWithSafetyNet(classLoader2, checkClassLoaderLeak);
    }

    public static MutableURLClassLoader childFirst(URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler, boolean checkClassLoaderLeak) {
        ChildFirstClassLoader classLoader2 = new ChildFirstClassLoader(urls, parent, alwaysParentFirstPatterns, classLoadingExceptionHandler);
        return FlinkUserCodeClassLoaders.wrapWithSafetyNet(classLoader2, checkClassLoaderLeak);
    }

    public static MutableURLClassLoader create(URL[] urls, ClassLoader parent, ReadableConfig config) {
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns(config);
        String classLoaderResolveOrder = config.get(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        ResolveOrder resolveOrder = ResolveOrder.fromString(classLoaderResolveOrder);
        boolean checkClassloaderLeak = config.get(CoreOptions.CHECK_LEAKED_CLASSLOADER);
        return FlinkUserCodeClassLoaders.create(resolveOrder, urls, parent, alwaysParentFirstLoaderPatterns, FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, checkClassloaderLeak);
    }

    public static MutableURLClassLoader create(ResolveOrder resolveOrder, URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler, boolean checkClassLoaderLeak) {
        switch (resolveOrder) {
            case CHILD_FIRST: {
                return FlinkUserCodeClassLoaders.childFirst(urls, parent, alwaysParentFirstPatterns, classLoadingExceptionHandler, checkClassLoaderLeak);
            }
            case PARENT_FIRST: {
                return FlinkUserCodeClassLoaders.parentFirst(urls, parent, classLoadingExceptionHandler, checkClassLoaderLeak);
            }
        }
        throw new IllegalArgumentException("Unknown class resolution order: " + (Object)((Object)resolveOrder));
    }

    private static MutableURLClassLoader wrapWithSafetyNet(FlinkUserCodeClassLoader classLoader2, boolean check2) {
        return check2 ? new SafetyNetWrapperClassLoader(classLoader2, classLoader2.getParent()) : classLoader2;
    }

    @Internal
    public static class SafetyNetWrapperClassLoader
    extends MutableURLClassLoader {
        private static final Logger LOG = LoggerFactory.getLogger(SafetyNetWrapperClassLoader.class);
        protected volatile FlinkUserCodeClassLoader inner;

        protected SafetyNetWrapperClassLoader(FlinkUserCodeClassLoader inner, ClassLoader parent) {
            super(new URL[0], parent);
            this.inner = inner;
        }

        @Override
        public void close() {
            FlinkUserCodeClassLoader inner = this.inner;
            if (inner != null) {
                try {
                    inner.close();
                }
                catch (IOException e) {
                    LOG.warn("Could not close user classloader", (Throwable)e);
                }
            }
            this.inner = null;
        }

        private FlinkUserCodeClassLoader ensureInner() {
            if (this.inner == null) {
                throw new IllegalStateException("Trying to access closed classloader. Please check if you store classloaders directly or indirectly in static fields. If the stacktrace suggests that the leak occurs in a third party library and cannot be fixed immediately, you can disable this check with the configuration '" + CoreOptions.CHECK_LEAKED_CLASSLOADER.key() + "'.");
            }
            return this.inner;
        }

        @Override
        public Class<?> loadClass(String name2) throws ClassNotFoundException {
            return this.ensureInner().loadClass(name2);
        }

        @Override
        protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
            return this.ensureInner().loadClass(name2, resolve2);
        }

        @Override
        public void addURL(URL url2) {
            this.ensureInner().addURL(url2);
        }

        @Override
        public MutableURLClassLoader copy() {
            return new SafetyNetWrapperClassLoader((FlinkUserCodeClassLoader)this.inner.copy(), this.getParent());
        }

        @Override
        public URL getResource(String name2) {
            return this.ensureInner().getResource(name2);
        }

        @Override
        public Enumeration<URL> getResources(String name2) throws IOException {
            return this.ensureInner().getResources(name2);
        }

        @Override
        public URL[] getURLs() {
            return this.ensureInner().getURLs();
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    @Internal
    public static class ParentFirstClassLoader
    extends FlinkUserCodeClassLoader {
        ParentFirstClassLoader(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
            super(urls, parent, classLoadingExceptionHandler);
        }

        @Override
        public MutableURLClassLoader copy() {
            return new ParentFirstClassLoader(this.getURLs(), this.getParent(), this.classLoadingExceptionHandler);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static enum ResolveOrder {
        CHILD_FIRST,
        PARENT_FIRST;


        public static ResolveOrder fromString(String resolveOrder) {
            if (resolveOrder.equalsIgnoreCase("parent-first")) {
                return PARENT_FIRST;
            }
            if (resolveOrder.equalsIgnoreCase("child-first")) {
                return CHILD_FIRST;
            }
            throw new IllegalArgumentException("Unknown resolve order: " + resolveOrder);
        }
    }
}

