/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.util.MdcAwareExecutor;
import org.apache.flink.util.MdcUtils;

class MdcAwareExecutorService<S extends ExecutorService>
extends MdcAwareExecutor<S>
implements ExecutorService {
    public MdcAwareExecutorService(S delegate, Map<String, String> contextData) {
        super(delegate, contextData);
    }

    @Override
    public void shutdown() {
        ((ExecutorService)this.delegate).shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return ((ExecutorService)this.delegate).shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return ((ExecutorService)this.delegate).isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return ((ExecutorService)this.delegate).isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return ((ExecutorService)this.delegate).awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return ((ExecutorService)this.delegate).submit(MdcUtils.wrapCallable(this.contextData, task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result2) {
        return ((ExecutorService)this.delegate).submit(MdcUtils.wrapRunnable(this.contextData, task), result2);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return ((ExecutorService)this.delegate).submit(MdcUtils.wrapRunnable(this.contextData, task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return ((ExecutorService)this.delegate).invokeAll(this.wrapCallables(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return ((ExecutorService)this.delegate).invokeAll(this.wrapCallables(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return ((ExecutorService)this.delegate).invokeAny(this.wrapCallables(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return ((ExecutorService)this.delegate).invokeAny(this.wrapCallables(tasks), timeout, unit);
    }

    private <T> List<Callable<T>> wrapCallables(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> list = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            list.add(MdcUtils.wrapCallable(this.contextData, task));
        }
        return list;
    }
}

