/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;

@Internal
public final class Preconditions {
    public static <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(@Nullable T reference, @Nullable String errorMessage2) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage2));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean condition, @Nullable Object errorMessage2) {
        if (!condition) {
            throw new IllegalArgumentException(String.valueOf(errorMessage2));
        }
    }

    public static void checkArgument(boolean condition, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean condition) {
        if (!condition) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean condition, @Nullable Object errorMessage2) {
        if (!condition) {
            throw new IllegalStateException(String.valueOf(errorMessage2));
        }
    }

    public static void checkState(boolean condition, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!condition) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkElementIndex(int index, int size) {
        Preconditions.checkArgument(size >= 0, "Size was negative.");
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    public static void checkElementIndex(int index, int size, @Nullable String errorMessage2) {
        Preconditions.checkArgument(size >= 0, "Size was negative.");
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(String.valueOf(errorMessage2) + " Index: " + index + ", Size: " + size);
        }
    }

    public static void checkCompletedNormally(CompletableFuture<?> future) {
        Preconditions.checkState(future.isDone());
        if (future.isCompletedExceptionally()) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static String format(@Nullable String template, Object ... args2) {
        int placeholderStart;
        int numArgs = args2 == null ? 0 : args2.length;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * numArgs);
        int templateStart = 0;
        int i = 0;
        while (i < numArgs && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args2[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < numArgs) {
            builder.append(" [");
            builder.append(args2[i++]);
            while (i < numArgs) {
                builder.append(", ");
                builder.append(args2[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private Preconditions() {
    }
}

