/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ProcessorArchitecture {
    X86(MemoryAddressSize._32_BIT, "x86", "i386", "i486", "i586", "i686"),
    AMD64(MemoryAddressSize._64_BIT, "amd64", "x86_64"),
    ARMv7(MemoryAddressSize._32_BIT, "armv7", "arm"),
    AARCH64(MemoryAddressSize._64_BIT, "aarch64", new String[0]),
    PPC64_LE(MemoryAddressSize._64_BIT, "ppc64le", new String[0]),
    UNKNOWN(MemoryAddressSize._32_BIT, "unknown", new String[0]);

    private static final ProcessorArchitecture CURRENT;
    private final MemoryAddressSize addressSize;
    private final String name;
    private final List<String> alternativeNames;

    private ProcessorArchitecture(MemoryAddressSize addressSize, String name2, String ... alternativeNames) {
        this.addressSize = addressSize;
        this.name = name2;
        this.alternativeNames = Collections.unmodifiableList(Arrays.asList(alternativeNames));
    }

    public MemoryAddressSize getAddressSize() {
        return this.addressSize;
    }

    public String getArchitectureName() {
        return this.name;
    }

    public List<String> getAlternativeNames() {
        return this.alternativeNames;
    }

    public static ProcessorArchitecture getProcessorArchitecture() {
        return CURRENT;
    }

    public static MemoryAddressSize getMemoryAddressSize() {
        return ProcessorArchitecture.getProcessorArchitecture().getAddressSize();
    }

    private static ProcessorArchitecture readArchFromSystemProperties() {
        String sysArchName = System.getProperty("os.arch");
        if (sysArchName == null) {
            return UNKNOWN;
        }
        for (ProcessorArchitecture arch : ProcessorArchitecture.values()) {
            if (sysArchName.equalsIgnoreCase(arch.name)) {
                return arch;
            }
            for (String altName : arch.alternativeNames) {
                if (!sysArchName.equalsIgnoreCase(altName)) continue;
                return arch;
            }
        }
        return UNKNOWN;
    }

    static {
        CURRENT = ProcessorArchitecture.readArchFromSystemProperties();
    }

    public static enum MemoryAddressSize {
        _32_BIT,
        _64_BIT;

    }
}

