/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.UnionIterator;

@Internal
public final class ReflectionUtil {
    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> getTemplateType(Class<?> clazz, int num) {
        return ReflectionUtil.getSuperTemplateTypes(clazz)[num];
    }

    public static <T> Class<T> getTemplateType(Class<?> clazz, Class<?> classWithParameter, int num) {
        return ReflectionUtil.getSuperTemplateTypes(clazz)[num];
    }

    public static <T> Class<T> getTemplateType1(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 0);
    }

    public static <T> Class<T> getTemplateType1(Type type2) {
        if (type2 instanceof ParameterizedType) {
            return ReflectionUtil.getTemplateTypes((ParameterizedType)type2)[0];
        }
        throw new IllegalArgumentException();
    }

    public static <T> Class<T> getTemplateType2(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 1);
    }

    public static <T> Class<T> getTemplateType3(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 2);
    }

    public static <T> Class<T> getTemplateType4(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 3);
    }

    public static <T> Class<T> getTemplateType5(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 4);
    }

    public static <T> Class<T> getTemplateType6(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 5);
    }

    public static <T> Class<T> getTemplateType7(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 6);
    }

    public static <T> Class<T> getTemplateType8(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 7);
    }

    public static Class<?>[] getSuperTemplateTypes(Class<?> clazz) {
        Type type2 = clazz.getGenericSuperclass();
        while (!(type2 instanceof ParameterizedType)) {
            if (clazz.getGenericSuperclass() == null) {
                throw new IllegalArgumentException();
            }
            type2 = clazz.getGenericSuperclass();
            clazz = clazz.getSuperclass();
        }
        return ReflectionUtil.getTemplateTypes((ParameterizedType)type2);
    }

    public static Class<?>[] getSuperTemplateTypes(Class<?> clazz, Class<?> searchedSuperClass) {
        Class<?> superClass;
        if (clazz == null || searchedSuperClass == null) {
            throw new NullPointerException();
        }
        while ((superClass = clazz.getSuperclass()) != searchedSuperClass && (clazz = superClass) != null) {
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The searched for superclass is not a superclass of the given class.");
        }
        Type type2 = clazz.getGenericSuperclass();
        if (type2 instanceof ParameterizedType) {
            return ReflectionUtil.getTemplateTypes((ParameterizedType)type2);
        }
        throw new IllegalArgumentException("The searched for superclass is not a generic class.");
    }

    public static Class<?>[] getTemplateTypes(ParameterizedType paramterizedType) {
        Class[] types = new Class[paramterizedType.getActualTypeArguments().length];
        int i = 0;
        for (Type templateArgument : paramterizedType.getActualTypeArguments()) {
            assert (templateArgument instanceof Class);
            types[i++] = (Class)templateArgument;
        }
        return types;
    }

    public static Class<?>[] getTemplateTypes(Class<?> clazz) {
        Type type2 = clazz.getGenericSuperclass();
        assert (type2 instanceof ParameterizedType);
        ParameterizedType paramterizedType = (ParameterizedType)type2;
        Class[] types = new Class[paramterizedType.getActualTypeArguments().length];
        int i = 0;
        for (Type templateArgument : paramterizedType.getActualTypeArguments()) {
            assert (templateArgument instanceof Class);
            types[i++] = (Class)templateArgument;
        }
        return types;
    }

    public static FullTypeInfo getFullTemplateType(Type type2, int templatePosition) {
        if (type2 instanceof ParameterizedType) {
            return ReflectionUtil.getFullTemplateType(((ParameterizedType)type2).getActualTypeArguments()[templatePosition]);
        }
        throw new IllegalArgumentException();
    }

    public static FullTypeInfo getFullTemplateType(Type type2) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            FullTypeInfo[] templateTypeInfos = new FullTypeInfo[parameterizedType.getActualTypeArguments().length];
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                templateTypeInfos[i] = ReflectionUtil.getFullTemplateType(parameterizedType.getActualTypeArguments()[i]);
            }
            return new FullTypeInfo((Class)parameterizedType.getRawType(), templateTypeInfos);
        }
        return new FullTypeInfo((Class)type2, null);
    }

    private ReflectionUtil() {
        throw new RuntimeException();
    }

    public static class FullTypeInfo {
        private final Class<?> clazz;
        private final FullTypeInfo[] templateTypeInfos;

        public FullTypeInfo(Class<?> clazz, FullTypeInfo[] templateTypeInfos) {
            this.clazz = Preconditions.checkNotNull(clazz);
            this.templateTypeInfos = templateTypeInfos;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public FullTypeInfo[] getTemplateTypeInfos() {
            return this.templateTypeInfos;
        }

        public Iterator<Class<?>> getClazzIterator() {
            UnionIterator unionIterator = new UnionIterator();
            unionIterator.add(Collections.singleton(this.clazz).iterator());
            if (this.templateTypeInfos != null) {
                for (int i = 0; i < this.templateTypeInfos.length; ++i) {
                    unionIterator.add(this.templateTypeInfos[i].getClazzIterator());
                }
            }
            return unionIterator;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.clazz.getSimpleName());
            if (this.templateTypeInfos != null) {
                builder.append("<");
                for (int i = 0; i < this.templateTypeInfos.length - 1; ++i) {
                    builder.append(this.templateTypeInfos[i]).append(", ");
                }
                builder.append(this.templateTypeInfos[this.templateTypeInfos.length - 1]);
                builder.append(">");
            }
            return builder.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FullTypeInfo) {
                FullTypeInfo other = (FullTypeInfo)obj;
                return this.clazz == other.getClazz() && Arrays.equals(this.templateTypeInfos, other.getTemplateTypeInfos());
            }
            return false;
        }
    }
}

