/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.TraversableOnceException;

@Internal
public class UnionIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<T> currentIterator;
    private ArrayList<Iterator<T>> furtherIterators = new ArrayList();
    private int nextIterator;
    private boolean iteratorAvailable = true;

    public void clear() {
        this.currentIterator = null;
        this.furtherIterators.clear();
        this.nextIterator = 0;
        this.iteratorAvailable = true;
    }

    public void addList(List<T> list) {
        this.add(list.iterator());
    }

    public void add(Iterator<T> iterator2) {
        if (this.currentIterator == null) {
            this.currentIterator = iterator2;
        } else {
            this.furtherIterators.add(iterator2);
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iteratorAvailable) {
            this.iteratorAvailable = false;
            return this;
        }
        throw new TraversableOnceException();
    }

    @Override
    public boolean hasNext() {
        while (this.currentIterator != null) {
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.nextIterator < this.furtherIterators.size()) {
                this.currentIterator = this.furtherIterators.get(this.nextIterator);
                ++this.nextIterator;
                continue;
            }
            this.currentIterator = null;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

