/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSimpleScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClientAsyncPrefetchScanner
extends ClientSimpleScanner {
    private long maxCacheSize;
    private AtomicLong cacheSizeInBytes;
    private final Queue<Exception> exceptionsQueue;
    private Consumer<Boolean> prefetchListener;
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public ClientAsyncPrefetchScanner(Configuration configuration, Scan scan, TableName name2, ClusterConnection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, int replicaCallTimeoutMicroSecondScan) throws IOException {
        super(configuration, scan, name2, connection, rpcCallerFactory, rpcControllerFactory, pool, replicaCallTimeoutMicroSecondScan);
        this.exceptionsQueue = new ConcurrentLinkedQueue<Exception>();
        Threads.setDaemonThreadRunning(new Thread(new PrefetchRunnable()), name2 + ".asyncPrefetcher");
    }

    void setPrefetchListener(Consumer<Boolean> prefetchListener) {
        this.prefetchListener = prefetchListener;
    }

    @Override
    protected void initCache() {
        this.cache = new LinkedBlockingQueue();
        this.maxCacheSize = this.resultSize2CacheSize(this.maxScannerResultSize);
        this.cacheSizeInBytes = new AtomicLong(0L);
    }

    private long resultSize2CacheSize(long maxResultSize) {
        return maxResultSize > 0x3FFFFFFFFFFFFFFFL ? maxResultSize : maxResultSize * 2L;
    }

    @Override
    public Result next() throws IOException {
        try {
            this.lock.lock();
            while (this.cache.isEmpty()) {
                this.handleException();
                if (this.closed) {
                    Result result2 = null;
                    return result2;
                }
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted when wait to load cache");
                }
            }
            Result result3 = this.pollCache();
            if (this.prefetchCondition()) {
                this.notFull.signalAll();
            }
            Result result4 = result3;
            return result4;
        }
        finally {
            this.lock.unlock();
            this.handleException();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.lock();
            super.close();
            this.closed = true;
            this.notFull.signalAll();
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void addEstimatedSize(long estimatedSize) {
        this.cacheSizeInBytes.addAndGet(estimatedSize);
    }

    private void handleException() throws IOException {
        if (!this.exceptionsQueue.isEmpty()) {
            Exception first = this.exceptionsQueue.peek();
            first.printStackTrace();
            if (first instanceof IOException) {
                throw (IOException)first;
            }
            throw (RuntimeException)first;
        }
    }

    private boolean prefetchCondition() {
        return this.cacheSizeInBytes.get() < this.maxCacheSize / 2L;
    }

    private Result pollCache() {
        Result res = (Result)this.cache.poll();
        long estimatedSize = ConnectionUtils.calcEstimatedSize(res);
        this.addEstimatedSize(-estimatedSize);
        return res;
    }

    private class PrefetchRunnable
    implements Runnable {
        private PrefetchRunnable() {
        }

        @Override
        public void run() {
            while (!ClientAsyncPrefetchScanner.this.closed) {
                boolean succeed = false;
                try {
                    ClientAsyncPrefetchScanner.this.lock.lock();
                    while (!ClientAsyncPrefetchScanner.this.prefetchCondition()) {
                        ClientAsyncPrefetchScanner.this.notFull.await();
                    }
                    ClientAsyncPrefetchScanner.this.loadCache();
                    succeed = true;
                }
                catch (Exception e) {
                    ClientAsyncPrefetchScanner.this.exceptionsQueue.add(e);
                }
                finally {
                    ClientAsyncPrefetchScanner.this.notEmpty.signalAll();
                    ClientAsyncPrefetchScanner.this.lock.unlock();
                    if (ClientAsyncPrefetchScanner.this.prefetchListener == null) continue;
                    ClientAsyncPrefetchScanner.this.prefetchListener.accept(succeed);
                }
            }
        }
    }
}

