/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.gson.Gson;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.gson.JsonObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class OnlineLogRecord
extends LogEntry {
    private static final Gson GSON = GsonUtil.createGson().setPrettyPrinting().registerTypeAdapter(OnlineLogRecord.class, (slowLogPayload, type2, jsonSerializationContext) -> {
        Gson gson = new Gson();
        JsonObject jsonObj = (JsonObject)gson.toJsonTree(slowLogPayload);
        if (slowLogPayload.getMultiGetsCount() == 0) {
            jsonObj.remove("multiGetsCount");
        }
        if (slowLogPayload.getMultiMutationsCount() == 0) {
            jsonObj.remove("multiMutationsCount");
        }
        if (slowLogPayload.getMultiServiceCalls() == 0) {
            jsonObj.remove("multiServiceCalls");
        }
        return jsonObj;
    }).create();
    private final long startTime;
    private final int processingTime;
    private final int queueTime;
    private final long responseSize;
    private final String clientAddress;
    private final String serverClass;
    private final String methodName;
    private final String callDetails;
    private final String param;
    private final transient String regionName;
    private final String userName;
    private final int multiGetsCount;
    private final int multiMutationsCount;
    private final int multiServiceCalls;

    public long getStartTime() {
        return this.startTime;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public int getQueueTime() {
        return this.queueTime;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getServerClass() {
        return this.serverClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getCallDetails() {
        return this.callDetails;
    }

    public String getParam() {
        return this.param;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getMultiGetsCount() {
        return this.multiGetsCount;
    }

    public int getMultiMutationsCount() {
        return this.multiMutationsCount;
    }

    public int getMultiServiceCalls() {
        return this.multiServiceCalls;
    }

    private OnlineLogRecord(long startTime, int processingTime, int queueTime, long responseSize, String clientAddress, String serverClass, String methodName, String callDetails, String param2, String regionName, String userName, int multiGetsCount, int multiMutationsCount, int multiServiceCalls) {
        this.startTime = startTime;
        this.processingTime = processingTime;
        this.queueTime = queueTime;
        this.responseSize = responseSize;
        this.clientAddress = clientAddress;
        this.serverClass = serverClass;
        this.methodName = methodName;
        this.callDetails = callDetails;
        this.param = param2;
        this.regionName = regionName;
        this.userName = userName;
        this.multiGetsCount = multiGetsCount;
        this.multiMutationsCount = multiMutationsCount;
        this.multiServiceCalls = multiServiceCalls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnlineLogRecord that = (OnlineLogRecord)o;
        return new EqualsBuilder().append(this.startTime, that.startTime).append(this.processingTime, that.processingTime).append(this.queueTime, that.queueTime).append(this.responseSize, that.responseSize).append(this.multiGetsCount, that.multiGetsCount).append(this.multiMutationsCount, that.multiMutationsCount).append(this.multiServiceCalls, that.multiServiceCalls).append((Object)this.clientAddress, (Object)that.clientAddress).append((Object)this.serverClass, (Object)that.serverClass).append((Object)this.methodName, (Object)that.methodName).append((Object)this.callDetails, (Object)that.callDetails).append((Object)this.param, (Object)that.param).append((Object)this.regionName, (Object)that.regionName).append((Object)this.userName, (Object)that.userName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.startTime).append(this.processingTime).append(this.queueTime).append(this.responseSize).append((Object)this.clientAddress).append((Object)this.serverClass).append((Object)this.methodName).append((Object)this.callDetails).append((Object)this.param).append((Object)this.regionName).append((Object)this.userName).append(this.multiGetsCount).append(this.multiMutationsCount).append(this.multiServiceCalls).toHashCode();
    }

    @Override
    public String toJsonPrettyPrint() {
        return GSON.toJson((Object)this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("startTime", this.startTime).append("processingTime", this.processingTime).append("queueTime", this.queueTime).append("responseSize", this.responseSize).append("clientAddress", (Object)this.clientAddress).append("serverClass", (Object)this.serverClass).append("methodName", (Object)this.methodName).append("callDetails", (Object)this.callDetails).append("param", (Object)this.param).append("regionName", (Object)this.regionName).append("userName", (Object)this.userName).append("multiGetsCount", this.multiGetsCount).append("multiMutationsCount", this.multiMutationsCount).append("multiServiceCalls", this.multiServiceCalls).toString();
    }

    public static class OnlineLogRecordBuilder {
        private long startTime;
        private int processingTime;
        private int queueTime;
        private long responseSize;
        private String clientAddress;
        private String serverClass;
        private String methodName;
        private String callDetails;
        private String param;
        private String regionName;
        private String userName;
        private int multiGetsCount;
        private int multiMutationsCount;
        private int multiServiceCalls;

        public OnlineLogRecordBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public OnlineLogRecordBuilder setProcessingTime(int processingTime) {
            this.processingTime = processingTime;
            return this;
        }

        public OnlineLogRecordBuilder setQueueTime(int queueTime) {
            this.queueTime = queueTime;
            return this;
        }

        public OnlineLogRecordBuilder setResponseSize(long responseSize) {
            this.responseSize = responseSize;
            return this;
        }

        public OnlineLogRecordBuilder setClientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
            return this;
        }

        public OnlineLogRecordBuilder setServerClass(String serverClass) {
            this.serverClass = serverClass;
            return this;
        }

        public OnlineLogRecordBuilder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public OnlineLogRecordBuilder setCallDetails(String callDetails) {
            this.callDetails = callDetails;
            return this;
        }

        public OnlineLogRecordBuilder setParam(String param2) {
            this.param = param2;
            return this;
        }

        public OnlineLogRecordBuilder setRegionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public OnlineLogRecordBuilder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public OnlineLogRecordBuilder setMultiGetsCount(int multiGetsCount) {
            this.multiGetsCount = multiGetsCount;
            return this;
        }

        public OnlineLogRecordBuilder setMultiMutationsCount(int multiMutationsCount) {
            this.multiMutationsCount = multiMutationsCount;
            return this;
        }

        public OnlineLogRecordBuilder setMultiServiceCalls(int multiServiceCalls) {
            this.multiServiceCalls = multiServiceCalls;
            return this;
        }

        public OnlineLogRecord build() {
            return new OnlineLogRecord(this.startTime, this.processingTime, this.queueTime, this.responseSize, this.clientAddress, this.serverClass, this.methodName, this.callDetails, this.param, this.regionName, this.userName, this.multiGetsCount, this.multiMutationsCount, this.multiServiceCalls);
        }
    }
}

