/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SnapshotDescription {
    private final String name;
    private final TableName table;
    private final SnapshotType snapShotType;
    private final String owner;
    private final long creationTime;
    private final long ttl;
    private final int version;
    private final long maxFileSize;

    public SnapshotDescription(String name2) {
        this(name2, (TableName)null);
    }

    @Deprecated
    public SnapshotDescription(String name2, String table) {
        this(name2, TableName.valueOf(table));
    }

    public SnapshotDescription(String name2, TableName table) {
        this(name2, table, SnapshotType.DISABLED, null, -1L, -1, null);
    }

    @Deprecated
    public SnapshotDescription(String name2, String table, SnapshotType type2) {
        this(name2, TableName.valueOf(table), type2);
    }

    public SnapshotDescription(String name2, TableName table, SnapshotType type2) {
        this(name2, table, type2, null, -1L, -1, null);
    }

    @Deprecated
    public SnapshotDescription(String name2, String table, SnapshotType type2, String owner) {
        this(name2, TableName.valueOf(table), type2, owner);
    }

    public SnapshotDescription(String name2, TableName table, SnapshotType type2, String owner) {
        this(name2, table, type2, owner, -1L, -1, null);
    }

    @Deprecated
    public SnapshotDescription(String name2, String table, SnapshotType type2, String owner, long creationTime, int version) {
        this(name2, TableName.valueOf(table), type2, owner, creationTime, version, null);
    }

    @Deprecated
    public SnapshotDescription(String name2, TableName table, SnapshotType type2, String owner, long creationTime, int version) {
        this(name2, table, type2, owner, creationTime, version, null);
    }

    public SnapshotDescription(String name2, TableName table, SnapshotType type2, String owner, long creationTime, int version, Map<String, Object> snapshotProps) {
        this.name = name2;
        this.table = table;
        this.snapShotType = type2;
        this.owner = owner;
        this.creationTime = creationTime;
        this.ttl = this.getLongFromSnapshotProps(snapshotProps, "TTL");
        this.version = version;
        this.maxFileSize = this.getLongFromSnapshotProps(snapshotProps, "MAX_FILESIZE");
    }

    private long getLongFromSnapshotProps(Map<String, Object> snapshotProps, String property) {
        return MapUtils.getLongValue(snapshotProps, property, -1L);
    }

    public SnapshotDescription(String snapshotName, TableName tableName, SnapshotType type2, Map<String, Object> snapshotProps) {
        this(snapshotName, tableName, type2, null, -1L, -1, snapshotProps);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public String getTable() {
        return this.getTableNameAsString();
    }

    public String getTableNameAsString() {
        return this.table.getNameAsString();
    }

    public TableName getTableName() {
        return this.table;
    }

    public SnapshotType getType() {
        return this.snapShotType;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getTtl() {
        return this.ttl;
    }

    public int getVersion() {
        return this.version;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("table", (Object)this.table).append("snapShotType", (Object)this.snapShotType).append("owner", (Object)this.owner).append("creationTime", this.creationTime).append("ttl", this.ttl).append("version", this.version).append("maxFileSize", this.maxFileSize).toString();
    }
}

