/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ForeignExceptionDispatcher
implements ForeignExceptionListener,
ForeignExceptionSnare {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignExceptionDispatcher.class);
    protected final String name;
    protected final List<ForeignExceptionListener> listeners = new ArrayList<ForeignExceptionListener>();
    private ForeignException exception;

    public ForeignExceptionDispatcher(String name2) {
        this.name = name2;
    }

    public ForeignExceptionDispatcher() {
        this("");
    }

    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void receive(ForeignException e) {
        if (this.exception != null) {
            return;
        }
        LOG.debug(this.name + " accepting received exception", (Throwable)e);
        this.exception = e != null ? e : new ForeignException(this.name, "");
        this.dispatch(e);
    }

    @Override
    public synchronized void rethrowException() throws ForeignException {
        if (this.exception != null) {
            throw new ForeignException(this.exception.getSource(), this.exception.getCause());
        }
    }

    @Override
    public synchronized boolean hasException() {
        return this.exception != null;
    }

    @Override
    public synchronized ForeignException getException() {
        return this.exception;
    }

    private void dispatch(ForeignException e) {
        for (ForeignExceptionListener l : this.listeners) {
            l.receive(e);
        }
    }

    public synchronized void addListener(ForeignExceptionListener errorable) {
        this.listeners.add(errorable);
    }
}

