/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class CompareFilter
extends FilterBase {
    protected CompareOperator op;
    protected ByteArrayComparable comparator;

    @Deprecated
    public CompareFilter(CompareOp compareOp, ByteArrayComparable comparator) {
        this(CompareOperator.valueOf(compareOp.name()), comparator);
    }

    public CompareFilter(CompareOperator op, ByteArrayComparable comparator) {
        this.op = op;
        this.comparator = comparator;
    }

    @Deprecated
    public CompareOp getOperator() {
        return CompareOp.valueOf(this.op.name());
    }

    public CompareOperator getCompareOperator() {
        return this.op;
    }

    public ByteArrayComparable getComparator() {
        return this.comparator;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Deprecated
    protected boolean compareRow(CompareOp compareOp, ByteArrayComparable comparator, Cell cell) {
        if (compareOp == CompareOp.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareRow(cell, comparator);
        return CompareFilter.compare(compareOp, compareResult);
    }

    protected boolean compareRow(CompareOperator op, ByteArrayComparable comparator, Cell cell) {
        if (op == CompareOperator.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareRow(cell, comparator);
        return CompareFilter.compare(op, compareResult);
    }

    @Deprecated
    protected boolean compareFamily(CompareOp compareOp, ByteArrayComparable comparator, Cell cell) {
        if (compareOp == CompareOp.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareFamily(cell, comparator);
        return CompareFilter.compare(compareOp, compareResult);
    }

    protected boolean compareFamily(CompareOperator op, ByteArrayComparable comparator, Cell cell) {
        if (op == CompareOperator.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareFamily(cell, comparator);
        return CompareFilter.compare(op, compareResult);
    }

    @Deprecated
    protected boolean compareQualifier(CompareOp compareOp, ByteArrayComparable comparator, Cell cell) {
        if (compareOp == CompareOp.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareQualifier(cell, comparator);
        return CompareFilter.compare(compareOp, compareResult);
    }

    protected boolean compareQualifier(CompareOperator op, ByteArrayComparable comparator, Cell cell) {
        if (op == CompareOperator.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareQualifier(cell, comparator);
        return CompareFilter.compare(op, compareResult);
    }

    @Deprecated
    protected boolean compareValue(CompareOp compareOp, ByteArrayComparable comparator, Cell cell) {
        if (compareOp == CompareOp.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareValue(cell, comparator);
        return CompareFilter.compare(compareOp, compareResult);
    }

    protected boolean compareValue(CompareOperator op, ByteArrayComparable comparator, Cell cell) {
        if (op == CompareOperator.NO_OP) {
            return true;
        }
        int compareResult = PrivateCellUtil.compareValue(cell, comparator);
        return CompareFilter.compare(op, compareResult);
    }

    static boolean compare(CompareOp op, int compareResult) {
        switch (op) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    static boolean compare(CompareOperator op, int compareResult) {
        switch (op) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    public static ArrayList<Object> extractArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 2, "Expected 2 but got: %s", filterArguments.size());
        CompareOperator op = ParseFilter.createCompareOperator(filterArguments.get(0));
        ByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(1)));
        if ((comparator instanceof RegexStringComparator || comparator instanceof SubstringComparator) && op != CompareOperator.EQUAL && op != CompareOperator.NOT_EQUAL) {
            throw new IllegalArgumentException("A regexstring comparator and substring comparator can only be used with EQUAL and NOT_EQUAL");
        }
        ArrayList<Object> arguments2 = new ArrayList<Object>(2);
        arguments2.add((Object)op);
        arguments2.add(comparator);
        return arguments2;
    }

    FilterProtos.CompareFilter convert() {
        FilterProtos.CompareFilter.Builder builder = FilterProtos.CompareFilter.newBuilder();
        HBaseProtos.CompareType compareOp = HBaseProtos.CompareType.valueOf(this.op.name());
        builder.setCompareOp(compareOp);
        if (this.comparator != null) {
            builder.setComparator(ProtobufUtil.toComparator(this.comparator));
        }
        return builder.build();
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompareFilter)) {
            return false;
        }
        CompareFilter other = (CompareFilter)o;
        return this.getCompareOperator().equals((Object)other.getCompareOperator()) && (this.getComparator() == other.getComparator() || this.getComparator().areSerializedFieldsEqual(other.getComparator()));
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.op.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getComparator(), this.getCompareOperator()});
    }

    @Deprecated
    @InterfaceAudience.Public
    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        NO_OP;

    }
}

