/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileBlockDefaultEncodingContext
implements HFileBlockEncodingContext {
    private BlockType blockType;
    private final DataBlockEncoding encodingAlgo;
    private byte[] dummyHeader;
    private Compressor compressor;
    private CompressionOutputStream compressionStream;
    private ByteArrayOutputStream compressedByteStream;
    private HFileContext fileContext;
    private TagCompressionContext tagCompressionContext;
    private ByteArrayOutputStream cryptoByteStream;
    private byte[] iv;
    private EncodingState encoderState;

    public HFileBlockDefaultEncodingContext(DataBlockEncoding encoding, byte[] headerBytes, HFileContext fileContext) {
        Encryption.Context cryptoContext;
        Compression.Algorithm compressionAlgorithm;
        this.encodingAlgo = encoding;
        this.fileContext = fileContext;
        Compression.Algorithm algorithm = compressionAlgorithm = fileContext.getCompression() == null ? Compression.Algorithm.NONE : fileContext.getCompression();
        if (compressionAlgorithm != Compression.Algorithm.NONE) {
            this.compressor = compressionAlgorithm.getCompressor();
            this.compressedByteStream = new ByteArrayOutputStream();
            try {
                this.compressionStream = compressionAlgorithm.createPlainCompressionStream(this.compressedByteStream, this.compressor);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create compression stream for algorithm " + (Object)((Object)compressionAlgorithm), e);
            }
        }
        if ((cryptoContext = fileContext.getEncryptionContext()) != Encryption.Context.NONE) {
            this.cryptoByteStream = new ByteArrayOutputStream();
            this.iv = new byte[cryptoContext.getCipher().getIvLength()];
            Bytes.secureRandom(this.iv);
        }
        this.dummyHeader = Preconditions.checkNotNull(headerBytes, "Please pass HConstants.HFILEBLOCK_DUMMY_HEADER instead of null for param headerBytes");
    }

    public void prepareEncoding(DataOutputStream out) throws IOException {
        if (this.encodingAlgo != null && this.encodingAlgo != DataBlockEncoding.NONE) {
            this.encodingAlgo.writeIdInBytes(out);
        }
    }

    @Override
    public void postEncoding(BlockType blockType) throws IOException {
        this.blockType = blockType;
    }

    @Override
    public Bytes compressAndEncrypt(byte[] data2, int offset, int length) throws IOException {
        return this.compressAfterEncoding(data2, offset, length, this.dummyHeader);
    }

    private Bytes compressAfterEncoding(byte[] uncompressedBytesWithHeaderBuffer, int uncompressedBytesWithHeaderOffset, int uncompressedBytesWithHeaderLength, byte[] headerBytes) throws IOException {
        Encryption.Context cryptoContext = this.fileContext.getEncryptionContext();
        if (cryptoContext != Encryption.Context.NONE) {
            ByteArrayInputStream in;
            int plaintextLength;
            this.cryptoByteStream.reset();
            this.cryptoByteStream.write(headerBytes);
            if (this.fileContext.getCompression() != Compression.Algorithm.NONE) {
                this.compressedByteStream.reset();
                this.compressionStream.resetState();
                this.compressionStream.write(uncompressedBytesWithHeaderBuffer, headerBytes.length + uncompressedBytesWithHeaderOffset, uncompressedBytesWithHeaderLength - headerBytes.length);
                this.compressionStream.flush();
                this.compressionStream.finish();
                byte[] plaintext = this.compressedByteStream.toByteArray();
                plaintextLength = plaintext.length;
                in = new ByteArrayInputStream(plaintext);
            } else {
                plaintextLength = uncompressedBytesWithHeaderLength - headerBytes.length;
                in = new ByteArrayInputStream(uncompressedBytesWithHeaderBuffer, headerBytes.length + uncompressedBytesWithHeaderOffset, plaintextLength);
            }
            if (plaintextLength > 0) {
                Cipher cipher = cryptoContext.getCipher();
                Encryptor encryptor = cipher.getEncryptor();
                encryptor.setKey(cryptoContext.getKey());
                int ivLength = this.iv.length;
                Preconditions.checkState(ivLength <= 127, "IV length out of range");
                this.cryptoByteStream.write(ivLength);
                if (ivLength > 0) {
                    encryptor.setIv(this.iv);
                    this.cryptoByteStream.write(this.iv);
                }
                Encryption.encrypt(this.cryptoByteStream, in, encryptor);
                Encryption.incrementIv(this.iv, 1 + this.cryptoByteStream.size() / encryptor.getBlockSize());
                return new Bytes(this.cryptoByteStream.getBuffer(), 0, this.cryptoByteStream.size());
            }
            this.cryptoByteStream.write(0);
            return new Bytes(this.cryptoByteStream.getBuffer(), 0, this.cryptoByteStream.size());
        }
        if (this.fileContext.getCompression() != Compression.Algorithm.NONE) {
            this.compressedByteStream.reset();
            this.compressedByteStream.write(headerBytes);
            this.compressionStream.resetState();
            this.compressionStream.write(uncompressedBytesWithHeaderBuffer, headerBytes.length + uncompressedBytesWithHeaderOffset, uncompressedBytesWithHeaderLength - headerBytes.length);
            this.compressionStream.flush();
            this.compressionStream.finish();
            return new Bytes(this.compressedByteStream.getBuffer(), 0, this.compressedByteStream.size());
        }
        return null;
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public void close() {
        if (this.compressor != null) {
            this.fileContext.getCompression().returnCompressor(this.compressor);
            this.compressor = null;
        }
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return this.encodingAlgo;
    }

    @Override
    public HFileContext getHFileContext() {
        return this.fileContext;
    }

    public TagCompressionContext getTagCompressionContext() {
        return this.tagCompressionContext;
    }

    public void setTagCompressionContext(TagCompressionContext tagCompressionContext) {
        this.tagCompressionContext = tagCompressionContext;
    }

    @Override
    public EncodingState getEncodingState() {
        return this.encoderState;
    }

    @Override
    public void setEncodingState(EncodingState state) {
        this.encoderState = state;
    }
}

