/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BlockType
extends Enum<BlockType> {
    public static final /* enum */ BlockType DATA = new BlockType("DATABLK*", BlockCategory.DATA);
    public static final /* enum */ BlockType ENCODED_DATA = new BlockType("DATABLKE", BlockCategory.DATA){

        @Override
        public int getId() {
            return DATA.ordinal();
        }
    };
    public static final /* enum */ BlockType LEAF_INDEX = new BlockType("IDXLEAF2", BlockCategory.INDEX);
    public static final /* enum */ BlockType BLOOM_CHUNK = new BlockType("BLMFBLK2", BlockCategory.BLOOM);
    public static final /* enum */ BlockType META = new BlockType("METABLKc", BlockCategory.META);
    public static final /* enum */ BlockType INTERMEDIATE_INDEX = new BlockType("IDXINTE2", BlockCategory.INDEX);
    public static final /* enum */ BlockType ROOT_INDEX = new BlockType("IDXROOT2", BlockCategory.INDEX);
    public static final /* enum */ BlockType FILE_INFO = new BlockType("FILEINF2", BlockCategory.META);
    public static final /* enum */ BlockType GENERAL_BLOOM_META = new BlockType("BLMFMET2", BlockCategory.BLOOM);
    public static final /* enum */ BlockType DELETE_FAMILY_BLOOM_META = new BlockType("DFBLMET2", BlockCategory.BLOOM);
    public static final /* enum */ BlockType TRAILER = new BlockType("TRABLK\"$", BlockCategory.META);
    public static final /* enum */ BlockType INDEX_V1 = new BlockType("IDXBLK)+", BlockCategory.INDEX);
    public static final int MAGIC_LENGTH = 8;
    private final byte[] magic;
    private final BlockCategory metricCat;
    private static final /* synthetic */ BlockType[] $VALUES;

    public static BlockType[] values() {
        return (BlockType[])$VALUES.clone();
    }

    public static BlockType valueOf(String name2) {
        return Enum.valueOf(BlockType.class, name2);
    }

    private BlockType(String magicStr, BlockCategory metricCat) {
        this.magic = Bytes.toBytes(magicStr);
        this.metricCat = metricCat;
        assert (this.magic.length == 8);
    }

    public int getId() {
        return this.ordinal();
    }

    public void writeToStream(OutputStream out) throws IOException {
        out.write(this.magic);
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.magic);
    }

    public void write(ByteBuffer buf) {
        buf.put(this.magic);
    }

    public void write(ByteBuff buf) {
        buf.put(this.magic);
    }

    public BlockCategory getCategory() {
        return this.metricCat;
    }

    public static BlockType parse(byte[] buf, int offset, int length) throws IOException {
        if (length != 8) {
            throw new IOException("Magic record of invalid length: " + Bytes.toStringBinary(buf, offset, length));
        }
        for (BlockType blockType : BlockType.values()) {
            if (Bytes.compareTo(blockType.magic, 0, 8, buf, offset, 8) != 0) continue;
            return blockType;
        }
        throw new IOException("Invalid HFile block magic: " + Bytes.toStringBinary(buf, offset, 8));
    }

    public static BlockType read(DataInputStream in) throws IOException {
        byte[] buf = new byte[8];
        in.readFully(buf);
        return BlockType.parse(buf, 0, buf.length);
    }

    public static BlockType read(ByteBuff buf) throws IOException {
        byte[] magicBuf = new byte[Math.min(buf.limit() - buf.position(), 8)];
        buf.get(magicBuf);
        BlockType blockType = BlockType.parse(magicBuf, 0, magicBuf.length);
        return blockType;
    }

    public int put(byte[] bytes, int offset) {
        System.arraycopy(this.magic, 0, bytes, offset, 8);
        return offset + 8;
    }

    public void readAndCheck(DataInputStream in) throws IOException {
        byte[] buf = new byte[8];
        in.readFully(buf);
        if (Bytes.compareTo(buf, this.magic) != 0) {
            throw new IOException("Invalid magic: expected " + Bytes.toStringBinary(this.magic) + ", got " + Bytes.toStringBinary(buf));
        }
    }

    public void readAndCheck(ByteBuffer in) throws IOException {
        byte[] buf = new byte[8];
        in.get(buf);
        if (Bytes.compareTo(buf, this.magic) != 0) {
            throw new IOException("Invalid magic: expected " + Bytes.toStringBinary(this.magic) + ", got " + Bytes.toStringBinary(buf));
        }
    }

    public final boolean isData() {
        return this == DATA || this == ENCODED_DATA;
    }

    static {
        $VALUES = new BlockType[]{DATA, ENCODED_DATA, LEAF_INDEX, BLOOM_CHUNK, META, INTERMEDIATE_INDEX, ROOT_INDEX, FILE_INFO, GENERAL_BLOOM_META, DELETE_FAMILY_BLOOM_META, TRAILER, INDEX_V1};
    }

    public static enum BlockCategory {
        DATA,
        META,
        INDEX,
        BLOOM,
        ALL_CATEGORIES,
        UNKNOWN;


        public void expectSpecific() {
            if (this == ALL_CATEGORIES) {
                throw new IllegalArgumentException("Expected a specific block category but got " + (Object)((Object)this));
            }
        }
    }
}

