/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.concurrent.BlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class BalancedQueueRpcExecutor
extends RpcExecutor {
    private final RpcExecutor.QueueBalancer balancer;

    public BalancedQueueRpcExecutor(String name2, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        this(name2, handlerCount, conf.get("hbase.ipc.server.callqueue.type", "fifo"), maxQueueLength, priority, conf, abortable);
    }

    public BalancedQueueRpcExecutor(String name2, int handlerCount, String callQueueType, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name2, handlerCount, callQueueType, maxQueueLength, priority, conf, abortable);
        this.balancer = BalancedQueueRpcExecutor.getBalancer(this.numCallQueues);
        this.initializeQueues(this.numCallQueues);
    }

    @Override
    public boolean dispatch(CallRunner callTask) throws InterruptedException {
        int queueIndex = this.balancer.getNextQueue();
        BlockingQueue queue = (BlockingQueue)this.queues.get(queueIndex);
        if (queue.size() >= this.currentQueueLimit) {
            return false;
        }
        return queue.offer(callTask);
    }
}

