/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.AbstractService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ServiceNotRunningException;
import org.apache.hadoop.hbase.master.ClusterSchemaService;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ModifyNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ClusterSchemaServiceImpl
extends AbstractService
implements ClusterSchemaService {
    private final TableNamespaceManager tableNamespaceManager;
    private final MasterServices masterServices;
    private static final List<NamespaceDescriptor> EMPTY_NAMESPACE_LIST = Collections.unmodifiableList(new ArrayList(0));

    ClusterSchemaServiceImpl(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.tableNamespaceManager = new TableNamespaceManager(masterServices);
    }

    private synchronized void checkIsRunning() throws ServiceNotRunningException {
        if (!this.isRunning()) {
            throw new ServiceNotRunningException();
        }
    }

    @Override
    protected synchronized void doStart() {
        try {
            this.notifyStarted();
            this.tableNamespaceManager.start();
        }
        catch (IOException ioe) {
            this.notifyFailed(ioe);
        }
    }

    @Override
    protected void doStop() {
        this.notifyStopped();
        TableNamespaceManager tnsm = this.getTableNamespaceManager();
        if (tnsm != null) {
            tnsm.stop("Stopping");
        }
    }

    @Override
    public TableNamespaceManager getTableNamespaceManager() {
        return this.tableNamespaceManager;
    }

    private long submitProcedure(Procedure<MasterProcedureEnv> procedure, NonceKey nonceKey) throws ServiceNotRunningException {
        this.checkIsRunning();
        ProcedureExecutor<MasterProcedureEnv> pe = this.masterServices.getMasterProcedureExecutor();
        return pe.submitProcedure(procedure, nonceKey);
    }

    @Override
    public long createNamespace(NamespaceDescriptor namespaceDescriptor, NonceKey nonceKey, ProcedurePrepareLatch latch) throws IOException {
        return this.submitProcedure((Procedure<MasterProcedureEnv>)new CreateNamespaceProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), namespaceDescriptor, latch), nonceKey);
    }

    @Override
    public long modifyNamespace(NamespaceDescriptor namespaceDescriptor, NonceKey nonceKey, ProcedurePrepareLatch latch) throws IOException {
        return this.submitProcedure((Procedure<MasterProcedureEnv>)new ModifyNamespaceProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), namespaceDescriptor, latch), nonceKey);
    }

    @Override
    public long deleteNamespace(String name2, NonceKey nonceKey, ProcedurePrepareLatch latch) throws IOException {
        return this.submitProcedure((Procedure<MasterProcedureEnv>)new DeleteNamespaceProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), name2, latch), nonceKey);
    }

    @Override
    public NamespaceDescriptor getNamespace(String name2) throws IOException {
        NamespaceDescriptor nsd = this.getTableNamespaceManager().get(name2);
        if (nsd == null) {
            throw new NamespaceNotFoundException(name2);
        }
        return nsd;
    }

    @Override
    public List<NamespaceDescriptor> getNamespaces() throws IOException {
        this.checkIsRunning();
        NavigableSet<NamespaceDescriptor> set = this.getTableNamespaceManager().list();
        if (set == null || set.isEmpty()) {
            return EMPTY_NAMESPACE_LIST;
        }
        ArrayList<NamespaceDescriptor> list = new ArrayList<NamespaceDescriptor>(set.size());
        list.addAll(set);
        return Collections.unmodifiableList(list);
    }
}

