/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MobCompactionChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(MobCompactionChore.class);
    private HMaster master;
    private ExecutorService pool;

    public MobCompactionChore(HMaster master, int period) {
        super(master.getServerName() + "-MobCompactionChore", master, period, period, TimeUnit.SECONDS);
        this.master = master;
        this.pool = MobUtils.createMobCompactorThreadPool(master.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, TableDescriptor> map2 = htds.getAll();
            for (TableDescriptor htd : map2.values()) {
                if (!this.master.getTableStateManager().isTableState(htd.getTableName(), TableState.State.ENABLED)) continue;
                boolean reported = false;
                try {
                    LockManager.MasterLock lock = this.master.getLockManager().createMasterLock(MobUtils.getTableLockName(htd.getTableName()), LockType.EXCLUSIVE, this.getClass().getName() + ": mob compaction");
                    for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                        if (!hcd.isMobEnabled()) continue;
                        if (!reported) {
                            this.master.reportMobCompactionStart(htd.getTableName());
                            reported = true;
                        }
                        MobUtils.doMobCompaction(this.master.getConfiguration(), this.master.getFileSystem(), htd.getTableName(), hcd, this.pool, false, lock);
                    }
                }
                finally {
                    if (!reported) continue;
                    this.master.reportMobCompactionEnd(htd.getTableName());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to compact mob files", (Throwable)e);
        }
    }

    @Override
    protected synchronized void cleanup() {
        super.cleanup();
        this.pool.shutdown();
    }
}

