/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ServerManager {
    public static final String WAIT_ON_REGIONSERVERS_MAXTOSTART = "hbase.master.wait.on.regionservers.maxtostart";
    public static final String WAIT_ON_REGIONSERVERS_MINTOSTART = "hbase.master.wait.on.regionservers.mintostart";
    public static final String WAIT_ON_REGIONSERVERS_TIMEOUT = "hbase.master.wait.on.regionservers.timeout";
    public static final String WAIT_ON_REGIONSERVERS_INTERVAL = "hbase.master.wait.on.regionservers.interval";
    private static final Logger LOG = LoggerFactory.getLogger(ServerManager.class);
    private AtomicBoolean clusterShutdown = new AtomicBoolean(false);
    private final ConcurrentNavigableMap<byte[], Long> flushedSequenceIdByRegion = new ConcurrentSkipListMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private final ConcurrentNavigableMap<byte[], ConcurrentNavigableMap<byte[], Long>> storeFlushedSequenceIdsByRegion = new ConcurrentSkipListMap<byte[], ConcurrentNavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
    private final ConcurrentNavigableMap<ServerName, ServerMetrics> onlineServers = new ConcurrentSkipListMap<ServerName, ServerMetrics>();
    private final Map<ServerName, AdminProtos.AdminService.BlockingInterface> rsAdmins = new HashMap<ServerName, AdminProtos.AdminService.BlockingInterface>();
    private final ArrayList<ServerName> drainingServers = new ArrayList();
    private final MasterServices master;
    private final ClusterConnection connection;
    private final DeadServer deadservers = new DeadServer();
    private final long maxSkew;
    private final long warningSkew;
    private final RpcControllerFactory rpcControllerFactory;
    private List<ServerListener> listeners = new CopyOnWriteArrayList<ServerListener>();

    public ServerManager(MasterServices master) {
        this.master = master;
        Configuration c = master.getConfiguration();
        this.maxSkew = c.getLong("hbase.master.maxclockskew", 30000L);
        this.warningSkew = c.getLong("hbase.master.warningclockskew", 10000L);
        this.connection = master.getClusterConnection();
        this.rpcControllerFactory = this.connection == null ? null : this.connection.getRpcControllerFactory();
    }

    public void registerListener(ServerListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterListener(ServerListener listener) {
        return this.listeners.remove(listener);
    }

    ServerName regionServerStartup(RegionServerStatusProtos.RegionServerStartupRequest request, int versionNumber, String version, InetAddress ia) throws IOException {
        String hostname = request.hasUseThisHostnameInstead() ? request.getUseThisHostnameInstead() : ia.getHostName();
        ServerName sn = ServerName.valueOf(hostname, request.getPort(), request.getServerStartCode());
        this.checkClockSkew(sn, request.getServerCurrentTime());
        this.checkIsDead(sn, "STARTUP");
        if (!this.checkAndRecordNewServer(sn, ServerMetricsBuilder.of(sn, versionNumber, version))) {
            LOG.warn("THIS SHOULD NOT HAPPEN, RegionServerStartup could not record the server: " + sn);
        }
        return sn;
    }

    private void updateLastFlushedSequenceIds(ServerName sn, ServerMetrics hsl) {
        for (Map.Entry<byte[], RegionMetrics> entry : hsl.getRegionMetrics().entrySet()) {
            byte[] encodedRegionName = Bytes.toBytes(RegionInfo.encodeRegionName(entry.getKey()));
            Long existingValue = (Long)this.flushedSequenceIdByRegion.get(encodedRegionName);
            long l = entry.getValue().getCompletedSequenceId();
            if (LOG.isTraceEnabled()) {
                LOG.trace(Bytes.toString(encodedRegionName) + ", existingValue=" + existingValue + ", completeSequenceId=" + l);
            }
            if (existingValue == null || l != -1L && l > existingValue) {
                this.flushedSequenceIdByRegion.put(encodedRegionName, l);
            } else if (l != -1L && l < existingValue) {
                LOG.warn("RegionServer " + sn + " indicates a last flushed sequence id (" + l + ") that is less than the previous last flushed sequence id (" + existingValue + ") for region " + Bytes.toString(entry.getKey()) + " Ignoring.");
            }
            ConcurrentNavigableMap storeFlushedSequenceId = ConcurrentMapUtils.computeIfAbsent(this.storeFlushedSequenceIdsByRegion, encodedRegionName, () -> new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
            for (Map.Entry<byte[], Long> storeSeqId : entry.getValue().getStoreSequenceId().entrySet()) {
                byte[] family = storeSeqId.getKey();
                existingValue = (Long)storeFlushedSequenceId.get(family);
                l = storeSeqId.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace(Bytes.toString(encodedRegionName) + ", family=" + Bytes.toString(family) + ", existingValue=" + existingValue + ", completeSequenceId=" + l);
                }
                if (existingValue != null && (l == -1L || l <= existingValue)) continue;
                storeFlushedSequenceId.put(family, l);
            }
        }
    }

    public void regionServerReport(ServerName sn, ServerMetrics sl) throws YouAreDeadException {
        this.checkIsDead(sn, "REPORT");
        if (null == this.onlineServers.replace(sn, sl) && !this.checkAndRecordNewServer(sn, sl)) {
            LOG.info("RegionServerReport ignored, could not record the server: " + sn);
            return;
        }
        this.updateLastFlushedSequenceIds(sn, sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAndRecordNewServer(ServerName serverName, ServerMetrics sl) {
        ServerName existingServer = null;
        ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            existingServer = this.findServerWithSameHostnamePortWithLock(serverName);
            if (existingServer != null && existingServer.getStartcode() > serverName.getStartcode()) {
                LOG.info("Server serverName=" + serverName + " rejected; we already have " + existingServer.toString() + " registered with same hostname and port");
                return false;
            }
            this.recordNewServerWithLock(serverName, sl);
        }
        if (!this.listeners.isEmpty()) {
            for (ServerListener listener : this.listeners) {
                listener.serverAdded(serverName);
            }
        }
        if (existingServer != null && existingServer.getStartcode() < serverName.getStartcode()) {
            LOG.info("Triggering server recovery; existingServer " + existingServer + " looks stale, new server:" + serverName);
            this.expireServer(existingServer);
        }
        return true;
    }

    void findDeadServersAndProcess(Set<ServerName> deadServersFromPE, Set<ServerName> liveServersFromWALDir) {
        deadServersFromPE.forEach(this.deadservers::putIfAbsent);
        liveServersFromWALDir.stream().filter(sn -> !this.onlineServers.containsKey(sn)).forEach(this::expireServer);
    }

    private void checkClockSkew(ServerName serverName, long serverCurrentTime) throws ClockOutOfSyncException {
        long skew = Math.abs(EnvironmentEdgeManager.currentTime() - serverCurrentTime);
        if (skew > this.maxSkew) {
            String message = "Server " + serverName + " has been rejected; Reported time is too far out of sync with master.  Time difference of " + skew + "ms > max allowed of " + this.maxSkew + "ms";
            LOG.warn(message);
            throw new ClockOutOfSyncException(message);
        }
        if (skew > this.warningSkew) {
            String message = "Reported time for server " + serverName + " is out of sync with master by " + skew + "ms. (Warning threshold is " + this.warningSkew + "ms; error threshold is " + this.maxSkew + "ms)";
            LOG.warn(message);
        }
    }

    private void checkIsDead(ServerName serverName, String what) throws YouAreDeadException {
        if (this.deadservers.isDeadServer(serverName)) {
            String message = "Server " + what + " rejected; currently processing " + serverName + " as dead server";
            LOG.debug(message);
            throw new YouAreDeadException(message);
        }
        if ((this.master == null || this.master.isInitialized()) && this.deadservers.cleanPreviousInstance(serverName)) {
            LOG.debug("{} {} came back up, removed it from the dead servers list", (Object)what, (Object)serverName);
        }
    }

    private ServerName findServerWithSameHostnamePortWithLock(ServerName serverName) {
        ServerName end = ServerName.valueOf(serverName.getHostname(), serverName.getPort(), Long.MAX_VALUE);
        ServerName r = this.onlineServers.lowerKey(end);
        if (r != null && ServerName.isSameAddress(r, serverName)) {
            return r;
        }
        return null;
    }

    void recordNewServerWithLock(ServerName serverName, ServerMetrics sl) {
        LOG.info("Registering regionserver=" + serverName);
        this.onlineServers.put(serverName, sl);
        this.rsAdmins.remove(serverName);
    }

    public ClusterStatusProtos.RegionStoreSequenceIds getLastFlushedSequenceId(byte[] encodedRegionName) {
        ClusterStatusProtos.RegionStoreSequenceIds.Builder builder = ClusterStatusProtos.RegionStoreSequenceIds.newBuilder();
        Long seqId = (Long)this.flushedSequenceIdByRegion.get(encodedRegionName);
        builder.setLastFlushedSequenceId(seqId != null ? seqId : -1L);
        Map storeFlushedSequenceId = (Map)this.storeFlushedSequenceIdsByRegion.get(encodedRegionName);
        if (storeFlushedSequenceId != null) {
            for (Map.Entry entry : storeFlushedSequenceId.entrySet()) {
                builder.addStoreSequenceId(ClusterStatusProtos.StoreSequenceId.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])entry.getKey())).setSequenceId((Long)entry.getValue()).build());
            }
        }
        return builder.build();
    }

    public ServerMetrics getLoad(ServerName serverName) {
        return (ServerMetrics)this.onlineServers.get(serverName);
    }

    public double getAverageLoad() {
        int totalLoad = 0;
        int numServers = 0;
        for (ServerMetrics sl : this.onlineServers.values()) {
            ++numServers;
            totalLoad += sl.getRegionMetrics().size();
        }
        return numServers == 0 ? 0.0 : (double)totalLoad / (double)numServers;
    }

    public int countOfRegionServers() {
        return this.onlineServers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ServerName, ServerMetrics> getOnlineServers() {
        ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            return Collections.unmodifiableMap(this.onlineServers);
        }
    }

    public DeadServer getDeadServers() {
        return this.deadservers;
    }

    public boolean areDeadServersInProgress() {
        return this.deadservers.areDeadServersInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void letRegionServersShutdown() {
        int onlineServersCt;
        long previousLogTime = 0L;
        ServerName sn = this.master.getServerName();
        ZKWatcher zkw = this.master.getZooKeeper();
        while ((onlineServersCt = this.onlineServers.size()) > 0) {
            block17: {
                if (System.currentTimeMillis() > previousLogTime + 1000L) {
                    Set remainingServers = this.onlineServers.keySet();
                    ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
                    synchronized (concurrentNavigableMap) {
                        if (remainingServers.size() == 1 && remainingServers.contains(sn)) {
                            return;
                        }
                    }
                    StringBuilder sb = new StringBuilder();
                    for (ServerName key : remainingServers) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(key);
                    }
                    LOG.info("Waiting on regionserver(s) " + sb.toString());
                    previousLogTime = System.currentTimeMillis();
                }
                try {
                    List<String> servers = this.getRegionServersInZK(zkw);
                    if (servers == null || servers.isEmpty() || servers.size() == 1 && servers.contains(sn.toString())) {
                        LOG.info("ZK shows there is only the master self online, exiting now");
                    }
                    break block17;
                }
                catch (KeeperException ke) {
                    LOG.warn("Failed to list regionservers", (Throwable)ke);
                }
                break;
            }
            ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
            synchronized (concurrentNavigableMap) {
                try {
                    if (onlineServersCt == this.onlineServers.size()) {
                        this.onlineServers.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private List<String> getRegionServersInZK(ZKWatcher zkw) throws KeeperException {
        return ZKUtil.listChildrenNoWatch((ZKWatcher)zkw, (String)zkw.getZNodePaths().rsZNode);
    }

    public synchronized long expireServer(ServerName serverName) {
        return this.expireServer(serverName, false);
    }

    synchronized long expireServer(ServerName serverName, boolean force) {
        if (serverName.equals(this.master.getServerName())) {
            if (!this.master.isAborted() && !this.master.isStopped()) {
                this.master.stop("We lost our znode?");
            }
            return -1L;
        }
        if (this.deadservers.isDeadServer(serverName)) {
            LOG.warn("Expiration called on {} but already in DeadServer", (Object)serverName);
            return -1L;
        }
        this.moveFromOnlineToDeadServers(serverName);
        if (this.master.getZooKeeper() != null) {
            String drainingZnode = ZNodePaths.joinZNode(this.master.getZooKeeper().getZNodePaths().drainingZNode, serverName.getServerName());
            try {
                ZKUtil.deleteNodeFailSilent((ZKWatcher)this.master.getZooKeeper(), (String)drainingZnode);
            }
            catch (KeeperException e) {
                LOG.warn("Error deleting the draining znode for stopping server " + serverName.getServerName(), (Throwable)e);
            }
        }
        if (this.isClusterShutdown()) {
            LOG.info("Cluster shutdown set; " + serverName + " expired; onlineServers=" + this.onlineServers.size());
            if (this.onlineServers.isEmpty()) {
                this.master.stop("Cluster shutdown set; onlineServer=0");
            }
            return -1L;
        }
        LOG.info("Processing expiration of " + serverName + " on " + this.master.getServerName());
        long pid = this.master.getAssignmentManager().submitServerCrash(serverName, true, force);
        if (!this.listeners.isEmpty()) {
            this.listeners.stream().forEach(l -> l.serverRemoved(serverName));
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveFromOnlineToDeadServers(ServerName sn) {
        ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            boolean online = this.onlineServers.containsKey(sn);
            if (online) {
                this.deadservers.putIfAbsent(sn);
                this.onlineServers.remove(sn);
                this.onlineServers.notifyAll();
            } else {
                LOG.trace("Expiration of {} but server not online", (Object)sn);
            }
        }
        this.rsAdmins.remove(sn);
    }

    public synchronized boolean removeServerFromDrainList(ServerName sn) {
        if (!this.isServerOnline(sn)) {
            LOG.warn("Server " + sn + " is not currently online. Removing from draining list anyway, as requested.");
        }
        return this.drainingServers.remove(sn);
    }

    public synchronized boolean addServerToDrainList(ServerName sn) {
        if (!this.isServerOnline(sn)) {
            LOG.warn("Server " + sn + " is not currently online. Ignoring request to add it to draining list.");
            return false;
        }
        if (this.drainingServers.contains(sn)) {
            LOG.warn("Server " + sn + " is already in the draining server list.Ignoring request to add it again.");
            return true;
        }
        LOG.info("Server " + sn + " added to draining server list.");
        return this.drainingServers.add(sn);
    }

    private HBaseRpcController newRpcController() {
        return this.rpcControllerFactory == null ? null : this.rpcControllerFactory.newController();
    }

    public void sendRegionWarmup(ServerName server, RegionInfo region) {
        if (server == null) {
            return;
        }
        try {
            AdminProtos.AdminService.BlockingInterface admin = this.getRsAdmin(server);
            HBaseRpcController controller = this.newRpcController();
            ProtobufUtil.warmupRegion(controller, admin, region);
        }
        catch (IOException e) {
            LOG.error("Received exception in RPC for warmup server:" + server + "region: " + region + "exception: " + e);
        }
    }

    public static void closeRegionSilentlyAndWait(ClusterConnection connection, ServerName server, RegionInfo region, long timeout) throws IOException, InterruptedException {
        AdminProtos.AdminService.BlockingInterface rs = connection.getAdmin(server);
        HBaseRpcController controller = connection.getRpcControllerFactory().newController();
        try {
            ProtobufUtil.closeRegion(controller, rs, server, region.getRegionName());
        }
        catch (IOException e) {
            LOG.warn("Exception when closing region: " + region.getRegionNameAsString(), (Throwable)e);
        }
        if (timeout < 0L) {
            return;
        }
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            controller.reset();
            try {
                RegionInfo rsRegion = ProtobufUtil.getRegionInfo(controller, rs, region.getRegionName());
                if (rsRegion == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                if (ioe instanceof NotServingRegionException || ioe instanceof RemoteWithExtrasException && ((RemoteWithExtrasException)((Object)ioe)).unwrapRemoteException() instanceof NotServingRegionException) {
                    return;
                }
                LOG.warn("Exception when retrieving regioninfo from: " + region.getRegionNameAsString(), (Throwable)ioe);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to close within timeout " + timeout);
    }

    public AdminProtos.AdminService.BlockingInterface getRsAdmin(ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.rsAdmins.get(sn);
        if (admin == null) {
            LOG.debug("New admin connection to " + sn.toString());
            admin = sn.equals(this.master.getServerName()) && this.master instanceof HRegionServer ? ((HRegionServer)((Object)this.master)).getRSRpcServices() : this.connection.getAdmin(sn);
            this.rsAdmins.put(sn, admin);
        }
        return admin;
    }

    private int getMinToStart() {
        if (this.master.isInMaintenanceMode()) {
            return 1;
        }
        int minimumRequired = 1;
        if (LoadBalancer.isTablesOnMaster(this.master.getConfiguration()) && LoadBalancer.isSystemTablesOnlyOnMaster(this.master.getConfiguration())) {
            minimumRequired = 2;
        }
        int minToStart = this.master.getConfiguration().getInt(WAIT_ON_REGIONSERVERS_MINTOSTART, -1);
        return Math.max(minToStart, minimumRequired);
    }

    public void waitForRegionServers(MonitoredTask status) throws InterruptedException {
        long now;
        long interval = this.master.getConfiguration().getLong(WAIT_ON_REGIONSERVERS_INTERVAL, 1500L);
        long timeout = this.master.getConfiguration().getLong(WAIT_ON_REGIONSERVERS_TIMEOUT, 4500L);
        int minToStart = this.getMinToStart();
        int maxToStart = this.master.getConfiguration().getInt(WAIT_ON_REGIONSERVERS_MAXTOSTART, Integer.MAX_VALUE);
        if (maxToStart < minToStart) {
            LOG.warn(String.format("The value of '%s' (%d) is set less than '%s' (%d), ignoring.", WAIT_ON_REGIONSERVERS_MAXTOSTART, maxToStart, WAIT_ON_REGIONSERVERS_MINTOSTART, minToStart));
            maxToStart = Integer.MAX_VALUE;
        }
        long startTime = now = System.currentTimeMillis();
        long slept = 0L;
        long lastLogTime = 0L;
        long lastCountChange = startTime;
        int count = this.countOfRegionServers();
        int oldCount = 0;
        for (ServerListener listener : this.listeners) {
            listener.waiting();
        }
        while (!(this.master.isStopped() || this.isClusterShutdown() || count >= maxToStart || lastCountChange + interval <= now && timeout <= slept && count >= minToStart)) {
            if (oldCount != count || lastLogTime + interval < now) {
                lastLogTime = now;
                String msg = "Waiting on regionserver count=" + count + "; waited=" + slept + "ms, expecting min=" + minToStart + " server(s), max=" + this.getStrForMax(maxToStart) + " server(s), timeout=" + timeout + "ms, lastChange=" + (now - lastCountChange) + "ms";
                LOG.info(msg);
                status.setStatus(msg);
            }
            long sleepTime = 50L;
            Thread.sleep(50L);
            now = System.currentTimeMillis();
            slept = now - startTime;
            oldCount = count;
            count = this.countOfRegionServers();
            if (count == oldCount) continue;
            lastCountChange = now;
        }
        if (this.isClusterShutdown()) {
            this.master.stop("Cluster shutdown");
        }
        LOG.info("Finished waiting on RegionServer count=" + count + "; waited=" + slept + "ms, expected min=" + minToStart + " server(s), max=" + this.getStrForMax(maxToStart) + " server(s), master is " + (this.master.isStopped() ? "stopped." : "running"));
    }

    private String getStrForMax(int max) {
        return max == Integer.MAX_VALUE ? "NO_LIMIT" : Integer.toString(max);
    }

    public List<ServerName> getOnlineServersList() {
        return new ArrayList<ServerName>(this.onlineServers.keySet());
    }

    public List<ServerName> getOnlineServersListWithPredicator(List<ServerName> keys2, Predicate<ServerMetrics> idleServerPredicator) {
        ArrayList<ServerName> names = new ArrayList<ServerName>();
        if (keys2 != null && idleServerPredicator != null) {
            keys2.forEach(name2 -> {
                ServerMetrics load = (ServerMetrics)this.onlineServers.get(name2);
                if (load != null && idleServerPredicator.test(load)) {
                    names.add((ServerName)name2);
                }
            });
        }
        return names;
    }

    public List<ServerName> getDrainingServersList() {
        return new ArrayList<ServerName>(this.drainingServers);
    }

    public boolean isServerOnline(ServerName serverName) {
        return serverName != null && this.onlineServers.containsKey(serverName);
    }

    public synchronized ServerLiveState isServerKnownAndOnline(ServerName serverName) {
        return this.onlineServers.containsKey(serverName) ? ServerLiveState.LIVE : (this.deadservers.isDeadServer(serverName) ? ServerLiveState.DEAD : ServerLiveState.UNKNOWN);
    }

    public synchronized boolean isServerDead(ServerName serverName) {
        return serverName == null || this.deadservers.isDeadServer(serverName);
    }

    public boolean isServerUnknown(ServerName serverName) {
        return serverName == null || !this.onlineServers.containsKey(serverName) && !this.deadservers.isDeadServer(serverName);
    }

    public void shutdownCluster() {
        String statusStr = "Cluster shutdown requested of master=" + this.master.getServerName();
        LOG.info(statusStr);
        this.clusterShutdown.set(true);
        if (this.onlineServers.isEmpty()) {
            this.master.stop("OnlineServer=0 right after cluster shutdown set");
        }
    }

    public boolean isClusterShutdown() {
        return this.clusterShutdown.get();
    }

    public void stop() {
    }

    public List<ServerName> createDestinationServersList(List<ServerName> serversToExclude) {
        List<ServerName> destServers = this.getOnlineServersList();
        if (serversToExclude != null) {
            destServers.removeAll(serversToExclude);
        }
        List<ServerName> drainingServersCopy = this.getDrainingServersList();
        destServers.removeAll(drainingServersCopy);
        return destServers;
    }

    public List<ServerName> createDestinationServersList() {
        return this.createDestinationServersList(null);
    }

    void clearDeadServersWithSameHostNameAndPortOfOnlineServer() {
        for (ServerName serverName : this.getOnlineServersList()) {
            this.deadservers.cleanAllPreviousInstances(serverName);
        }
    }

    public void removeRegion(RegionInfo regionInfo) {
        byte[] encodedName = regionInfo.getEncodedNameAsBytes();
        this.storeFlushedSequenceIdsByRegion.remove(encodedName);
        this.flushedSequenceIdByRegion.remove(encodedName);
    }

    public boolean isRegionInServerManagerStates(RegionInfo hri) {
        byte[] encodedName = hri.getEncodedNameAsBytes();
        return this.storeFlushedSequenceIdsByRegion.containsKey(encodedName) || this.flushedSequenceIdByRegion.containsKey(encodedName);
    }

    public void removeRegions(List<RegionInfo> regions) {
        for (RegionInfo hri : regions) {
            this.removeRegion(hri);
        }
    }

    public int getVersionNumber(ServerName serverName) {
        ServerMetrics serverMetrics = (ServerMetrics)this.onlineServers.get(serverName);
        return serverMetrics != null ? serverMetrics.getVersionNumber() : 0;
    }

    public String getVersion(ServerName serverName) {
        ServerMetrics serverMetrics = (ServerMetrics)this.onlineServers.get(serverName);
        return serverMetrics != null ? serverMetrics.getVersion() : "0.0.0";
    }

    public int getInfoPort(ServerName serverName) {
        ServerMetrics serverMetrics = (ServerMetrics)this.onlineServers.get(serverName);
        return serverMetrics != null ? serverMetrics.getInfoServerPort() : 0;
    }

    public static enum ServerLiveState {
        LIVE,
        DEAD,
        UNKNOWN;

    }
}

