/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.hadoop.hbase.master.assignment.ServerStateNode;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionStates {
    private static final Logger LOG = LoggerFactory.getLogger(RegionStates.class);
    public static final RegionStateStampComparator REGION_STATE_STAMP_COMPARATOR = new RegionStateStampComparator();
    private final ConcurrentSkipListMap<byte[], RegionStateNode> regionsMap = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private final ConcurrentSkipListMap<RegionInfo, RegionStateNode> regionInTransition = new ConcurrentSkipListMap(RegionInfo.COMPARATOR);
    private final ConcurrentSkipListMap<RegionInfo, RegionStateNode> regionOffline = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<byte[], RegionFailedOpen> regionFailedOpen = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private final ConcurrentHashMap<ServerName, ServerStateNode> serverMap = new ConcurrentHashMap();

    public void clear() {
        this.regionsMap.clear();
        this.regionInTransition.clear();
        this.regionOffline.clear();
        this.serverMap.clear();
    }

    public boolean isRegionInRegionStates(RegionInfo hri) {
        return this.regionsMap.containsKey(hri.getRegionName()) || this.regionInTransition.containsKey(hri) || this.regionOffline.containsKey(hri);
    }

    RegionStateNode createRegionStateNode(RegionInfo regionInfo) {
        RegionStateNode newNode = new RegionStateNode(regionInfo, this.regionInTransition);
        RegionStateNode oldNode = this.regionsMap.putIfAbsent(regionInfo.getRegionName(), newNode);
        return oldNode != null ? oldNode : newNode;
    }

    public RegionStateNode getOrCreateRegionStateNode(RegionInfo regionInfo) {
        RegionStateNode node = this.getRegionStateNodeFromName(regionInfo.getRegionName());
        return node != null ? node : this.createRegionStateNode(regionInfo);
    }

    RegionStateNode getRegionStateNodeFromName(byte[] regionName) {
        return this.regionsMap.get(regionName);
    }

    public RegionStateNode getRegionStateNode(RegionInfo regionInfo) {
        return this.getRegionStateNodeFromName(regionInfo.getRegionName());
    }

    public void deleteRegion(RegionInfo regionInfo) {
        this.regionsMap.remove(regionInfo.getRegionName());
        if (this.regionInTransition.containsKey(regionInfo)) {
            this.regionInTransition.remove(regionInfo);
        }
        if (this.regionOffline.containsKey(regionInfo)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removing from regionOffline Map: " + regionInfo);
            }
            this.regionOffline.remove(regionInfo);
        }
    }

    public void deleteRegions(List<RegionInfo> regionInfos) {
        regionInfos.forEach(this::deleteRegion);
    }

    List<RegionStateNode> getTableRegionStateNodes(TableName tableName) {
        RegionStateNode node;
        ArrayList<RegionStateNode> regions = new ArrayList<RegionStateNode>();
        Iterator iterator2 = this.regionsMap.tailMap((Object)tableName.getName()).values().iterator();
        while (iterator2.hasNext() && (node = (RegionStateNode)iterator2.next()).getTable().equals(tableName)) {
            regions.add(node);
        }
        return regions;
    }

    ArrayList<RegionState> getTableRegionStates(TableName tableName) {
        RegionStateNode node;
        ArrayList<RegionState> regions = new ArrayList<RegionState>();
        Iterator iterator2 = this.regionsMap.tailMap((Object)tableName.getName()).values().iterator();
        while (iterator2.hasNext() && (node = (RegionStateNode)iterator2.next()).getTable().equals(tableName)) {
            regions.add(node.toRegionState());
        }
        return regions;
    }

    ArrayList<RegionInfo> getTableRegionsInfo(TableName tableName) {
        RegionStateNode node;
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>();
        Iterator iterator2 = this.regionsMap.tailMap((Object)tableName.getName()).values().iterator();
        while (iterator2.hasNext() && (node = (RegionStateNode)iterator2.next()).getTable().equals(tableName)) {
            regions.add(node.getRegionInfo());
        }
        return regions;
    }

    public Collection<RegionStateNode> getRegionStateNodes() {
        return Collections.unmodifiableCollection(this.regionsMap.values());
    }

    public ArrayList<RegionState> getRegionStates() {
        ArrayList<RegionState> regions = new ArrayList<RegionState>(this.regionsMap.size());
        for (RegionStateNode node : this.regionsMap.values()) {
            regions.add(node.toRegionState());
        }
        return regions;
    }

    public RegionState getRegionState(RegionInfo regionInfo) {
        RegionStateNode regionStateNode = this.getRegionStateNode(regionInfo);
        return regionStateNode == null ? null : regionStateNode.toRegionState();
    }

    public RegionState getRegionState(String encodedRegionName) {
        for (RegionStateNode node : this.regionsMap.values()) {
            if (!node.getRegionInfo().getEncodedName().equals(encodedRegionName)) continue;
            return node.toRegionState();
        }
        return null;
    }

    public boolean hasTableRegionStates(TableName tableName) {
        return !this.getTableRegionStates(tableName).isEmpty();
    }

    public List<RegionInfo> getRegionsOfTable(TableName table) {
        return this.getRegionsOfTable(table, regionNode -> !regionNode.isInState(RegionState.State.OFFLINE, RegionState.State.SPLIT) && !regionNode.getRegionInfo().isSplitParent());
    }

    private HRegionLocation createRegionForReopen(RegionStateNode node) {
        node.lock();
        try {
            if (!this.include(node, false)) {
                HRegionLocation hRegionLocation = null;
                return hRegionLocation;
            }
            if (node.isInState(RegionState.State.OPEN)) {
                HRegionLocation hRegionLocation = new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), node.getOpenSeqNum());
                return hRegionLocation;
            }
            if (node.isInState(RegionState.State.OPENING)) {
                HRegionLocation hRegionLocation = new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), -1L);
                return hRegionLocation;
            }
            HRegionLocation hRegionLocation = null;
            return hRegionLocation;
        }
        finally {
            node.unlock();
        }
    }

    public List<HRegionLocation> getRegionsOfTableForReopen(TableName tableName) {
        return this.getTableRegionStateNodes(tableName).stream().map(this::createRegionForReopen).filter(r -> r != null).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HRegionLocation checkReopened(HRegionLocation oldLoc) {
        RegionStateNode node = this.getRegionStateNode(oldLoc.getRegion());
        if (node == null) {
            return null;
        }
        node.lock();
        try {
            if (oldLoc.getSeqNum() >= 0L) {
                if (node.isInState(RegionState.State.OPEN)) {
                    if (node.getOpenSeqNum() > oldLoc.getSeqNum()) {
                        HRegionLocation hRegionLocation = null;
                        return hRegionLocation;
                    }
                    HRegionLocation hRegionLocation = new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), node.getOpenSeqNum());
                    return hRegionLocation;
                }
                HRegionLocation hRegionLocation = null;
                return hRegionLocation;
            }
            if (!node.isInState(RegionState.State.OPEN, RegionState.State.OPENING)) {
                HRegionLocation hRegionLocation = null;
                return hRegionLocation;
            }
            if (!node.getRegionLocation().equals(oldLoc.getServerName())) {
                HRegionLocation hRegionLocation = null;
                return hRegionLocation;
            }
            long openSeqNum = node.isInState(RegionState.State.OPEN) ? node.getOpenSeqNum() : -1L;
            HRegionLocation hRegionLocation = new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), openSeqNum);
            return hRegionLocation;
        }
        finally {
            node.unlock();
        }
    }

    public List<RegionInfo> getRegionsOfTableForEnabling(TableName table) {
        return this.getRegionsOfTable(table, regionNode -> !regionNode.isInState(RegionState.State.SPLIT) && !regionNode.getRegionInfo().isSplit());
    }

    public List<RegionInfo> getRegionsOfTableForDeleting(TableName table) {
        return this.getTableRegionStateNodes(table).stream().map(RegionStateNode::getRegionInfo).collect(Collectors.toList());
    }

    private List<RegionInfo> getRegionsOfTable(TableName table, Predicate<RegionStateNode> filter) {
        return this.getTableRegionStateNodes(table).stream().filter(filter).map(n -> n.getRegionInfo()).collect(Collectors.toList());
    }

    private boolean include(RegionStateNode node, boolean offline) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("WORKING ON " + node + " " + node.getRegionInfo());
        }
        RegionInfo hri = node.getRegionInfo();
        if (node.isInState(RegionState.State.SPLIT) || hri.isSplit()) {
            return false;
        }
        if ((node.isInState(RegionState.State.OFFLINE) || hri.isOffline()) && !offline) {
            return false;
        }
        return !hri.isOffline() && !hri.isSplit() || (hri.isOffline() || hri.isSplit()) && offline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerState(ServerName serverName, ServerState state) {
        ServerStateNode serverNode;
        ServerStateNode serverStateNode = serverNode = this.getOrCreateServer(serverName);
        synchronized (serverStateNode) {
            serverNode.setState(state);
        }
    }

    public void metaLogSplitting(ServerName serverName) {
        this.setServerState(serverName, ServerState.SPLITTING_META);
    }

    public void metaLogSplit(ServerName serverName) {
        this.setServerState(serverName, ServerState.SPLITTING_META_DONE);
    }

    public void logSplitting(ServerName serverName) {
        this.setServerState(serverName, ServerState.SPLITTING);
    }

    public void logSplit(ServerName serverName) {
        this.setServerState(serverName, ServerState.OFFLINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegionState(RegionInfo regionInfo, RegionState.State state) {
        RegionStateNode regionNode = this.getOrCreateRegionStateNode(regionInfo);
        regionNode.lock();
        try {
            regionNode.setState(state, new RegionState.State[0]);
        }
        finally {
            regionNode.unlock();
        }
    }

    public List<RegionInfo> getAssignedRegions() {
        ArrayList<RegionInfo> result2 = new ArrayList<RegionInfo>();
        for (RegionStateNode node : this.regionsMap.values()) {
            if (node.isInTransition()) continue;
            result2.add(node.getRegionInfo());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegionInState(RegionInfo regionInfo, RegionState.State ... state) {
        RegionStateNode regionNode = this.getRegionStateNode(regionInfo);
        if (regionNode != null) {
            regionNode.lock();
            try {
                boolean bl = regionNode.isInState(state);
                return bl;
            }
            finally {
                regionNode.unlock();
            }
        }
        return false;
    }

    public boolean isRegionOnline(RegionInfo regionInfo) {
        return this.isRegionInState(regionInfo, RegionState.State.OPEN);
    }

    public boolean isRegionOffline(RegionInfo regionInfo) {
        return this.isRegionInState(regionInfo, RegionState.State.OFFLINE, RegionState.State.CLOSED);
    }

    public Map<ServerName, List<RegionInfo>> getSnapShotOfAssignment(Collection<RegionInfo> regions) {
        HashMap<ServerName, List<RegionInfo>> result2 = new HashMap<ServerName, List<RegionInfo>>();
        if (regions != null) {
            for (RegionInfo hri : regions) {
                RegionStateNode node = this.getRegionStateNode(hri);
                if (node == null) continue;
                this.createSnapshot(node, result2);
            }
        } else {
            for (RegionStateNode node : this.regionsMap.values()) {
                if (node == null) continue;
                this.createSnapshot(node, result2);
            }
        }
        return result2;
    }

    private void createSnapshot(RegionStateNode node, Map<ServerName, List<RegionInfo>> result2) {
        ServerName serverName = node.getRegionLocation();
        if (serverName == null) {
            return;
        }
        List<RegionInfo> serverRegions = result2.get(serverName);
        if (serverRegions == null) {
            serverRegions = new ArrayList<RegionInfo>();
            result2.put(serverName, serverRegions);
        }
        serverRegions.add(node.getRegionInfo());
    }

    public Map<RegionInfo, ServerName> getRegionAssignments() {
        HashMap<RegionInfo, ServerName> assignments = new HashMap<RegionInfo, ServerName>();
        for (RegionStateNode node : this.regionsMap.values()) {
            assignments.put(node.getRegionInfo(), node.getRegionLocation());
        }
        return assignments;
    }

    public Map<RegionState.State, List<RegionInfo>> getRegionByStateOfTable(TableName tableName) {
        RegionState.State[] states = RegionState.State.values();
        HashMap<RegionState.State, List<RegionInfo>> tableRegions = new HashMap<RegionState.State, List<RegionInfo>>(states.length);
        for (int i = 0; i < states.length; ++i) {
            tableRegions.put(states[i], new ArrayList());
        }
        for (RegionStateNode node : this.regionsMap.values()) {
            if (!node.getTable().equals(tableName)) continue;
            ((List)tableRegions.get((Object)node.getState())).add(node.getRegionInfo());
        }
        return tableRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerName getRegionServerOfRegion(RegionInfo regionInfo) {
        RegionStateNode regionNode = this.getRegionStateNode(regionInfo);
        if (regionNode != null) {
            regionNode.lock();
            try {
                ServerName server = regionNode.getRegionLocation();
                ServerName serverName = server != null ? server : regionNode.getLastHost();
                return serverName;
            }
            finally {
                regionNode.unlock();
            }
        }
        return null;
    }

    public Map<TableName, Map<ServerName, List<RegionInfo>>> getAssignmentsForBalancer(TableStateManager tableStateManager, List<ServerName> onlineServers) {
        HashMap<TableName, Map<ServerName, List<RegionInfo>>> result2 = new HashMap<TableName, Map<ServerName, List<RegionInfo>>>();
        for (RegionStateNode node : this.regionsMap.values()) {
            if (this.isTableDisabled(tableStateManager, node.getTable())) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Ignoring {} because table is disabled", (Object)node);
                continue;
            }
            if (!node.isInState(RegionState.State.OPEN, RegionState.State.OPENING)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Ignoring {} because region is not OPEN or OPENING", (Object)node);
                continue;
            }
            Map tableResult = result2.computeIfAbsent(node.getTable(), t -> new HashMap());
            ServerName serverName = node.getRegionLocation();
            if (serverName == null) {
                LOG.warn("Skipping, no server for {}", (Object)node);
                continue;
            }
            List serverResult = tableResult.computeIfAbsent(serverName, s -> new ArrayList());
            serverResult.add(node.getRegionInfo());
        }
        for (Map table : result2.values()) {
            for (ServerName serverName : onlineServers) {
                table.computeIfAbsent(serverName, key -> new ArrayList());
            }
        }
        return result2;
    }

    private boolean isTableDisabled(TableStateManager tableStateManager, TableName tableName) {
        return tableStateManager.isTableState(tableName, TableState.State.DISABLED, TableState.State.DISABLING);
    }

    public boolean hasRegionsInTransition() {
        return !this.regionInTransition.isEmpty();
    }

    public boolean isRegionInTransition(RegionInfo regionInfo) {
        RegionStateNode node = this.regionInTransition.get(regionInfo);
        return node != null ? node.isInTransition() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionState getRegionTransitionState(RegionInfo hri) {
        RegionStateNode node = this.regionInTransition.get(hri);
        if (node == null) {
            return null;
        }
        node.lock();
        try {
            RegionState regionState = node.isInTransition() ? node.toRegionState() : null;
            return regionState;
        }
        finally {
            node.unlock();
        }
    }

    public List<RegionStateNode> getRegionsInTransition() {
        return new ArrayList<RegionStateNode>(this.regionInTransition.values());
    }

    public int getRegionsInTransitionCount() {
        return this.regionInTransition.size();
    }

    public List<RegionState> getRegionsStateInTransition() {
        ArrayList<RegionState> rit = new ArrayList<RegionState>(this.regionInTransition.size());
        for (RegionStateNode node : this.regionInTransition.values()) {
            rit.add(node.toRegionState());
        }
        return rit;
    }

    public SortedSet<RegionState> getRegionsInTransitionOrderedByTimestamp() {
        TreeSet<RegionState> rit = new TreeSet<RegionState>(REGION_STATE_STAMP_COMPARATOR);
        for (RegionStateNode node : this.regionInTransition.values()) {
            rit.add(node.toRegionState());
        }
        return rit;
    }

    public void addToOfflineRegions(RegionStateNode regionNode) {
        LOG.info("Added to offline, CURRENTLY NEVER CLEARED!!! " + regionNode);
        this.regionOffline.put(regionNode.getRegionInfo(), regionNode);
    }

    public void removeFromOfflineRegions(RegionInfo regionInfo) {
        this.regionOffline.remove(regionInfo);
    }

    public RegionFailedOpen addToFailedOpen(RegionStateNode regionNode) {
        byte[] key = regionNode.getRegionInfo().getRegionName();
        RegionFailedOpen node = this.regionFailedOpen.get(key);
        if (node == null) {
            RegionFailedOpen newNode = new RegionFailedOpen(regionNode);
            RegionFailedOpen oldNode = this.regionFailedOpen.putIfAbsent(key, newNode);
            node = oldNode != null ? oldNode : newNode;
        }
        return node;
    }

    public RegionFailedOpen getFailedOpen(RegionInfo regionInfo) {
        return this.regionFailedOpen.get(regionInfo.getRegionName());
    }

    public void removeFromFailedOpen(RegionInfo regionInfo) {
        this.regionFailedOpen.remove(regionInfo.getRegionName());
    }

    public List<RegionState> getRegionFailedOpen() {
        if (this.regionFailedOpen.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegionState> regions = new ArrayList<RegionState>(this.regionFailedOpen.size());
        for (RegionFailedOpen r : this.regionFailedOpen.values()) {
            regions.add(r.getRegionStateNode().toRegionState());
        }
        return regions;
    }

    public ServerStateNode getOrCreateServer(ServerName serverName) {
        ServerStateNode node = this.serverMap.get(serverName);
        if (node == null) {
            node = new ServerStateNode(serverName);
            ServerStateNode oldNode = this.serverMap.putIfAbsent(serverName, node);
            node = oldNode != null ? oldNode : node;
        }
        return node;
    }

    public void removeServer(ServerName serverName) {
        this.serverMap.remove(serverName);
    }

    public ServerStateNode getServerNode(ServerName serverName) {
        return this.serverMap.get(serverName);
    }

    public double getAverageLoad() {
        int numServers = 0;
        int totalLoad = 0;
        for (ServerStateNode node : this.serverMap.values()) {
            totalLoad += node.getRegionCount();
            ++numServers;
        }
        return numServers == 0 ? 0.0 : (double)totalLoad / (double)numServers;
    }

    public ServerStateNode addRegionToServer(RegionStateNode regionNode) {
        ServerStateNode serverNode = this.getOrCreateServer(regionNode.getRegionLocation());
        serverNode.addRegion(regionNode);
        return serverNode;
    }

    public ServerStateNode removeRegionFromServer(ServerName serverName, RegionStateNode regionNode) {
        ServerStateNode serverNode = this.getOrCreateServer(serverName);
        serverNode.removeRegion(regionNode);
        return serverNode;
    }

    public static String regionNamesToString(Collection<byte[]> regions) {
        StringBuilder sb = new StringBuilder();
        Iterator<byte[]> it = regions.iterator();
        sb.append("[");
        if (it.hasNext()) {
            sb.append(Bytes.toStringBinary(it.next()));
            while (it.hasNext()) {
                sb.append(", ");
                sb.append(Bytes.toStringBinary(it.next()));
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static final class RegionFailedOpen {
        private final RegionStateNode regionNode;
        private volatile Exception exception = null;
        private AtomicInteger retries = new AtomicInteger();

        public RegionFailedOpen(RegionStateNode regionNode) {
            this.regionNode = regionNode;
        }

        public RegionStateNode getRegionStateNode() {
            return this.regionNode;
        }

        public RegionInfo getRegionInfo() {
            return this.regionNode.getRegionInfo();
        }

        public int incrementAndGetRetries() {
            return this.retries.incrementAndGet();
        }

        public int getRetries() {
            return this.retries.get();
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    private static class RegionStateStampComparator
    implements Comparator<RegionState> {
        private RegionStateStampComparator() {
        }

        @Override
        public int compare(RegionState l, RegionState r) {
            int stampCmp = Long.compare(l.getStamp(), r.getStamp());
            return stampCmp != 0 ? stampCmp : RegionInfo.COMPARATOR.compare(l.getRegion(), r.getRegion());
        }
    }
}

