/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MetricsAssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.CloseRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.OpenRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionRemoteProcedureBase;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TransitRegionStateProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.RegionStateTransitionState> {
    private static final Logger LOG = LoggerFactory.getLogger(TransitRegionStateProcedure.class);
    private TransitionType type;
    private MasterProcedureProtos.RegionStateTransitionState initialState;
    private MasterProcedureProtos.RegionStateTransitionState lastState;
    private ServerName assignCandidate;
    private boolean forceNewPlan;
    private RetryCounter retryCounter;
    private RegionRemoteProcedureBase remoteProc;

    public TransitRegionStateProcedure() {
    }

    private void setInitialAndLastState() {
        switch (this.type) {
            case ASSIGN: {
                this.initialState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE;
                this.lastState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED;
                break;
            }
            case UNASSIGN: {
                this.initialState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE;
                this.lastState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED;
                break;
            }
            case MOVE: 
            case REOPEN: {
                this.initialState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE;
                this.lastState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown TransitionType: " + (Object)((Object)this.type));
            }
        }
    }

    protected TransitRegionStateProcedure(MasterProcedureEnv env, RegionInfo hri, ServerName assignCandidate, boolean forceNewPlan, TransitionType type2) {
        super(env, hri);
        this.assignCandidate = assignCandidate;
        this.forceNewPlan = forceNewPlan;
        this.type = type2;
        this.setInitialAndLastState();
        if (type2 == TransitionType.REOPEN) {
            this.assignCandidate = this.getRegionStateNode(env).getRegionLocation();
        }
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        if (TableName.isMetaTableName(this.getTableName())) {
            return false;
        }
        AssignmentManager am = env.getAssignmentManager();
        return am.waitMetaLoaded((Procedure<?>)this) || am.waitMetaAssigned((Procedure<?>)this, this.getRegion());
    }

    private void queueAssign(MasterProcedureEnv env, RegionStateNode regionNode) throws ProcedureSuspendedException {
        boolean retain = false;
        if (this.forceNewPlan) {
            regionNode.setRegionLocation(null);
        } else if (this.assignCandidate != null) {
            retain = this.assignCandidate.equals(regionNode.getLastHost());
            regionNode.setRegionLocation(this.assignCandidate);
        } else if (regionNode.getLastHost() != null) {
            retain = true;
            LOG.info("Setting lastHost as the region location {}", (Object)regionNode.getLastHost());
            regionNode.setRegionLocation(regionNode.getLastHost());
        }
        LOG.info("Starting {}; {}; forceNewPlan={}, retain={}", new Object[]{this, regionNode.toShortString(), this.forceNewPlan, retain});
        env.getAssignmentManager().queueAssign(regionNode);
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_OPEN);
        if (regionNode.getProcedureEvent().suspendIfNotReady((Procedure)this)) {
            throw new ProcedureSuspendedException();
        }
    }

    private void openRegion(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        ServerName loc = regionNode.getRegionLocation();
        if (loc == null || LoadBalancer.BOGUS_SERVER_NAME.equals(loc)) {
            LOG.warn("No location specified for {}, jump back to state {} to get one", (Object)this.getRegion(), (Object)MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
            throw new HBaseIOException("Failed to open region, the location is null or bogus.");
        }
        env.getAssignmentManager().regionOpening(regionNode);
        this.addChildProcedure(new OpenRegionProcedure[]{new OpenRegionProcedure(this, this.getRegion(), loc)});
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED);
    }

    private StateMachineProcedure.Flow confirmOpened(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.OPEN)) {
            this.retryCounter = null;
            if (this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED) {
                regionNode.unsetProcedure(this);
                ServerCrashProcedure.updateProgress(env, this.getParentProcId());
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        int retries = env.getAssignmentManager().getRegionStates().addToFailedOpen(regionNode).incrementAndGetRetries();
        int maxAttempts = env.getAssignmentManager().getAssignMaxAttempts();
        LOG.info("Retry={} of max={}; {}; {}", new Object[]{retries, maxAttempts, this, regionNode.toShortString()});
        if (retries >= maxAttempts) {
            env.getAssignmentManager().regionFailedOpen(regionNode, true);
            this.setFailure(this.getClass().getSimpleName(), new RetriesExhaustedException("Max attempts " + env.getAssignmentManager().getAssignMaxAttempts() + " exceeded"));
            regionNode.unsetProcedure(this);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        env.getAssignmentManager().regionFailedOpen(regionNode, false);
        this.forceNewPlan = true;
        regionNode.setRegionLocation(null);
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
        if (retries > env.getAssignmentManager().getAssignRetryImmediatelyMaxAttempts()) {
            throw new HBaseIOException("Failed confirm OPEN of " + regionNode + " (remote log may yield more detail on why).");
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void closeRegion(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.OPEN, RegionState.State.CLOSING, RegionState.State.MERGING, RegionState.State.SPLITTING)) {
            env.getAssignmentManager().regionClosing(regionNode);
            this.addChildProcedure(new CloseRegionProcedure[]{new CloseRegionProcedure(this, this.getRegion(), regionNode.getRegionLocation(), this.assignCandidate)});
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED);
        } else {
            this.forceNewPlan = true;
            regionNode.setRegionLocation(null);
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
        }
    }

    private StateMachineProcedure.Flow confirmClosed(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.CLOSED)) {
            this.retryCounter = null;
            if (this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED) {
                regionNode.unsetProcedure(this);
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        if (regionNode.isInState(RegionState.State.CLOSING)) {
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE);
            throw new HBaseIOException("Failed to close region");
        }
        assert (regionNode.isInState(RegionState.State.ABNORMALLY_CLOSED));
        if (!RegionReplicaUtil.isDefaultReplica(this.getRegion()) && this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED) {
            regionNode.unsetProcedure(this);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        this.retryCounter = null;
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegion());
        regionNode.lock();
        try {
            Procedure[] procedureArray = super.execute((Object)env);
            return procedureArray;
        }
        finally {
            regionNode.unlock();
        }
    }

    private RegionStateNode getRegionStateNode(MasterProcedureEnv env) {
        return env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegion());
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.RegionStateTransitionState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        RegionStateNode regionNode = this.getRegionStateNode(env);
        try {
            switch (state) {
                case REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE: {
                    if (!RegionReplicaUtil.isDefaultReplica(regionNode.getRegionInfo())) {
                        RegionInfo defaultRI = RegionReplicaUtil.getRegionInfoForDefaultReplica(regionNode.getRegionInfo());
                        if (env.getMasterServices().getAssignmentManager().getRegionStates().getRegionStateNode(defaultRI) == null) {
                            LOG.error("Cannot assign replica region {} because its primary region {} does not exist.", (Object)regionNode.getRegionInfo(), (Object)defaultRI);
                            regionNode.unsetProcedure(this);
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                    }
                    this.queueAssign(env, regionNode);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case REGION_STATE_TRANSITION_OPEN: {
                    this.openRegion(env, regionNode);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case REGION_STATE_TRANSITION_CONFIRM_OPENED: {
                    return this.confirmOpened(env, regionNode);
                }
                case REGION_STATE_TRANSITION_CLOSE: {
                    this.closeRegion(env, regionNode);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case REGION_STATE_TRANSITION_CONFIRM_CLOSED: {
                    return this.confirmClosed(env, regionNode);
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (IOException e) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
            }
            long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.warn("Failed transition, suspend {}secs {}; {}; waiting on rectified condition fixed by other Procedure or operator intervention", new Object[]{backoff / 1000L, this, regionNode.toShortString(), e});
            this.setTimeout(Math.toIntExact(backoff));
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront((Procedure)this);
        return false;
    }

    public void reportTransition(MasterProcedureEnv env, RegionStateNode regionNode, ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long seqId, long procId) throws IOException {
        if (this.remoteProc == null) {
            LOG.warn("There is no outstanding remote region procedure for {}, serverName={}, code={}, seqId={}, proc={}, should be a retry, ignore", new Object[]{regionNode, serverName, code, seqId, this});
            return;
        }
        if (procId >= 0L && this.remoteProc.getProcId() != procId) {
            LOG.warn("The pid of remote region procedure for {} is {}, the reported pid={}, serverName={}, code={}, seqId={}, proc={}, should be a retry, ignore", new Object[]{regionNode, this.remoteProc.getProcId(), procId, serverName, code, seqId, this});
            return;
        }
        this.remoteProc.reportTransition(env, regionNode, serverName, code, seqId);
    }

    public void serverCrashed(MasterProcedureEnv env, RegionStateNode regionNode, ServerName serverName, boolean forceNewPlan) throws IOException {
        this.forceNewPlan = forceNewPlan;
        if (this.remoteProc != null) {
            this.remoteProc.serverCrashed(env, regionNode, serverName);
        } else {
            env.getAssignmentManager().regionClosedAbnormally(regionNode);
        }
    }

    void attachRemoteProc(RegionRemoteProcedureBase proc) {
        this.remoteProc = proc;
    }

    void unattachRemoteProc(RegionRemoteProcedureBase proc) {
        assert (this.remoteProc == proc);
        this.remoteProc = null;
    }

    void stateLoaded(AssignmentManager am, RegionStateNode regionNode) {
        if (this.remoteProc != null) {
            this.remoteProc.stateLoaded(am, regionNode);
        }
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.RegionStateTransitionState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.RegionStateTransitionState getState(int stateId) {
        return MasterProcedureProtos.RegionStateTransitionState.forNumber(stateId);
    }

    protected int getStateId(MasterProcedureProtos.RegionStateTransitionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.RegionStateTransitionState getInitialState() {
        return this.initialState;
    }

    private static TransitionType convert(MasterProcedureProtos.RegionTransitionType type2) {
        switch (type2) {
            case ASSIGN: {
                return TransitionType.ASSIGN;
            }
            case UNASSIGN: {
                return TransitionType.UNASSIGN;
            }
            case MOVE: {
                return TransitionType.MOVE;
            }
            case REOPEN: {
                return TransitionType.REOPEN;
            }
        }
        throw new IllegalArgumentException("Unknown RegionTransitionType: " + type2);
    }

    private static MasterProcedureProtos.RegionTransitionType convert(TransitionType type2) {
        switch (type2) {
            case ASSIGN: {
                return MasterProcedureProtos.RegionTransitionType.ASSIGN;
            }
            case UNASSIGN: {
                return MasterProcedureProtos.RegionTransitionType.UNASSIGN;
            }
            case MOVE: {
                return MasterProcedureProtos.RegionTransitionType.MOVE;
            }
            case REOPEN: {
                return MasterProcedureProtos.RegionTransitionType.REOPEN;
            }
        }
        throw new IllegalArgumentException("Unknown TransitionType: " + (Object)((Object)type2));
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.RegionStateTransitionStateData.Builder builder = MasterProcedureProtos.RegionStateTransitionStateData.newBuilder().setType(TransitRegionStateProcedure.convert(this.type)).setForceNewPlan(this.forceNewPlan);
        if (this.assignCandidate != null) {
            builder.setAssignCandidate(ProtobufUtil.toServerName(this.assignCandidate));
        }
        serializer.serialize((Message)builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RegionStateTransitionStateData data2 = (MasterProcedureProtos.RegionStateTransitionStateData)serializer.deserialize(MasterProcedureProtos.RegionStateTransitionStateData.class);
        this.type = TransitRegionStateProcedure.convert(data2.getType());
        this.setInitialAndLastState();
        this.forceNewPlan = data2.getForceNewPlan();
        if (data2.hasAssignCandidate()) {
            this.assignCandidate = ProtobufUtil.toServerName(data2.getAssignCandidate());
        }
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        MetricsAssignmentManager metrics = env.getAssignmentManager().getAssignmentManagerMetrics();
        switch (this.type) {
            case ASSIGN: {
                return metrics.getAssignProcMetrics();
            }
            case UNASSIGN: {
                return metrics.getUnassignProcMetrics();
            }
            case MOVE: {
                return metrics.getMoveProcMetrics();
            }
            case REOPEN: {
                return metrics.getReopenProcMetrics();
            }
        }
        throw new IllegalArgumentException("Unknown transition type: " + (Object)((Object)this.type));
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        super.toStringClassDetails(sb);
        if (this.initialState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE) {
            sb.append(", ASSIGN");
        } else if (this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED) {
            sb.append(", UNASSIGN");
        } else {
            sb.append(", REOPEN/MOVE");
        }
    }

    private static TransitRegionStateProcedure setOwner(MasterProcedureEnv env, TransitRegionStateProcedure proc) {
        proc.setOwner(env.getRequestUser().getShortName());
        return proc;
    }

    public static TransitRegionStateProcedure assign(MasterProcedureEnv env, RegionInfo region, @Nullable ServerName targetServer) {
        return TransitRegionStateProcedure.assign(env, region, false, targetServer);
    }

    public static TransitRegionStateProcedure assign(MasterProcedureEnv env, RegionInfo region, boolean forceNewPlan, @Nullable ServerName targetServer) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, targetServer, forceNewPlan, TransitionType.ASSIGN));
    }

    public static TransitRegionStateProcedure unassign(MasterProcedureEnv env, RegionInfo region) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, null, false, TransitionType.UNASSIGN));
    }

    public static TransitRegionStateProcedure reopen(MasterProcedureEnv env, RegionInfo region) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, null, false, TransitionType.REOPEN));
    }

    public static TransitRegionStateProcedure move(MasterProcedureEnv env, RegionInfo region, @Nullable ServerName targetServer) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, targetServer, targetServer == null, TransitionType.MOVE));
    }

    public static enum TransitionType {
        ASSIGN,
        UNASSIGN,
        MOVE,
        REOPEN;

    }
}

