/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.RateLimiter;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationTarget;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorkQueue;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionNormalizerWorker
implements PropagatingConfigurationObserver,
Runnable {
    public static final String HBASE_TABLE_NORMALIZATION_ENABLED = "hbase.table.normalization.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(RegionNormalizerWorker.class);
    static final String RATE_LIMIT_BYTES_PER_SEC_KEY = "hbase.normalizer.throughput.max_bytes_per_sec";
    private static final long RATE_UNLIMITED_BYTES = 1000000000000L;
    private final MasterServices masterServices;
    private final RegionNormalizer regionNormalizer;
    private final RegionNormalizerWorkQueue<TableName> workQueue;
    private final RateLimiter rateLimiter;
    private final long[] skippedCount;
    private final boolean defaultNormalizerTableLevel;
    private long splitPlanCount;
    private long mergePlanCount;

    RegionNormalizerWorker(Configuration configuration, MasterServices masterServices, RegionNormalizer regionNormalizer, RegionNormalizerWorkQueue<TableName> workQueue) {
        this.masterServices = masterServices;
        this.regionNormalizer = regionNormalizer;
        this.workQueue = workQueue;
        this.skippedCount = new long[NormalizationPlan.PlanType.values().length];
        this.splitPlanCount = 0L;
        this.mergePlanCount = 0L;
        this.rateLimiter = RegionNormalizerWorker.loadRateLimiter(configuration);
        this.defaultNormalizerTableLevel = this.extractDefaultNormalizerValue(configuration);
    }

    private boolean extractDefaultNormalizerValue(Configuration configuration) {
        String s = configuration.get(HBASE_TABLE_NORMALIZATION_ENABLED);
        return Boolean.parseBoolean(s);
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
        if (this.regionNormalizer instanceof ConfigurationObserver) {
            ConfigurationObserver observer = (ConfigurationObserver)((Object)this.regionNormalizer);
            manager.registerObserver(observer);
        }
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
        if (this.regionNormalizer instanceof ConfigurationObserver) {
            ConfigurationObserver observer = (ConfigurationObserver)((Object)this.regionNormalizer);
            manager.deregisterObserver(observer);
        }
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.rateLimiter.setRate(RegionNormalizerWorker.loadRateLimit(conf));
    }

    private static RateLimiter loadRateLimiter(Configuration configuration) {
        return RateLimiter.create(RegionNormalizerWorker.loadRateLimit(configuration));
    }

    private static long loadRateLimit(Configuration configuration) {
        long rateLimitBytes = configuration.getLongBytes(RATE_LIMIT_BYTES_PER_SEC_KEY, 1000000000000L);
        long rateLimitMbs = rateLimitBytes / 1000000L;
        if (rateLimitMbs <= 0L) {
            LOG.warn("Configured value {}={} is <= 1MB. Falling back to default.", (Object)RATE_LIMIT_BYTES_PER_SEC_KEY, (Object)rateLimitBytes);
            rateLimitBytes = 1000000000000L;
            rateLimitMbs = 1000000L;
        }
        LOG.info("Normalizer rate limit set to {}", (Object)(rateLimitBytes == 1000000000000L ? "unlimited" : rateLimitMbs + " MB/sec"));
        return rateLimitMbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void planSkipped(NormalizationPlan.PlanType type2) {
        long[] lArray = this.skippedCount;
        synchronized (this.skippedCount) {
            int n = type2.ordinal();
            this.skippedCount[n] = this.skippedCount[n] + 1L;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long getSkippedCount(NormalizationPlan.PlanType type2) {
        return this.skippedCount[type2.ordinal()];
    }

    long getSplitPlanCount() {
        return this.splitPlanCount;
    }

    long getMergePlanCount() {
        return this.mergePlanCount;
    }

    RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    @Override
    public void run() {
        while (true) {
            TableName tableName;
            if (Thread.interrupted()) {
                LOG.debug("interrupt detected. terminating.");
                break;
            }
            try {
                tableName = this.workQueue.take();
            }
            catch (InterruptedException e) {
                LOG.debug("interrupt detected. terminating.");
                break;
            }
            List<NormalizationPlan> plans = this.calculatePlans(tableName);
            this.submitPlans(plans);
        }
    }

    private List<NormalizationPlan> calculatePlans(TableName tableName) {
        TableDescriptor tblDesc;
        if (this.masterServices.skipRegionManagementAction("region normalizer")) {
            return Collections.emptyList();
        }
        try {
            String defined;
            boolean normalizationEnabled;
            tblDesc = this.masterServices.getTableDescriptors().get(tableName);
            if (tblDesc != null && !(normalizationEnabled = (defined = tblDesc.getValue("NORMALIZATION_ENABLED")) != null ? tblDesc.isNormalizationEnabled() : this.defaultNormalizerTableLevel)) {
                LOG.debug("Skipping table {} because normalization is disabled in its table properties and normalization is also disabled at table level by default", (Object)tableName);
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            LOG.debug("Skipping table {} because unable to access its table descriptor.", (Object)tableName, (Object)e);
            return Collections.emptyList();
        }
        List<NormalizationPlan> plans = this.regionNormalizer.computePlansForTable(tblDesc);
        if (CollectionUtils.isEmpty(plans)) {
            LOG.debug("No normalization required for table {}.", (Object)tableName);
            return Collections.emptyList();
        }
        return plans;
    }

    private void submitPlans(List<NormalizationPlan> plans) {
        block5: for (NormalizationPlan plan : plans) {
            switch (plan.getType()) {
                case MERGE: {
                    this.submitMergePlan((MergeNormalizationPlan)plan);
                    continue block5;
                }
                case SPLIT: {
                    this.submitSplitPlan((SplitNormalizationPlan)plan);
                    continue block5;
                }
                case NONE: {
                    LOG.debug("Nothing to do for {} with PlanType=NONE. Ignoring.", (Object)plan);
                    this.planSkipped(plan.getType());
                    continue block5;
                }
            }
            LOG.warn("Plan {} is of an unrecognized PlanType. Ignoring.", (Object)plan);
            this.planSkipped(plan.getType());
        }
    }

    private void submitMergePlan(MergeNormalizationPlan plan) {
        long pid;
        int totalSizeMb;
        try {
            long totalSizeMbLong = plan.getNormalizationTargets().stream().mapToLong(NormalizationTarget::getRegionSizeMb).reduce(0L, Math::addExact);
            totalSizeMb = Math.toIntExact(totalSizeMbLong);
        }
        catch (ArithmeticException e) {
            LOG.debug("Sum of merge request size overflows rate limiter data type. {}", (Object)plan);
            this.planSkipped(plan.getType());
            return;
        }
        RegionInfo[] infos = (RegionInfo[])plan.getNormalizationTargets().stream().map(NormalizationTarget::getRegionInfo).toArray(RegionInfo[]::new);
        try {
            pid = this.masterServices.mergeRegions(infos, false, 0L, 0L);
        }
        catch (IOException e) {
            LOG.info("failed to submit plan {}.", (Object)plan, (Object)e);
            this.planSkipped(plan.getType());
            return;
        }
        ++this.mergePlanCount;
        LOG.info("Submitted {} resulting in pid {}", (Object)plan, (Object)pid);
        long rateLimitedSecs = Math.round(this.rateLimiter.acquire(Math.max(1, totalSizeMb)));
        LOG.debug("Rate limiting delayed the worker by {}", (Object)Duration.ofSeconds(rateLimitedSecs));
    }

    private void submitSplitPlan(SplitNormalizationPlan plan) {
        long pid;
        int totalSizeMb;
        try {
            totalSizeMb = Math.toIntExact(plan.getSplitTarget().getRegionSizeMb());
        }
        catch (ArithmeticException e) {
            LOG.debug("Split request size overflows rate limiter data type. {}", (Object)plan);
            this.planSkipped(plan.getType());
            return;
        }
        RegionInfo info = plan.getSplitTarget().getRegionInfo();
        long rateLimitedSecs = Math.round(this.rateLimiter.acquire(Math.max(1, totalSizeMb)));
        LOG.debug("Rate limiting delayed this operation by {}", (Object)Duration.ofSeconds(rateLimitedSecs));
        try {
            pid = this.masterServices.splitRegion(info, null, 0L, 0L);
        }
        catch (IOException e) {
            LOG.info("failed to submit plan {}.", (Object)plan, (Object)e);
            this.planSkipped(plan.getType());
            return;
        }
        ++this.splitPlanCount;
        LOG.info("Submitted {} resulting in pid {}", (Object)plan, (Object)pid);
    }
}

