/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.procedure2.LockAndQueue;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.LockedResourceType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class SchemaLocking {
    private final Function<Long, Procedure<?>> procedureRetriever;
    private final Map<ServerName, LockAndQueue> serverLocks = new HashMap<ServerName, LockAndQueue>();
    private final Map<String, LockAndQueue> namespaceLocks = new HashMap<String, LockAndQueue>();
    private final Map<TableName, LockAndQueue> tableLocks = new HashMap<TableName, LockAndQueue>();
    private final Map<String, LockAndQueue> regionLocks = new HashMap<String, LockAndQueue>();
    private final Map<String, LockAndQueue> peerLocks = new HashMap<String, LockAndQueue>();
    private final LockAndQueue metaLock;

    public SchemaLocking(Function<Long, Procedure<?>> procedureRetriever) {
        this.procedureRetriever = procedureRetriever;
        this.metaLock = new LockAndQueue(procedureRetriever);
    }

    private <T> LockAndQueue getLock(Map<T, LockAndQueue> map2, T key) {
        LockAndQueue lock = map2.get(key);
        if (lock == null) {
            lock = new LockAndQueue(this.procedureRetriever);
            map2.put(key, lock);
        }
        return lock;
    }

    LockAndQueue getTableLock(TableName tableName) {
        return this.getLock(this.tableLocks, tableName);
    }

    LockAndQueue removeTableLock(TableName tableName) {
        return this.tableLocks.remove(tableName);
    }

    LockAndQueue getNamespaceLock(String namespace) {
        return this.getLock(this.namespaceLocks, namespace);
    }

    LockAndQueue getRegionLock(String encodedRegionName) {
        return this.getLock(this.regionLocks, encodedRegionName);
    }

    @Deprecated
    LockAndQueue getMetaLock() {
        return this.metaLock;
    }

    LockAndQueue removeRegionLock(String encodedRegionName) {
        return this.regionLocks.remove(encodedRegionName);
    }

    LockAndQueue getServerLock(ServerName serverName) {
        return this.getLock(this.serverLocks, serverName);
    }

    LockAndQueue removeServerLock(ServerName serverName) {
        return this.serverLocks.remove(serverName);
    }

    LockAndQueue getPeerLock(String peerId) {
        return this.getLock(this.peerLocks, peerId);
    }

    LockAndQueue removePeerLock(String peerId) {
        return this.peerLocks.remove(peerId);
    }

    private LockedResource createLockedResource(LockedResourceType resourceType, String resourceName, LockAndQueue queue) {
        int sharedLockCount;
        Procedure exclusiveLockOwnerProcedure;
        LockType lockType;
        if (queue.hasExclusiveLock()) {
            lockType = LockType.EXCLUSIVE;
            exclusiveLockOwnerProcedure = queue.getExclusiveLockOwnerProcedure();
            sharedLockCount = 0;
        } else {
            lockType = LockType.SHARED;
            exclusiveLockOwnerProcedure = null;
            sharedLockCount = queue.getSharedLockCount();
        }
        ArrayList waitingProcedures = new ArrayList();
        queue.filterWaitingQueue(p -> p instanceof LockProcedure).forEachOrdered(waitingProcedures::add);
        return new LockedResource(resourceType, resourceName, lockType, exclusiveLockOwnerProcedure, sharedLockCount, waitingProcedures);
    }

    private <T> void addToLockedResources(List<LockedResource> lockedResources, Map<T, LockAndQueue> locks, Function<T, String> keyTransformer, LockedResourceType resourcesType) {
        locks.entrySet().stream().filter(e -> ((LockAndQueue)e.getValue()).isLocked()).map(e -> this.createLockedResource(resourcesType, (String)keyTransformer.apply(e.getKey()), (LockAndQueue)e.getValue())).forEachOrdered(lockedResources::add);
    }

    List<LockedResource> getLocks() {
        ArrayList<LockedResource> lockedResources = new ArrayList<LockedResource>();
        this.addToLockedResources(lockedResources, this.serverLocks, sn -> sn.getServerName(), LockedResourceType.SERVER);
        this.addToLockedResources(lockedResources, this.namespaceLocks, Function.identity(), LockedResourceType.NAMESPACE);
        this.addToLockedResources(lockedResources, this.tableLocks, tn -> tn.getNameAsString(), LockedResourceType.TABLE);
        this.addToLockedResources(lockedResources, this.regionLocks, Function.identity(), LockedResourceType.REGION);
        this.addToLockedResources(lockedResources, this.peerLocks, Function.identity(), LockedResourceType.PEER);
        this.addToLockedResources(lockedResources, ImmutableMap.of(TableName.META_TABLE_NAME, this.metaLock), tn -> tn.getNameAsString(), LockedResourceType.META);
        return lockedResources;
    }

    LockedResource getLockResource(LockedResourceType resourceType, String resourceName) {
        LockAndQueue queue;
        switch (resourceType) {
            case SERVER: {
                queue = this.serverLocks.get(ServerName.valueOf(resourceName));
                break;
            }
            case NAMESPACE: {
                queue = this.namespaceLocks.get(resourceName);
                break;
            }
            case TABLE: {
                queue = this.tableLocks.get(TableName.valueOf(resourceName));
                break;
            }
            case REGION: {
                queue = this.regionLocks.get(resourceName);
                break;
            }
            case PEER: {
                queue = this.peerLocks.get(resourceName);
                break;
            }
            case META: {
                queue = this.metaLock;
            }
            default: {
                queue = null;
            }
        }
        return queue != null ? this.createLockedResource(resourceType, resourceName, queue) : null;
    }

    void clear() {
        this.serverLocks.clear();
        this.namespaceLocks.clear();
        this.tableLocks.clear();
        this.regionLocks.clear();
        this.peerLocks.clear();
    }

    public String toString() {
        return "serverLocks=" + this.filterUnlocked(this.serverLocks) + ", namespaceLocks=" + this.filterUnlocked(this.namespaceLocks) + ", tableLocks=" + this.filterUnlocked(this.tableLocks) + ", regionLocks=" + this.filterUnlocked(this.regionLocks) + ", peerLocks=" + this.filterUnlocked(this.peerLocks) + ", metaLocks=" + this.filterUnlocked(ImmutableMap.of(TableName.META_TABLE_NAME, this.metaLock));
    }

    private String filterUnlocked(Map<?, LockAndQueue> locks) {
        StringBuilder sb = new StringBuilder("{");
        int initialLength = sb.length();
        for (Map.Entry<?, LockAndQueue> entry : locks.entrySet()) {
            if (!entry.getValue().isLocked()) continue;
            if (sb.length() > initialLength) {
                sb.append(", ");
            }
            sb.append("{").append(entry.getKey()).append("=").append(entry.getValue()).append("}");
        }
        sb.append("}");
        return sb.toString();
    }
}

