/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.metrics.MetricsInfoImpl;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class Interns {
    private static LoadingCache<String, ConcurrentHashMap<String, MetricsInfo>> infoCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build(new CacheLoader<String, ConcurrentHashMap<String, MetricsInfo>>(){

        @Override
        public ConcurrentHashMap<String, MetricsInfo> load(String key) {
            return new ConcurrentHashMap<String, MetricsInfo>();
        }
    });
    private static LoadingCache<MetricsInfo, ConcurrentHashMap<String, MetricsTag>> tagCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build(new CacheLoader<MetricsInfo, ConcurrentHashMap<String, MetricsTag>>(){

        @Override
        public ConcurrentHashMap<String, MetricsTag> load(MetricsInfo key) {
            return new ConcurrentHashMap<String, MetricsTag>();
        }
    });

    private Interns() {
    }

    public static MetricsInfo info(String name2, String description2) {
        Map map2 = infoCache.getUnchecked(name2);
        MetricsInfo info = (MetricsInfo)map2.get(description2);
        if (info == null) {
            info = new MetricsInfoImpl(name2, description2);
            map2.put(description2, info);
        }
        return info;
    }

    public static MetricsTag tag(MetricsInfo info, String value) {
        Map map2 = tagCache.getUnchecked(info);
        MetricsTag tag = (MetricsTag)map2.get(value);
        if (tag == null) {
            tag = new MetricsTag(info, value);
            map2.put(value, tag);
        }
        return tag;
    }

    public static MetricsTag tag(String name2, String description2, String value) {
        return Interns.tag(Interns.info(name2, description2), value);
    }
}

