/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseMetrics2HadoopMetricsAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMetrics2HadoopMetricsAdapter.class);
    private static final String EMPTY_STRING = "";

    public void snapshotAllMetrics(MetricRegistry metricRegistry, MetricsCollector collector) {
        MetricRegistryInfo info = metricRegistry.getMetricRegistryInfo();
        MetricsRecordBuilder builder = collector.addRecord(Interns.info((String)info.getMetricsName(), (String)info.getMetricsDescription()));
        builder.setContext(info.getMetricsContext());
        this.snapshotAllMetrics(metricRegistry, builder);
    }

    public void snapshotAllMetrics(MetricRegistry metricRegistry, MetricsRecordBuilder builder) {
        Map<String, Metric> metrics = metricRegistry.getMetrics();
        for (Map.Entry<String, Metric> e : metrics.entrySet()) {
            String name2 = StringUtils.capitalize((String)e.getKey());
            Metric metric = e.getValue();
            if (metric instanceof Gauge) {
                this.addGauge(name2, (Gauge)metric, builder);
                continue;
            }
            if (metric instanceof Counter) {
                this.addCounter(name2, (Counter)metric, builder);
                continue;
            }
            if (metric instanceof Histogram) {
                this.addHistogram(name2, (Histogram)metric, builder);
                continue;
            }
            if (metric instanceof Meter) {
                this.addMeter(name2, (Meter)metric, builder);
                continue;
            }
            if (metric instanceof Timer) {
                this.addTimer(name2, (Timer)metric, builder);
                continue;
            }
            LOG.info("Ignoring unknown Metric class " + metric.getClass().getName());
        }
    }

    private void addGauge(String name2, Gauge<?> gauge, MetricsRecordBuilder builder) {
        MetricsInfo info = Interns.info((String)name2, (String)EMPTY_STRING);
        Object o = gauge.getValue();
        if (o instanceof Integer) {
            builder.addGauge(info, ((Integer)o).intValue());
        } else if (o instanceof Long) {
            builder.addGauge(info, ((Long)o).longValue());
        } else if (o instanceof Float) {
            builder.addGauge(info, ((Float)o).floatValue());
        } else if (o instanceof Double) {
            builder.addGauge(info, ((Double)o).doubleValue());
        } else {
            LOG.warn("Ignoring Gauge (" + name2 + ") with unhandled type: " + o.getClass());
        }
    }

    private void addCounter(String name2, Counter counter2, MetricsRecordBuilder builder) {
        MetricsInfo info = Interns.info((String)name2, (String)EMPTY_STRING);
        builder.addCounter(info, counter2.getCount());
    }

    private void addHistogram(String name2, Histogram histogram, MetricsRecordBuilder builder) {
        MutableHistogram.snapshot(name2, EMPTY_STRING, histogram, builder, true);
    }

    private void addMeter(String name2, Meter meter, MetricsRecordBuilder builder) {
        builder.addGauge(Interns.info((String)(name2 + "_count"), (String)EMPTY_STRING), meter.getCount());
        builder.addGauge(Interns.info((String)(name2 + "_mean_rate"), (String)EMPTY_STRING), meter.getMeanRate());
        builder.addGauge(Interns.info((String)(name2 + "_1min_rate"), (String)EMPTY_STRING), meter.getOneMinuteRate());
        builder.addGauge(Interns.info((String)(name2 + "_5min_rate"), (String)EMPTY_STRING), meter.getFiveMinuteRate());
        builder.addGauge(Interns.info((String)(name2 + "_15min_rate"), (String)EMPTY_STRING), meter.getFifteenMinuteRate());
    }

    private void addTimer(String name2, Timer timer, MetricsRecordBuilder builder) {
        this.addMeter(name2, timer.getMeter(), builder);
        this.addHistogram(name2, timer.getHistogram(), builder);
    }
}

