/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ThreadMonitoring {
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static final int STACK_DEPTH = 20;

    public static ThreadInfo getThreadInfo(Thread t) {
        long tid = t.getId();
        return threadBean.getThreadInfo(tid, 20);
    }

    public static String formatThreadInfo(ThreadInfo threadInfo, String indent) {
        StringBuilder sb = new StringBuilder();
        ThreadMonitoring.appendThreadInfo(sb, threadInfo, indent);
        return sb.toString();
    }

    public static void appendThreadInfo(StringBuilder sb, ThreadInfo info, String indent) {
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        if (info == null) {
            sb.append(indent).append("Inactive (perhaps exited while monitoring was done)\n");
            return;
        }
        String taskName = ThreadMonitoring.getTaskName(info.getThreadId(), info.getThreadName());
        sb.append(indent).append("Thread ").append(taskName).append(":\n");
        Thread.State state = info.getThreadState();
        sb.append(indent).append("  State: ").append((Object)state).append("\n");
        sb.append(indent).append("  Blocked count: ").append(info.getBlockedCount()).append("\n");
        sb.append(indent).append("  Waited count: ").append(info.getWaitedCount()).append("\n");
        if (contention) {
            sb.append(indent).append("  Blocked time: " + info.getBlockedTime()).append("\n");
            sb.append(indent).append("  Waited time: " + info.getWaitedTime()).append("\n");
        }
        if (state == Thread.State.WAITING) {
            sb.append(indent).append("  Waiting on ").append(info.getLockName()).append("\n");
        } else if (state == Thread.State.BLOCKED) {
            sb.append(indent).append("  Blocked on ").append(info.getLockName()).append("\n");
            sb.append(indent).append("  Blocked by ").append(ThreadMonitoring.getTaskName(info.getLockOwnerId(), info.getLockOwnerName())).append("\n");
        }
        sb.append(indent).append("  Stack:").append("\n");
        for (StackTraceElement frame : info.getStackTrace()) {
            sb.append(indent).append("    ").append(frame.toString()).append("\n");
        }
    }

    private static String getTaskName(long id, String name2) {
        if (name2 == null) {
            return Long.toString(id);
        }
        return id + " (" + name2 + ")";
    }
}

