/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.RefCnt;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MultiByteBuff
extends ByteBuff {
    private final ByteBuffer[] items;
    private ByteBuffer curItem = null;
    private int curItemIndex = 0;
    private int limit = 0;
    private int limitedItemIndex;
    private int markedItemIndex = -1;
    private final int[] itemBeginPos;
    private Iterator<ByteBuffer> buffsIterator = new Iterator<ByteBuffer>(){

        @Override
        public boolean hasNext() {
            return MultiByteBuff.this.curItemIndex < MultiByteBuff.this.limitedItemIndex || MultiByteBuff.this.curItemIndex == MultiByteBuff.this.limitedItemIndex && MultiByteBuff.this.items[MultiByteBuff.this.curItemIndex].hasRemaining();
        }

        @Override
        public ByteBuffer next() {
            if (MultiByteBuff.this.curItemIndex >= MultiByteBuff.this.items.length) {
                throw new NoSuchElementException("items overflow");
            }
            MultiByteBuff.this.curItem = MultiByteBuff.this.items[MultiByteBuff.this.curItemIndex++];
            return MultiByteBuff.this.curItem;
        }
    };

    public MultiByteBuff(ByteBuffer ... items) {
        this(ByteBuffAllocator.NONE, items);
    }

    public MultiByteBuff(ByteBuffAllocator.Recycler recycler, ByteBuffer ... items) {
        this(new RefCnt(recycler), items);
    }

    MultiByteBuff(RefCnt refCnt, ByteBuffer ... items) {
        this.refCnt = refCnt;
        assert (items != null);
        assert (items.length > 0);
        this.items = items;
        this.curItem = this.items[this.curItemIndex];
        this.itemBeginPos = new int[items.length + 1];
        int offset = 0;
        for (int i = 0; i < items.length; ++i) {
            ByteBuffer item = items[i];
            item.rewind();
            this.itemBeginPos[i] = offset;
            int l = item.limit() - item.position();
            offset += l;
        }
        this.limit = offset;
        this.itemBeginPos[items.length] = offset + 1;
        this.limitedItemIndex = this.items.length - 1;
    }

    private MultiByteBuff(RefCnt refCnt, ByteBuffer[] items, int[] itemBeginPos, int limit, int limitedIndex, int curItemIndex, int markedIndex) {
        this.refCnt = refCnt;
        this.items = items;
        this.curItemIndex = curItemIndex;
        this.curItem = this.items[this.curItemIndex];
        this.itemBeginPos = itemBeginPos;
        this.limit = limit;
        this.limitedItemIndex = limitedIndex;
        this.markedItemIndex = markedIndex;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public int capacity() {
        this.checkRefCount();
        int c = 0;
        for (ByteBuffer item : this.items) {
            c += item.capacity();
        }
        return c;
    }

    @Override
    public byte get(int index) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(index);
        return ByteBufferUtils.toByte(this.items[itemIndex], index - this.itemBeginPos[itemIndex]);
    }

    @Override
    public byte getByteAfterPosition(int offset) {
        this.checkRefCount();
        int index = offset + this.position();
        int itemIndex = this.getItemIndexFromCurItemIndex(index);
        return ByteBufferUtils.toByte(this.items[itemIndex], index - this.itemBeginPos[itemIndex]);
    }

    private int getItemIndex(int elemIndex) {
        if (elemIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int index = 1;
        while (elemIndex >= this.itemBeginPos[index]) {
            if (++index != this.itemBeginPos.length) continue;
            throw new IndexOutOfBoundsException();
        }
        return index - 1;
    }

    private int getItemIndexFromCurItemIndex(int elemIndex) {
        int index = this.curItemIndex;
        while (elemIndex >= this.itemBeginPos[index]) {
            if (++index != this.itemBeginPos.length) continue;
            throw new IndexOutOfBoundsException();
        }
        return index - 1;
    }

    @Override
    public int getInt(int index) {
        this.checkRefCount();
        int itemIndex = this.itemBeginPos[this.curItemIndex] <= index && this.itemBeginPos[this.curItemIndex + 1] > index ? this.curItemIndex : this.getItemIndex(index);
        return this.getInt(index, itemIndex);
    }

    @Override
    public int getIntAfterPosition(int offset) {
        this.checkRefCount();
        int index = offset + this.position();
        int itemIndex = this.itemBeginPos[this.curItemIndex + 1] > index ? this.curItemIndex : this.getItemIndexFromCurItemIndex(index);
        return this.getInt(index, itemIndex);
    }

    @Override
    public short getShort(int index) {
        this.checkRefCount();
        int itemIndex = this.itemBeginPos[this.curItemIndex] <= index && this.itemBeginPos[this.curItemIndex + 1] > index ? this.curItemIndex : this.getItemIndex(index);
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index - this.itemBeginPos[itemIndex];
        if (item.limit() - offsetInItem >= 2) {
            return ByteBufferUtils.toShort(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        ByteBuffer nextItem = this.items[itemIndex + 1];
        short n = 0;
        n = (short)(n ^ ByteBufferUtils.toByte(item, offsetInItem) & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ ByteBufferUtils.toByte(nextItem, 0) & 0xFF);
        return n;
    }

    @Override
    public short getShortAfterPosition(int offset) {
        this.checkRefCount();
        int index = offset + this.position();
        int itemIndex = this.itemBeginPos[this.curItemIndex + 1] > index ? this.curItemIndex : this.getItemIndexFromCurItemIndex(index);
        return this.getShort(index, itemIndex);
    }

    private int getInt(int index, int itemIndex) {
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index - this.itemBeginPos[itemIndex];
        int remainingLen = item.limit() - offsetInItem;
        if (remainingLen >= 4) {
            return ByteBufferUtils.toInt(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        int l = 0;
        for (int i = 0; i < 4; ++i) {
            l <<= 8;
            l ^= this.get(index + i) & 0xFF;
        }
        return l;
    }

    private short getShort(int index, int itemIndex) {
        int i;
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index - this.itemBeginPos[itemIndex];
        int remainingLen = item.limit() - offsetInItem;
        if (remainingLen >= 2) {
            return ByteBufferUtils.toShort(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        ByteBuffer nextItem = this.items[itemIndex + 1];
        short l = 0;
        for (i = offsetInItem; i < item.capacity(); ++i) {
            l = (short)(l << 8);
            l = (short)(l ^ ByteBufferUtils.toByte(item, i) & 0xFF);
        }
        for (i = 0; i < 2 - remainingLen; ++i) {
            l = (short)(l << 8);
            l = (short)(l ^ ByteBufferUtils.toByte(nextItem, i) & 0xFF);
        }
        return l;
    }

    private long getLong(int index, int itemIndex) {
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index - this.itemBeginPos[itemIndex];
        int remainingLen = item.limit() - offsetInItem;
        if (remainingLen >= 8) {
            return ByteBufferUtils.toLong(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l ^= (long)(this.get(index + i) & 0xFF);
        }
        return l;
    }

    @Override
    public long getLong(int index) {
        this.checkRefCount();
        int itemIndex = this.itemBeginPos[this.curItemIndex] <= index && this.itemBeginPos[this.curItemIndex + 1] > index ? this.curItemIndex : this.getItemIndex(index);
        return this.getLong(index, itemIndex);
    }

    @Override
    public long getLongAfterPosition(int offset) {
        this.checkRefCount();
        int index = offset + this.position();
        int itemIndex = this.itemBeginPos[this.curItemIndex + 1] > index ? this.curItemIndex : this.getItemIndexFromCurItemIndex(index);
        return this.getLong(index, itemIndex);
    }

    @Override
    public int position() {
        this.checkRefCount();
        return this.itemBeginPos[this.curItemIndex] + this.curItem.position();
    }

    @Override
    public MultiByteBuff position(int position) {
        int i;
        this.checkRefCount();
        if (this.itemBeginPos[this.curItemIndex] <= position && this.itemBeginPos[this.curItemIndex + 1] > position) {
            this.curItem.position(position - this.itemBeginPos[this.curItemIndex]);
            return this;
        }
        int itemIndex = this.getItemIndex(position);
        for (i = 0; i < itemIndex; ++i) {
            this.items[i].position(this.items[i].limit());
        }
        for (i = itemIndex + 1; i < this.items.length; ++i) {
            this.items[i].position(0);
        }
        this.curItem = this.items[itemIndex];
        this.curItem.position(position - this.itemBeginPos[itemIndex]);
        this.curItemIndex = itemIndex;
        return this;
    }

    @Override
    public MultiByteBuff rewind() {
        this.checkRefCount();
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].rewind();
        }
        this.curItemIndex = 0;
        this.curItem = this.items[this.curItemIndex];
        this.markedItemIndex = -1;
        return this;
    }

    @Override
    public MultiByteBuff mark() {
        this.checkRefCount();
        this.markedItemIndex = this.curItemIndex;
        this.curItem.mark();
        return this;
    }

    @Override
    public MultiByteBuff reset() {
        this.checkRefCount();
        if (this.markedItemIndex < 0) {
            throw new InvalidMarkException();
        }
        ByteBuffer markedItem = this.items[this.markedItemIndex];
        markedItem.reset();
        this.curItem = markedItem;
        for (int i = this.curItemIndex; i > this.markedItemIndex; --i) {
            this.items[i].position(0);
        }
        this.curItemIndex = this.markedItemIndex;
        return this;
    }

    @Override
    public int remaining() {
        this.checkRefCount();
        int remain = 0;
        for (int i = this.curItemIndex; i < this.items.length; ++i) {
            remain += this.items[i].remaining();
        }
        return remain;
    }

    @Override
    public final boolean hasRemaining() {
        this.checkRefCount();
        return this.curItem.hasRemaining() || this.curItemIndex < this.limitedItemIndex && this.items[this.curItemIndex + 1].hasRemaining();
    }

    @Override
    public byte get() {
        this.checkRefCount();
        if (this.curItem.remaining() == 0) {
            if (this.items.length - 1 == this.curItemIndex) {
                throw new BufferUnderflowException();
            }
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
        }
        return this.curItem.get();
    }

    @Override
    public short getShort() {
        this.checkRefCount();
        int remaining = this.curItem.remaining();
        if (remaining >= 2) {
            return this.curItem.getShort();
        }
        short n = 0;
        n = (short)(n ^ this.get() & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ this.get() & 0xFF);
        return n;
    }

    @Override
    public int getInt() {
        this.checkRefCount();
        int remaining = this.curItem.remaining();
        if (remaining >= 4) {
            return this.curItem.getInt();
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            n ^= this.get() & 0xFF;
        }
        return n;
    }

    @Override
    public long getLong() {
        this.checkRefCount();
        int remaining = this.curItem.remaining();
        if (remaining >= 8) {
            return this.curItem.getLong();
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l ^= (long)(this.get() & 0xFF);
        }
        return l;
    }

    @Override
    public void get(byte[] dst) {
        this.get(dst, 0, dst.length);
    }

    @Override
    public void get(byte[] dst, int offset, int length) {
        this.checkRefCount();
        while (length > 0) {
            int toRead = Math.min(length, this.curItem.remaining());
            ByteBufferUtils.copyFromBufferToArray(dst, this.curItem, this.curItem.position(), offset, toRead);
            this.curItem.position(this.curItem.position() + toRead);
            if ((length -= toRead) == 0) break;
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
            offset += toRead;
        }
    }

    @Override
    public void get(int sourceOffset, byte[] dst, int offset, int length) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(sourceOffset);
        ByteBuffer item = this.items[itemIndex];
        sourceOffset -= this.itemBeginPos[itemIndex];
        while (length > 0) {
            int toRead = Math.min(item.limit() - sourceOffset, length);
            ByteBufferUtils.copyFromBufferToArray(dst, item, sourceOffset, offset, toRead);
            if ((length -= toRead) == 0) break;
            item = this.items[++itemIndex];
            offset += toRead;
            sourceOffset = 0;
        }
    }

    @Override
    public MultiByteBuff limit(int limit) {
        int i;
        this.checkRefCount();
        this.limit = limit;
        int limitedIndexBegin = this.itemBeginPos[this.limitedItemIndex];
        if (limit >= limitedIndexBegin && limit < this.itemBeginPos[this.limitedItemIndex + 1]) {
            this.items[this.limitedItemIndex].limit(limit - limitedIndexBegin);
            return this;
        }
        int itemIndex = this.getItemIndex(limit);
        int beginOffset = this.itemBeginPos[itemIndex];
        int offsetInItem = limit - beginOffset;
        ByteBuffer item = this.items[itemIndex];
        item.limit(offsetInItem);
        for (i = this.limitedItemIndex; i < itemIndex; ++i) {
            this.items[i].limit(this.items[i].capacity());
        }
        this.limitedItemIndex = itemIndex;
        for (i = itemIndex + 1; i < this.items.length; ++i) {
            this.items[i].limit(this.items[i].position());
        }
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public MultiByteBuff slice() {
        this.checkRefCount();
        ByteBuffer[] copy2 = new ByteBuffer[this.limitedItemIndex - this.curItemIndex + 1];
        int i = this.curItemIndex;
        int j = 0;
        while (i <= this.limitedItemIndex) {
            copy2[j] = this.items[i].slice();
            ++i;
            ++j;
        }
        return new MultiByteBuff(this.refCnt, copy2);
    }

    @Override
    public MultiByteBuff duplicate() {
        this.checkRefCount();
        ByteBuffer[] itemsCopy = new ByteBuffer[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            itemsCopy[i] = this.items[i].duplicate();
        }
        return new MultiByteBuff(this.refCnt, itemsCopy, this.itemBeginPos, this.limit, this.limitedItemIndex, this.curItemIndex, this.markedItemIndex);
    }

    @Override
    public MultiByteBuff put(byte b) {
        this.checkRefCount();
        if (this.curItem.remaining() == 0) {
            if (this.curItemIndex == this.items.length - 1) {
                throw new BufferOverflowException();
            }
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
        }
        this.curItem.put(b);
        return this;
    }

    @Override
    public MultiByteBuff put(int index, byte b) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(index);
        ByteBuffer item = this.items[itemIndex];
        item.put(index - this.itemBeginPos[itemIndex], b);
        return this;
    }

    @Override
    public MultiByteBuff put(int destOffset, ByteBuff src, int srcOffset, int length) {
        this.checkRefCount();
        int destItemIndex = this.getItemIndex(destOffset);
        int srcItemIndex = MultiByteBuff.getItemIndexForByteBuff(src, srcOffset, length);
        ByteBuffer destItem = this.items[destItemIndex];
        destOffset = this.getRelativeOffset(destOffset, destItemIndex);
        ByteBuffer srcItem = MultiByteBuff.getItemByteBuffer(src, srcItemIndex);
        srcOffset = MultiByteBuff.getRelativeOffsetForByteBuff(src, srcOffset, srcItemIndex);
        while (length > 0) {
            int toWrite = destItem.limit() - destOffset;
            if (toWrite <= 0) {
                throw new BufferOverflowException();
            }
            int toRead = srcItem.limit() - srcOffset;
            if (toRead <= 0) {
                throw new BufferUnderflowException();
            }
            int toMove = Math.min(length, Math.min(toRead, toWrite));
            ByteBufferUtils.copyFromBufferToBuffer(srcItem, destItem, srcOffset, destOffset, toMove);
            if ((length -= toMove) == 0) break;
            if (toRead < toWrite) {
                if (++srcItemIndex >= MultiByteBuff.getItemByteBufferCount(src)) {
                    throw new BufferUnderflowException();
                }
                srcItem = MultiByteBuff.getItemByteBuffer(src, srcItemIndex);
                srcOffset = 0;
                destOffset += toMove;
                continue;
            }
            if (toRead > toWrite) {
                if (++destItemIndex >= this.items.length) {
                    throw new BufferOverflowException();
                }
                destItem = this.items[destItemIndex];
                destOffset = 0;
                srcOffset += toMove;
                continue;
            }
            if (++srcItemIndex >= MultiByteBuff.getItemByteBufferCount(src)) {
                throw new BufferUnderflowException();
            }
            srcItem = MultiByteBuff.getItemByteBuffer(src, srcItemIndex);
            srcOffset = 0;
            if (++destItemIndex >= this.items.length) {
                throw new BufferOverflowException();
            }
            destItem = this.items[destItemIndex];
            destOffset = 0;
        }
        return this;
    }

    private static ByteBuffer getItemByteBuffer(ByteBuff buf, int byteBufferIndex) {
        if (buf instanceof SingleByteBuff) {
            if (byteBufferIndex != 0) {
                throw new IndexOutOfBoundsException("index:[" + byteBufferIndex + "],but only index 0 is valid.");
            }
            return buf.nioByteBuffers()[0];
        }
        MultiByteBuff multiByteBuff = (MultiByteBuff)buf;
        if (byteBufferIndex < 0 || byteBufferIndex >= multiByteBuff.items.length) {
            throw new IndexOutOfBoundsException("index:[" + byteBufferIndex + "],but only index [0-" + multiByteBuff.items.length + ") is valid.");
        }
        return multiByteBuff.items[byteBufferIndex];
    }

    private static int getItemIndexForByteBuff(ByteBuff byteBuff, int offset, int length) {
        if (byteBuff instanceof SingleByteBuff) {
            ByteBuffer byteBuffer = byteBuff.nioByteBuffers()[0];
            if (offset + length > byteBuffer.limit()) {
                throw new BufferUnderflowException();
            }
            return 0;
        }
        MultiByteBuff multiByteBuff = (MultiByteBuff)byteBuff;
        return multiByteBuff.getItemIndex(offset);
    }

    private static int getRelativeOffsetForByteBuff(ByteBuff byteBuff, int globalOffset, int itemIndex) {
        if (byteBuff instanceof SingleByteBuff) {
            if (itemIndex != 0) {
                throw new IndexOutOfBoundsException("index:[" + itemIndex + "],but only index 0 is valid.");
            }
            return globalOffset;
        }
        return ((MultiByteBuff)byteBuff).getRelativeOffset(globalOffset, itemIndex);
    }

    private int getRelativeOffset(int globalOffset, int itemIndex) {
        if (itemIndex < 0 || itemIndex >= this.items.length) {
            throw new IndexOutOfBoundsException("index:[" + itemIndex + "],but only index [0-" + this.items.length + ") is valid.");
        }
        return globalOffset - this.itemBeginPos[itemIndex];
    }

    private static int getItemByteBufferCount(ByteBuff buf) {
        return buf instanceof SingleByteBuff ? 1 : ((MultiByteBuff)buf).items.length;
    }

    @Override
    public MultiByteBuff putInt(int val) {
        this.checkRefCount();
        if (this.curItem.remaining() >= 4) {
            this.curItem.putInt(val);
            return this;
        }
        if (this.curItemIndex == this.items.length - 1) {
            throw new BufferOverflowException();
        }
        this.put(MultiByteBuff.int3(val));
        this.put(MultiByteBuff.int2(val));
        this.put(MultiByteBuff.int1(val));
        this.put(MultiByteBuff.int0(val));
        return this;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    @Override
    public final MultiByteBuff put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public MultiByteBuff put(byte[] src, int offset, int length) {
        this.checkRefCount();
        if (this.curItem.remaining() >= length) {
            ByteBufferUtils.copyFromArrayToBuffer(this.curItem, src, offset, length);
            return this;
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    @Override
    public MultiByteBuff putLong(long val) {
        this.checkRefCount();
        if (this.curItem.remaining() >= 8) {
            this.curItem.putLong(val);
            return this;
        }
        if (this.curItemIndex == this.items.length - 1) {
            throw new BufferOverflowException();
        }
        this.put(MultiByteBuff.long7(val));
        this.put(MultiByteBuff.long6(val));
        this.put(MultiByteBuff.long5(val));
        this.put(MultiByteBuff.long4(val));
        this.put(MultiByteBuff.long3(val));
        this.put(MultiByteBuff.long2(val));
        this.put(MultiByteBuff.long1(val));
        this.put(MultiByteBuff.long0(val));
        return this;
    }

    private static byte long7(long x) {
        return (byte)(x >> 56);
    }

    private static byte long6(long x) {
        return (byte)(x >> 48);
    }

    private static byte long5(long x) {
        return (byte)(x >> 40);
    }

    private static byte long4(long x) {
        return (byte)(x >> 32);
    }

    private static byte long3(long x) {
        return (byte)(x >> 24);
    }

    private static byte long2(long x) {
        return (byte)(x >> 16);
    }

    private static byte long1(long x) {
        return (byte)(x >> 8);
    }

    private static byte long0(long x) {
        return (byte)x;
    }

    @Override
    public MultiByteBuff skip(int length) {
        this.checkRefCount();
        int jump = 0;
        while (true) {
            if ((jump = this.curItem.remaining()) >= length) break;
            this.curItem.position(this.curItem.position() + jump);
            length -= jump;
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
        }
        this.curItem.position(this.curItem.position() + length);
        return this;
    }

    @Override
    public MultiByteBuff moveBack(int length) {
        this.checkRefCount();
        while (length != 0) {
            if (length > this.curItem.position()) {
                length -= this.curItem.position();
                this.curItem.position(0);
                --this.curItemIndex;
                this.curItem = this.items[this.curItemIndex];
                continue;
            }
            this.curItem.position(this.curItem.position() - length);
            break;
        }
        return this;
    }

    @Override
    public ByteBuffer asSubByteBuffer(int length) {
        this.checkRefCount();
        if (this.curItem.remaining() >= length) {
            return this.curItem;
        }
        int offset = 0;
        byte[] dupB = new byte[length];
        int locCurItemIndex = this.curItemIndex;
        ByteBuffer locCurItem = this.curItem;
        while (length > 0) {
            int toRead = Math.min(length, locCurItem.remaining());
            ByteBufferUtils.copyFromBufferToArray(dupB, locCurItem, locCurItem.position(), offset, toRead);
            if ((length -= toRead) == 0) break;
            locCurItem = this.items[++locCurItemIndex];
            offset += toRead;
        }
        return ByteBuffer.wrap(dupB);
    }

    @Override
    public void asSubByteBuffer(int offset, int length, ObjectIntPair<ByteBuffer> pair) {
        int itemIndex;
        ByteBuffer item;
        this.checkRefCount();
        if (this.itemBeginPos[this.curItemIndex] <= offset) {
            int relOffsetInCurItem = offset - this.itemBeginPos[this.curItemIndex];
            if (this.curItem.limit() - relOffsetInCurItem >= length) {
                pair.setFirst(this.curItem);
                pair.setSecond(relOffsetInCurItem);
                return;
            }
        }
        if ((item = this.items[itemIndex = this.getItemIndex(offset)]).limit() - (offset -= this.itemBeginPos[itemIndex]) >= length) {
            pair.setFirst(item);
            pair.setSecond(offset);
            return;
        }
        byte[] dst = new byte[length];
        int destOffset = 0;
        while (length > 0) {
            int toRead = Math.min(length, item.limit() - offset);
            ByteBufferUtils.copyFromBufferToArray(dst, item, offset, destOffset, toRead);
            if ((length -= toRead) == 0) break;
            item = this.items[++itemIndex];
            destOffset += toRead;
            offset = 0;
        }
        pair.setFirst(ByteBuffer.wrap(dst));
        pair.setSecond(0);
    }

    @Override
    public void get(ByteBuffer out, int sourceOffset, int length) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(sourceOffset);
        ByteBuffer in = this.items[itemIndex];
        sourceOffset -= this.itemBeginPos[itemIndex];
        while (length > 0) {
            int toRead = Math.min(in.limit() - sourceOffset, length);
            ByteBufferUtils.copyFromBufferToBuffer(in, out, sourceOffset, toRead);
            if ((length -= toRead) == 0) break;
            in = this.items[++itemIndex];
            sourceOffset = 0;
        }
    }

    @Override
    public byte[] toBytes(int offset, int length) {
        this.checkRefCount();
        byte[] output = new byte[length];
        this.get(offset, output, 0, length);
        return output;
    }

    private int internalRead(ReadableByteChannel channel, long offset, ByteBuff.ChannelReader reader) throws IOException {
        this.checkRefCount();
        int total = 0;
        while (this.buffsIterator.hasNext()) {
            ByteBuffer buffer = this.buffsIterator.next();
            int len = MultiByteBuff.read(channel, buffer, offset, reader);
            if (len > 0) {
                total += len;
                offset += (long)len;
            }
            if (!buffer.hasRemaining()) continue;
            this.curItem = buffer;
            --this.curItemIndex;
            break;
        }
        return total;
    }

    @Override
    public int read(ReadableByteChannel channel) throws IOException {
        return this.internalRead(channel, 0L, CHANNEL_READER);
    }

    @Override
    public int read(FileChannel channel, long offset) throws IOException {
        return this.internalRead(channel, offset, FILE_READER);
    }

    @Override
    public int write(FileChannel channel, long offset) throws IOException {
        this.checkRefCount();
        int total = 0;
        while (this.buffsIterator.hasNext()) {
            ByteBuffer buffer = this.buffsIterator.next();
            while (buffer.hasRemaining()) {
                int len = channel.write(buffer, offset);
                total += len;
                offset += (long)len;
            }
        }
        return total;
    }

    @Override
    public ByteBuffer[] nioByteBuffers() {
        this.checkRefCount();
        return this.items;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiByteBuff)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MultiByteBuff that = (MultiByteBuff)obj;
        if (this.capacity() != that.capacity()) {
            return false;
        }
        return ByteBuff.compareTo(this, this.position(), this.limit(), that, that.position(), that.limit()) == 0;
    }

    public int hashCode() {
        int hash = 0;
        for (ByteBuffer b : this.items) {
            hash += b.hashCode();
        }
        return hash;
    }

    @Override
    public MultiByteBuff retain() {
        this.refCnt.retain();
        return this;
    }
}

