/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScanDeleteTracker
implements DeleteTracker {
    protected boolean hasFamilyStamp = false;
    protected long familyStamp = 0L;
    protected SortedSet<Long> familyVersionStamps = new TreeSet<Long>();
    protected Cell deleteCell = null;
    protected byte[] deleteBuffer = null;
    protected int deleteOffset = 0;
    protected int deleteLength = 0;
    protected byte deleteType = 0;
    protected long deleteTimestamp = 0L;
    protected final CellComparator comparator;

    public ScanDeleteTracker(CellComparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public void add(Cell cell) {
        long timestamp = cell.getTimestamp();
        byte type2 = cell.getTypeByte();
        if (!this.hasFamilyStamp || timestamp > this.familyStamp) {
            if (type2 == KeyValue.Type.DeleteFamily.getCode()) {
                this.hasFamilyStamp = true;
                this.familyStamp = timestamp;
                return;
            }
            if (type2 == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                this.familyVersionStamps.add(timestamp);
                return;
            }
            if (this.deleteCell != null && type2 < this.deleteType && CellUtil.matchingQualifier(cell, this.deleteCell)) {
                return;
            }
            this.deleteCell = cell;
            this.deleteType = type2;
            this.deleteTimestamp = timestamp;
        }
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        long timestamp = cell.getTimestamp();
        if (this.hasFamilyStamp && timestamp <= this.familyStamp) {
            return DeleteTracker.DeleteResult.FAMILY_DELETED;
        }
        if (this.familyVersionStamps.contains(timestamp)) {
            return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
        }
        if (this.deleteCell != null) {
            int ret = -this.comparator.compareQualifiers(cell, this.deleteCell);
            if (ret == 0) {
                if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                    return DeleteTracker.DeleteResult.COLUMN_DELETED;
                }
                if (timestamp == this.deleteTimestamp) {
                    return DeleteTracker.DeleteResult.VERSION_DELETED;
                }
                assert (timestamp < this.deleteTimestamp);
                this.deleteCell = null;
            } else if (ret < 0) {
                this.deleteCell = null;
            } else {
                throw new IllegalStateException("isDelete failed: deleteBuffer=" + Bytes.toStringBinary(this.deleteCell.getQualifierArray(), this.deleteCell.getQualifierOffset(), this.deleteCell.getQualifierLength()) + ", qualifier=" + Bytes.toStringBinary(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()) + ", timestamp=" + timestamp + ", comparison result: " + ret);
            }
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public boolean isEmpty() {
        return this.deleteCell == null && !this.hasFamilyStamp && this.familyVersionStamps.isEmpty();
    }

    @Override
    public void reset() {
        this.hasFamilyStamp = false;
        this.familyStamp = 0L;
        this.familyVersionStamps.clear();
        this.deleteCell = null;
    }

    @Override
    public void update() {
        this.reset();
    }

    @Override
    public void beforeShipped() throws IOException {
        if (this.deleteCell != null) {
            this.deleteCell = KeyValueUtil.toNewKeyCell(this.deleteCell);
        }
    }

    @Override
    public CellComparator getCellComparator() {
        return this.comparator;
    }
}

