/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.throttle;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StoreHotnessProtector {
    private static final Logger LOG = LoggerFactory.getLogger(StoreHotnessProtector.class);
    private volatile int parallelPutToStoreThreadLimit;
    private volatile int parallelPreparePutToStoreThreadLimit;
    public static final String PARALLEL_PUT_STORE_THREADS_LIMIT = "hbase.region.store.parallel.put.limit";
    public static final String PARALLEL_PREPARE_PUT_STORE_MULTIPLIER = "hbase.region.store.parallel.prepare.put.multiplier";
    private static final int DEFAULT_PARALLEL_PUT_STORE_THREADS_LIMIT = 10;
    private volatile int parallelPutToStoreThreadLimitCheckMinColumnCount;
    public static final String PARALLEL_PUT_STORE_THREADS_LIMIT_MIN_COLUMN_COUNT = "hbase.region.store.parallel.put.limit.min.column.count";
    private static final int DEFAULT_PARALLEL_PUT_STORE_THREADS_LIMIT_MIN_COLUMN_NUM = 100;
    private static final int DEFAULT_PARALLEL_PREPARE_PUT_STORE_MULTIPLIER = 2;
    private final Map<byte[], AtomicInteger> preparePutToStoreMap = new ConcurrentSkipListMap<byte[], AtomicInteger>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private final Region region;
    public static final long FIXED_SIZE = ClassSize.align(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 12);

    public StoreHotnessProtector(Region region, Configuration conf) {
        this.init(conf);
        this.region = region;
    }

    public void init(Configuration conf) {
        this.parallelPutToStoreThreadLimit = conf.getInt(PARALLEL_PUT_STORE_THREADS_LIMIT, 10);
        this.parallelPreparePutToStoreThreadLimit = conf.getInt(PARALLEL_PREPARE_PUT_STORE_MULTIPLIER, 2) * this.parallelPutToStoreThreadLimit;
        this.parallelPutToStoreThreadLimitCheckMinColumnCount = conf.getInt(PARALLEL_PUT_STORE_THREADS_LIMIT_MIN_COLUMN_COUNT, 100);
    }

    public void update(Configuration conf) {
        this.init(conf);
        this.preparePutToStoreMap.clear();
        LOG.debug("update config: " + this.toString());
    }

    public void start(Map<byte[], List<Cell>> familyMaps) throws RegionTooBusyException {
        if (!this.isEnable()) {
            return;
        }
        String tooBusyStore = null;
        boolean aboveParallelThreadLimit = false;
        boolean aboveParallelPrePutLimit = false;
        for (Map.Entry<byte[], List<Cell>> e : familyMaps.entrySet()) {
            boolean storeAbovePrePut;
            Store store = this.region.getStore(e.getKey());
            if (store == null || e.getValue() == null || e.getValue().size() <= this.parallelPutToStoreThreadLimitCheckMinColumnCount) continue;
            int preparePutCount = this.preparePutToStoreMap.computeIfAbsent(e.getKey(), key -> new AtomicInteger()).incrementAndGet();
            boolean storeAboveThread = store.getCurrentParallelPutCount() > this.parallelPutToStoreThreadLimit;
            boolean bl = storeAbovePrePut = preparePutCount > this.parallelPreparePutToStoreThreadLimit;
            if (storeAboveThread || storeAbovePrePut) {
                tooBusyStore = tooBusyStore == null ? store.getColumnFamilyName() : tooBusyStore + "," + store.getColumnFamilyName();
            }
            aboveParallelThreadLimit |= storeAboveThread;
            aboveParallelPrePutLimit |= storeAbovePrePut;
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace(store.getColumnFamilyName() + ": preparePutCount=" + preparePutCount + "; currentParallelPutCount=" + store.getCurrentParallelPutCount());
        }
        if (aboveParallelThreadLimit || aboveParallelPrePutLimit) {
            String msg = "StoreTooBusy," + this.region.getRegionInfo().getRegionNameAsString() + ":" + tooBusyStore + " Above " + (aboveParallelThreadLimit ? "parallelPutToStoreThreadLimit(" + this.parallelPutToStoreThreadLimit + ")" : "") + (aboveParallelThreadLimit && aboveParallelPrePutLimit ? " or " : "") + (aboveParallelPrePutLimit ? "parallelPreparePutToStoreThreadLimit(" + this.parallelPreparePutToStoreThreadLimit + ")" : "");
            LOG.trace(msg);
            throw new RegionTooBusyException(msg);
        }
    }

    public void finish(Map<byte[], List<Cell>> familyMaps) {
        if (!this.isEnable()) {
            return;
        }
        for (Map.Entry<byte[], List<Cell>> e : familyMaps.entrySet()) {
            AtomicInteger counter2;
            Store store = this.region.getStore(e.getKey());
            if (store == null || e.getValue() == null || e.getValue().size() <= this.parallelPutToStoreThreadLimitCheckMinColumnCount || (counter2 = this.preparePutToStoreMap.get(e.getKey())) == null || counter2.decrementAndGet() >= 0) continue;
            counter2.incrementAndGet();
        }
    }

    public String toString() {
        return "StoreHotnessProtector, parallelPutToStoreThreadLimit=" + this.parallelPutToStoreThreadLimit + " ; minColumnNum=" + this.parallelPutToStoreThreadLimitCheckMinColumnCount + " ; preparePutThreadLimit=" + this.parallelPreparePutToStoreThreadLimit + " ; hotProtect now " + (this.isEnable() ? "enable" : "disable");
    }

    public boolean isEnable() {
        return this.parallelPutToStoreThreadLimit > 0;
    }

    Map<byte[], AtomicInteger> getPreparePutToStoreMap() {
        return this.preparePutToStoreMap;
    }
}

