/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.replication.regionserver.SourceFSConfigurationProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultSourceFSConfigurationProvider
implements SourceFSConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSourceFSConfigurationProvider.class);
    private final Map<String, Configuration> sourceClustersConfs = new HashMap<String, Configuration>();
    private static final String XML = ".xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConf(Configuration sinkConf, String replicationClusterId) throws IOException {
        if (this.sourceClustersConfs.get(replicationClusterId) == null) {
            Map<String, Configuration> map2 = this.sourceClustersConfs;
            synchronized (map2) {
                if (this.sourceClustersConfs.get(replicationClusterId) == null) {
                    String[] listofConfFiles;
                    LOG.info("Loading source cluster FS client conf for cluster " + replicationClusterId);
                    Configuration sourceClusterConf = new Configuration(false);
                    String replicationConfDir = sinkConf.get("hbase.replication.conf.dir");
                    if (replicationConfDir == null) {
                        LOG.debug("hbase.replication.conf.dir is not configured.");
                        URL resource = HBaseConfiguration.class.getClassLoader().getResource("hbase-site.xml");
                        if (resource != null) {
                            String path = resource.getPath();
                            replicationConfDir = path.substring(0, path.lastIndexOf("/"));
                        } else {
                            replicationConfDir = System.getenv("HBASE_CONF_DIR");
                        }
                    }
                    File confDir = new File(replicationConfDir, replicationClusterId);
                    LOG.info("Loading source cluster " + replicationClusterId + " file system configurations from xml files under directory " + confDir);
                    for (String confFile : listofConfFiles = FileUtil.list((File)confDir)) {
                        if (!new File(confDir, confFile).isFile() || !confFile.endsWith(XML)) continue;
                        sourceClusterConf.addResource(new Path(confDir.getPath(), confFile));
                    }
                    this.sourceClustersConfs.put(replicationClusterId, sourceClusterConf);
                }
            }
        }
        return this.sourceClustersConfs.get(replicationClusterId);
    }
}

