/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.EncryptionProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class EncryptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionUtil.class);

    private EncryptionUtil() {
    }

    public static byte[] wrapKey(Configuration conf, byte[] key, String algorithm) throws IOException {
        return EncryptionUtil.wrapKey(conf, conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), new SecretKeySpec(key, algorithm));
    }

    public static byte[] wrapKey(Configuration conf, String subject, Key key) throws IOException {
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        EncryptionProtos.WrappedKey.Builder builder = EncryptionProtos.WrappedKey.newBuilder();
        builder.setAlgorithm(key.getAlgorithm());
        byte[] iv = null;
        if (cipher.getIvLength() > 0) {
            iv = new byte[cipher.getIvLength()];
            Bytes.secureRandom(iv);
            builder.setIv(UnsafeByteOperations.unsafeWrap(iv));
        }
        byte[] keyBytes = key.getEncoded();
        builder.setLength(keyBytes.length);
        builder.setHashAlgorithm(Encryption.getConfiguredHashAlgorithm(conf));
        builder.setHash(UnsafeByteOperations.unsafeWrap(Encryption.computeCryptoKeyHash(conf, keyBytes)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encryption.encryptWithSubjectKey(out, new ByteArrayInputStream(keyBytes), subject, conf, cipher, iv);
        builder.setData(UnsafeByteOperations.unsafeWrap(out.toByteArray()));
        out.reset();
        builder.build().writeDelimitedTo(out);
        return out.toByteArray();
    }

    public static Key unwrapKey(Configuration conf, String subject, byte[] value) throws IOException, KeyException {
        EncryptionProtos.WrappedKey wrappedKey = EncryptionProtos.WrappedKey.PARSER.parseDelimitedFrom(new ByteArrayInputStream(value));
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        return EncryptionUtil.getUnwrapKey(conf, subject, wrappedKey, cipher);
    }

    private static Key getUnwrapKey(Configuration conf, String subject, EncryptionProtos.WrappedKey wrappedKey, Cipher cipher) throws IOException, KeyException {
        String wrappedHashAlgorithm;
        String configuredHashAlgorithm = Encryption.getConfiguredHashAlgorithm(conf);
        if (!configuredHashAlgorithm.equalsIgnoreCase(wrappedHashAlgorithm = wrappedKey.getHashAlgorithm().trim())) {
            String msg = String.format("Unexpected encryption key hash algorithm: %s (expecting: %s)", wrappedHashAlgorithm, configuredHashAlgorithm);
            if (Encryption.failOnHashAlgorithmMismatch(conf)) {
                throw new KeyException(msg);
            }
            LOG.debug(msg);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] iv = wrappedKey.hasIv() ? wrappedKey.getIv().toByteArray() : null;
        Encryption.decryptWithSubjectKey(out, wrappedKey.getData().newInput(), wrappedKey.getLength(), subject, conf, cipher, iv);
        byte[] keyBytes = out.toByteArray();
        if (wrappedKey.hasHash() && !Bytes.equals(wrappedKey.getHash().toByteArray(), Encryption.hashWithAlg(wrappedHashAlgorithm, new byte[][]{keyBytes}))) {
            throw new KeyException("Key was not successfully unwrapped");
        }
        return new SecretKeySpec(keyBytes, wrappedKey.getAlgorithm());
    }

    public static Key unwrapWALKey(Configuration conf, String subject, byte[] value) throws IOException, KeyException {
        EncryptionProtos.WrappedKey wrappedKey = EncryptionProtos.WrappedKey.PARSER.parseDelimitedFrom(new ByteArrayInputStream(value));
        String algorithm = conf.get("hbase.crypto.wal.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        return EncryptionUtil.getUnwrapKey(conf, subject, wrappedKey, cipher);
    }

    public static Encryption.Context createEncryptionContext(Configuration conf, ColumnFamilyDescriptor family) throws IOException {
        Encryption.Context cryptoContext = Encryption.Context.NONE;
        String cipherName = family.getEncryptionType();
        if (cipherName != null) {
            Cipher cipher;
            Key key;
            if (!Encryption.isEncryptionEnabled(conf)) {
                throw new IllegalStateException("Encryption for family '" + family.getNameAsString() + "' configured with type '" + cipherName + "' but the encryption feature is disabled");
            }
            byte[] keyBytes = family.getEncryptionKey();
            if (keyBytes != null) {
                key = EncryptionUtil.unwrapKey(conf, keyBytes);
                cipher = Encryption.getCipher(conf, key.getAlgorithm());
                if (cipher == null) {
                    throw new IllegalStateException("Cipher '" + key.getAlgorithm() + "' is not available");
                }
                if (!cipher.getName().equalsIgnoreCase(cipherName)) {
                    throw new IllegalStateException("Encryption for family '" + family.getNameAsString() + "' configured with type '" + cipherName + "' but key specifies algorithm '" + cipher.getName() + "'");
                }
            } else {
                cipher = Encryption.getCipher(conf, cipherName);
                if (cipher == null) {
                    throw new IllegalStateException("Cipher '" + cipherName + "' is not available");
                }
                key = cipher.getRandomKey();
            }
            cryptoContext = Encryption.newContext(conf);
            cryptoContext.setCipher(cipher);
            cryptoContext.setKey(key);
        }
        return cryptoContext;
    }

    public static Key unwrapKey(Configuration conf, byte[] keyBytes) throws IOException {
        Key key;
        String masterKeyName = conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName());
        try {
            key = EncryptionUtil.unwrapKey(conf, masterKeyName, keyBytes);
        }
        catch (KeyException e) {
            String alternateKeyName;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to unwrap key with current master key '" + masterKeyName + "'");
            }
            if ((alternateKeyName = conf.get("hbase.crypto.master.alternate.key.name")) != null) {
                try {
                    key = EncryptionUtil.unwrapKey(conf, alternateKeyName, keyBytes);
                }
                catch (KeyException ex) {
                    throw new IOException(ex);
                }
            }
            throw new IOException(e);
        }
        return key;
    }

    public static CryptoAES createCryptoAES(RPCProtos.CryptoCipherMeta cryptoCipherMeta, Configuration conf) throws IOException {
        Properties properties2 = new Properties();
        properties2.setProperty("commons.crypto.cipher.classes", conf.get("hbase.rpc.crypto.encryption.aes.cipher.class", "org.apache.commons.crypto.cipher.JceCipher"));
        return new CryptoAES(cryptoCipherMeta.getTransformation(), properties2, cryptoCipherMeta.getInKey().toByteArray(), cryptoCipherMeta.getOutKey().toByteArray(), cryptoCipherMeta.getInIv().toByteArray(), cryptoCipherMeta.getOutIv().toByteArray());
    }
}

