/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import io.hops.hudi.com.google.protobuf.ByteString;
import io.hops.hudi.com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class VisibilityClient {
    public static boolean isCellVisibilityEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.CELL_VISIBILITY);
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabel(Configuration conf, String label) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.addLabels(connection, new String[]{label});
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabel(Connection connection, String label) throws Throwable {
        return VisibilityClient.addLabels(connection, new String[]{label});
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabels(Configuration conf, String[] labels) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.addLabels(connection, labels);
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabels(Connection connection, final String[] labels) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.VisibilityLabelsRequest.Builder builder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
                    for (String label : labels) {
                        if (label.length() <= 0) continue;
                        VisibilityLabelsProtos.VisibilityLabel.Builder newBuilder = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
                        newBuilder.setLabel(ByteStringer.wrap(Bytes.toBytes(label)));
                        builder.addVisLabel(newBuilder.build());
                    }
                    service.addLabels(this.controller, builder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result2 = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result2.values().iterator().next();
            return visibilityLabelsResponse;
        }
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse setAuths(Configuration conf, String[] auths, String user) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setOrClearAuths(connection, auths, user, true);
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse setAuths(Connection connection, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(connection, auths, user, true);
    }

    @Deprecated
    public static VisibilityLabelsProtos.GetAuthsResponse getAuths(Configuration conf, String user) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = VisibilityClient.getAuths(connection, user);
            return getAuthsResponse;
        }
    }

    public static VisibilityLabelsProtos.GetAuthsResponse getAuths(Connection connection, final String user) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.GetAuthsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.GetAuthsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.GetAuthsRequest.Builder getAuthReqBuilder = VisibilityLabelsProtos.GetAuthsRequest.newBuilder();
                    getAuthReqBuilder.setUser(ByteStringer.wrap(Bytes.toBytes(user)));
                    service.getAuths(this.controller, getAuthReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.GetAuthsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.GetAuthsResponse> result2 = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = result2.values().iterator().next();
            return getAuthsResponse;
        }
    }

    @Deprecated
    public static VisibilityLabelsProtos.ListLabelsResponse listLabels(Configuration conf, String regex2) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.ListLabelsResponse listLabelsResponse = VisibilityClient.listLabels(connection, regex2);
            return listLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.ListLabelsResponse listLabels(Connection connection, final String regex2) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.ListLabelsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.ListLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.ListLabelsRequest.Builder listAuthLabelsReqBuilder = VisibilityLabelsProtos.ListLabelsRequest.newBuilder();
                    if (regex2 != null) {
                        Pattern pattern = Pattern.compile(regex2);
                        listAuthLabelsReqBuilder.setRegex(pattern.toString());
                    }
                    service.listLabels(this.controller, listAuthLabelsReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.ListLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.ListLabelsResponse> result2 = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.ListLabelsResponse listLabelsResponse = result2.values().iterator().next();
            return listLabelsResponse;
        }
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse clearAuths(Configuration conf, String[] auths, String user) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setOrClearAuths(connection, auths, user, false);
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse clearAuths(Connection connection, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(connection, auths, user, false);
    }

    private static VisibilityLabelsProtos.VisibilityLabelsResponse setOrClearAuths(Connection connection, final String[] auths, final String user, final boolean setOrClear) throws IOException, ServiceException, Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.SetAuthsRequest.Builder setAuthReqBuilder = VisibilityLabelsProtos.SetAuthsRequest.newBuilder();
                    setAuthReqBuilder.setUser(ByteStringer.wrap(Bytes.toBytes(user)));
                    for (String auth : auths) {
                        if (auth.length() <= 0) continue;
                        setAuthReqBuilder.addAuth(ByteString.copyFromUtf8(auth));
                    }
                    if (setOrClear) {
                        service.setAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    } else {
                        service.clearAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    }
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result2 = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result2.values().iterator().next();
            return visibilityLabelsResponse;
        }
    }
}

