/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool.coprocessor;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorMethod;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CoprocessorMethods {
    private final Set<CoprocessorMethod> methods = new HashSet<CoprocessorMethod>();

    public void addMethod(String name2, String ... parameters2) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(name2).withParameters(parameters2);
        this.methods.add(cpMethod);
    }

    public void addMethod(String name2, Class<?> ... parameters2) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(name2).withParameters(parameters2);
        this.methods.add(cpMethod);
    }

    public void addMethod(Method method) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(method.getName()).withParameters(method.getParameterTypes());
        this.methods.add(cpMethod);
    }

    public boolean hasMethod(String name2, String ... parameters2) {
        CoprocessorMethod method = new CoprocessorMethod(name2).withParameters(parameters2);
        return this.methods.contains(method);
    }

    public boolean hasMethod(String name2, Class<?> ... parameters2) {
        CoprocessorMethod method = new CoprocessorMethod(name2).withParameters(parameters2);
        return this.methods.contains(method);
    }

    public boolean hasMethod(Method method) {
        CoprocessorMethod cpMethod = new CoprocessorMethod(method.getName()).withParameters(method.getParameterTypes());
        return this.methods.contains(cpMethod);
    }
}

