/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class AvlUtil {
    private AvlUtil() {
    }

    @InterfaceAudience.Private
    public static class AvlIterableList {
        public static <TNode extends AvlLinkedNode> TNode readNext(TNode node) {
            return node.iterNext;
        }

        public static <TNode extends AvlLinkedNode> TNode readPrev(TNode node) {
            return node.iterPrev;
        }

        public static <TNode extends AvlLinkedNode> TNode prepend(TNode head, TNode node) {
            assert (!AvlIterableList.isLinked(node)) : node + " is already linked";
            if (head != null) {
                Object tail = head.iterPrev;
                ((AvlLinkedNode)tail).iterNext = node;
                head.iterPrev = node;
                node.iterNext = head;
                node.iterPrev = tail;
            } else {
                node.iterNext = node;
                node.iterPrev = node;
            }
            return node;
        }

        public static <TNode extends AvlLinkedNode> TNode append(TNode head, TNode node) {
            assert (!AvlIterableList.isLinked(node)) : node + " is already linked";
            if (head != null) {
                Object tail = head.iterPrev;
                ((AvlLinkedNode)tail).iterNext = node;
                node.iterNext = head;
                node.iterPrev = tail;
                head.iterPrev = node;
                return head;
            }
            node.iterNext = node;
            node.iterPrev = node;
            return node;
        }

        public static <TNode extends AvlLinkedNode> TNode appendList(TNode head, TNode otherHead) {
            if (head == null) {
                return otherHead;
            }
            if (otherHead == null) {
                return head;
            }
            Object tail = head.iterPrev;
            Object otherTail = otherHead.iterPrev;
            ((AvlLinkedNode)tail).iterNext = otherHead;
            otherHead.iterPrev = tail;
            ((AvlLinkedNode)otherTail).iterNext = head;
            head.iterPrev = otherTail;
            return head;
        }

        public static <TNode extends AvlLinkedNode> TNode remove(TNode head, TNode node) {
            assert (AvlIterableList.isLinked(node)) : node + " is not linked";
            if (node != node.iterNext) {
                ((AvlLinkedNode)node.iterPrev).iterNext = node.iterNext;
                ((AvlLinkedNode)node.iterNext).iterPrev = node.iterPrev;
                head = head == node ? node.iterNext : head;
            } else {
                head = null;
            }
            node.iterNext = null;
            node.iterPrev = null;
            return head;
        }

        public static <TNode extends AvlLinkedNode> TNode prepend(TNode head, TNode base2, TNode node) {
            assert (!AvlIterableList.isLinked(node)) : node + " is already linked";
            node.iterNext = base2;
            node.iterPrev = base2.iterPrev;
            ((AvlLinkedNode)base2.iterPrev).iterNext = node;
            base2.iterPrev = node;
            return head == base2 ? node : head;
        }

        public static <TNode extends AvlLinkedNode> boolean isLinked(TNode node) {
            return node.iterPrev != null && node.iterNext != null;
        }
    }

    @InterfaceAudience.Private
    public static class AvlTreeIterator<TNode extends AvlNode>
    implements Iterator<TNode> {
        private final Object[] stack = new Object[64];
        private TNode current = null;
        private int height = 0;

        public AvlTreeIterator() {
        }

        public AvlTreeIterator(TNode root) {
            this.seekFirst(root);
        }

        public AvlTreeIterator(TNode root, Object key, AvlKeyComparator<TNode> keyComparator) {
            this.seekTo(root, key, keyComparator);
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public TNode next() {
            TNode node = this.current;
            this.seekNext();
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void seekFirst(TNode root) {
            this.current = root;
            this.height = 0;
            if (root != null) {
                while (((AvlNode)this.current).avlLeft != null) {
                    this.stack[this.height++] = this.current;
                    this.current = ((AvlNode)this.current).avlLeft;
                }
            }
        }

        public void seekTo(TNode root, Object key, AvlKeyComparator<TNode> keyComparator) {
            this.current = null;
            this.height = 0;
            Object node = root;
            while (node != null) {
                if (keyComparator.compareKey(node, key) >= 0) {
                    if (((AvlNode)node).avlLeft != null) {
                        this.stack[this.height++] = node;
                        node = ((AvlNode)node).avlLeft;
                        continue;
                    }
                    this.current = node;
                    return;
                }
                if (((AvlNode)node).avlRight != null) {
                    this.stack[this.height++] = node;
                    node = ((AvlNode)node).avlRight;
                    continue;
                }
                if (this.height > 0) {
                    AvlNode parent = (AvlNode)this.stack[--this.height];
                    while (node == parent.avlRight) {
                        if (this.height == 0) {
                            this.current = null;
                            return;
                        }
                        node = parent;
                        parent = (AvlNode)this.stack[--this.height];
                    }
                    this.current = parent;
                    return;
                }
                this.current = null;
                return;
            }
        }

        private void seekNext() {
            if (this.current == null) {
                return;
            }
            if (((AvlNode)this.current).avlRight != null) {
                this.stack[this.height++] = this.current;
                this.current = ((AvlNode)this.current).avlRight;
                while (((AvlNode)this.current).avlLeft != null) {
                    this.stack[this.height++] = this.current;
                    this.current = ((AvlNode)this.current).avlLeft;
                }
            } else {
                TNode node;
                do {
                    if (this.height == 0) {
                        this.current = null;
                        return;
                    }
                    node = this.current;
                    this.current = (AvlNode)this.stack[--this.height];
                } while (((AvlNode)this.current).avlRight == node);
            }
        }
    }

    @InterfaceAudience.Private
    public static class AvlTree {
        public static <TNode extends AvlNode> TNode get(TNode root, Object key, AvlKeyComparator<TNode> keyComparator) {
            while (root != null) {
                int cmp = keyComparator.compareKey(root, key);
                if (cmp > 0) {
                    root = root.avlLeft;
                    continue;
                }
                if (cmp < 0) {
                    root = root.avlRight;
                    continue;
                }
                return root;
            }
            return null;
        }

        public static <TNode extends AvlNode> TNode getFirst(TNode root) {
            if (root != null) {
                while (root.avlLeft != null) {
                    root = root.avlLeft;
                }
            }
            return root;
        }

        public static <TNode extends AvlNode> TNode getLast(TNode root) {
            if (root != null) {
                while (root.avlRight != null) {
                    root = root.avlRight;
                }
            }
            return root;
        }

        public static <TNode extends AvlNode> TNode insert(TNode root, TNode node) {
            if (root == null) {
                return node;
            }
            int cmp = node.compareTo(root);
            assert (cmp != 0) : "node already inserted: " + root;
            if (cmp < 0) {
                root.avlLeft = AvlTree.insert(root.avlLeft, node);
            } else {
                root.avlRight = AvlTree.insert(root.avlRight, node);
            }
            return AvlTree.balance(root);
        }

        public static <TNode extends AvlNode> TNode insert(TNode root, Object key, AvlKeyComparator<TNode> keyComparator, AvlInsertOrReplace<TNode> insertOrReplace) {
            if (root == null) {
                return insertOrReplace.insert(key);
            }
            int cmp = keyComparator.compareKey(root, key);
            if (cmp < 0) {
                root.avlLeft = AvlTree.insert(root.avlLeft, key, keyComparator, insertOrReplace);
            } else if (cmp > 0) {
                root.avlRight = AvlTree.insert(root.avlRight, key, keyComparator, insertOrReplace);
            } else {
                Object left = root.avlLeft;
                Object right = root.avlRight;
                root = insertOrReplace.replace(key, root);
                root.avlLeft = left;
                root.avlRight = right;
                return root;
            }
            return AvlTree.balance(root);
        }

        private static <TNode extends AvlNode> TNode removeMin(TNode p) {
            if (p.avlLeft == null) {
                return p.avlRight;
            }
            p.avlLeft = AvlTree.removeMin(p.avlLeft);
            return AvlTree.balance(p);
        }

        public static <TNode extends AvlNode> TNode remove(TNode root, Object key, AvlKeyComparator<TNode> keyComparator) {
            return AvlTree.remove(root, key, keyComparator, null);
        }

        public static <TNode extends AvlNode> TNode remove(TNode root, Object key, AvlKeyComparator<TNode> keyComparator, AtomicBoolean removed) {
            if (root == null) {
                return null;
            }
            int cmp = keyComparator.compareKey(root, key);
            if (cmp == 0) {
                if (removed != null) {
                    removed.set(true);
                }
                Object q = root.avlLeft;
                Object r = root.avlRight;
                if (r == null) {
                    return q;
                }
                Object min = AvlTree.getFirst(r);
                ((AvlNode)min).avlRight = AvlTree.removeMin(r);
                ((AvlNode)min).avlLeft = q;
                return AvlTree.balance(min);
            }
            if (cmp > 0) {
                root.avlLeft = AvlTree.remove(root.avlLeft, key, keyComparator);
            } else {
                root.avlRight = AvlTree.remove(root.avlRight, key, keyComparator);
            }
            return AvlTree.balance(root);
        }

        public static <TNode extends AvlNode> void visit(TNode root, AvlNodeVisitor<TNode> visitor2) {
            if (root == null) {
                return;
            }
            AvlTreeIterator<TNode> iterator2 = new AvlTreeIterator<TNode>(root);
            boolean visitNext = true;
            while (visitNext && iterator2.hasNext()) {
                visitNext = visitor2.visitNode(iterator2.next());
            }
        }

        private static <TNode extends AvlNode> TNode balance(TNode p) {
            AvlTree.fixHeight(p);
            int balance = AvlTree.balanceFactor(p);
            if (balance == 2) {
                if (AvlTree.balanceFactor(p.avlRight) < 0) {
                    p.avlRight = AvlTree.rotateRight(p.avlRight);
                }
                return AvlTree.rotateLeft(p);
            }
            if (balance == -2) {
                if (AvlTree.balanceFactor(p.avlLeft) > 0) {
                    p.avlLeft = AvlTree.rotateLeft(p.avlLeft);
                }
                return AvlTree.rotateRight(p);
            }
            return p;
        }

        private static <TNode extends AvlNode> TNode rotateRight(TNode p) {
            Object q = p.avlLeft;
            p.avlLeft = ((AvlNode)q).avlRight;
            ((AvlNode)q).avlRight = p;
            AvlTree.fixHeight(p);
            AvlTree.fixHeight(q);
            return q;
        }

        private static <TNode extends AvlNode> TNode rotateLeft(TNode q) {
            Object p = q.avlRight;
            q.avlRight = ((AvlNode)p).avlLeft;
            ((AvlNode)p).avlLeft = q;
            AvlTree.fixHeight(q);
            AvlTree.fixHeight(p);
            return p;
        }

        private static <TNode extends AvlNode> void fixHeight(TNode node) {
            int heightLeft = AvlTree.height(node.avlLeft);
            int heightRight = AvlTree.height(node.avlRight);
            node.avlHeight = 1 + Math.max(heightLeft, heightRight);
        }

        private static <TNode extends AvlNode> int height(TNode node) {
            return node != null ? node.avlHeight : 0;
        }

        private static <TNode extends AvlNode> int balanceFactor(TNode node) {
            return AvlTree.height(node.avlRight) - AvlTree.height(node.avlLeft);
        }
    }

    @InterfaceAudience.Private
    public static interface AvlNodeVisitor<TNode extends AvlNode> {
        public boolean visitNode(TNode var1);
    }

    @InterfaceAudience.Private
    public static interface AvlKeyComparator<TNode extends AvlNode> {
        public int compareKey(TNode var1, Object var2);
    }

    @InterfaceAudience.Private
    public static interface AvlInsertOrReplace<TNode extends AvlNode> {
        public TNode insert(Object var1);

        public TNode replace(Object var1, TNode var2);
    }

    @InterfaceAudience.Private
    public static abstract class AvlLinkedNode<TNode extends AvlLinkedNode>
    extends AvlNode<TNode> {
        protected TNode iterNext = null;
        protected TNode iterPrev = null;
    }

    @InterfaceAudience.Private
    public static abstract class AvlNode<TNode extends AvlNode> {
        protected TNode avlLeft;
        protected TNode avlRight;
        protected int avlHeight;

        public abstract int compareTo(TNode var1);
    }
}

