/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Ordering;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.HbckErrorReporter;
import org.apache.hadoop.hbase.util.HbckRegionInfo;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSplitCalculator;
import org.apache.hadoop.hbase.util.hbck.TableIntegrityErrorHandler;
import org.apache.hadoop.hbase.util.hbck.TableIntegrityErrorHandlerImpl;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HbckTableInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)HbckTableInfo.class.getName());
    private static final String TO_BE_LOADED = "to_be_loaded";
    TableName tableName;
    TreeSet<ServerName> deployedOn;
    final List<HbckRegionInfo> backwards = new ArrayList<HbckRegionInfo>();
    final Map<Path, HbckRegionInfo> sidelinedRegions = new HashMap<Path, HbckRegionInfo>();
    final RegionSplitCalculator<HbckRegionInfo> sc = new RegionSplitCalculator<HbckRegionInfo>(HbckRegionInfo.COMPARATOR);
    final Set<TableDescriptor> htds = new HashSet<TableDescriptor>();
    final Multimap<byte[], HbckRegionInfo> overlapGroups = TreeMultimap.create(RegionSplitCalculator.BYTES_COMPARATOR, HbckRegionInfo.COMPARATOR);
    private ImmutableList<RegionInfo> regionsFromMeta = null;
    HBaseFsck hbck;

    HbckTableInfo(TableName name2, HBaseFsck hbck) {
        this.tableName = name2;
        this.hbck = hbck;
        this.deployedOn = new TreeSet();
    }

    TableDescriptor getTableDescriptor() {
        if (this.htds.size() == 1) {
            return (TableDescriptor)this.htds.toArray()[0];
        }
        LOG.error("None/Multiple table descriptors found for table '" + this.tableName + "' regions: " + this.htds);
        return null;
    }

    public void addRegionInfo(HbckRegionInfo hir) {
        if (Bytes.equals(hir.getEndKey(), HConstants.EMPTY_END_ROW)) {
            if (hir.getReplicaId() == 0) {
                this.sc.add(hir);
            }
            return;
        }
        if (Bytes.compareTo(hir.getStartKey(), hir.getEndKey()) > 0) {
            this.hbck.getErrors().reportError(HbckErrorReporter.ERROR_CODE.REGION_CYCLE, String.format("The endkey for this region comes before the startkey, startkey=%s, endkey=%s", Bytes.toStringBinary(hir.getStartKey()), Bytes.toStringBinary(hir.getEndKey())), this, hir);
            this.backwards.add(hir);
            return;
        }
        if (hir.getReplicaId() == 0) {
            this.sc.add(hir);
        }
    }

    public void addServer(ServerName server) {
        this.deployedOn.add(server);
    }

    public TableName getName() {
        return this.tableName;
    }

    public int getNumRegions() {
        return this.sc.getStarts().size() + this.backwards.size();
    }

    public synchronized ImmutableList<RegionInfo> getRegionsFromMeta(TreeMap<String, HbckRegionInfo> regionInfoMap) {
        if (this.regionsFromMeta == null) {
            ArrayList<HbckRegionInfo.MetaEntry> regions = new ArrayList<HbckRegionInfo.MetaEntry>();
            for (HbckRegionInfo h : regionInfoMap.values()) {
                if (!this.tableName.equals(h.getTableName()) || h.getMetaEntry() == null) continue;
                regions.add(h.getMetaEntry());
            }
            this.regionsFromMeta = Ordering.from(RegionInfo.COMPARATOR).immutableSortedCopy(regions);
        }
        return this.regionsFromMeta;
    }

    public boolean checkRegionChain(TableIntegrityErrorHandler handler) throws IOException {
        if (this.hbck.isTableDisabled(this.tableName)) {
            return true;
        }
        int originalErrorsCount = this.hbck.getErrors().getErrorList().size();
        Multimap<byte[], HbckRegionInfo> regions = this.sc.calcCoverage();
        TreeSet<byte[]> splits = this.sc.getSplits();
        byte[] prevKey = null;
        byte[] problemKey = null;
        if (splits.isEmpty()) {
            handler.handleHoleInRegionChain(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        }
        for (byte[] byArray : splits) {
            Collection<HbckRegionInfo> ranges = regions.get(byArray);
            if (prevKey == null && !Bytes.equals(byArray, HConstants.EMPTY_BYTE_ARRAY)) {
                for (HbckRegionInfo rng : ranges) {
                    handler.handleRegionStartKeyNotEmpty(rng);
                }
            }
            for (HbckRegionInfo rng : ranges) {
                byte[] endKey = rng.getEndKey();
                byte[] byArray2 = endKey = endKey.length == 0 ? null : endKey;
                if (!Bytes.equals(rng.getStartKey(), endKey)) continue;
                handler.handleDegenerateRegion(rng);
            }
            if (ranges.size() == 1) {
                if (problemKey != null) {
                    LOG.warn("reached end of problem group: " + Bytes.toStringBinary(byArray));
                }
                problemKey = null;
            } else if (ranges.size() > 1) {
                if (problemKey == null) {
                    LOG.warn("Naming new problem group: " + Bytes.toStringBinary(byArray));
                    problemKey = byArray;
                }
                this.overlapGroups.putAll(problemKey, ranges);
                ArrayList<HbckRegionInfo> subRange = new ArrayList<HbckRegionInfo>(ranges);
                for (HbckRegionInfo r1 : ranges) {
                    if (r1.getReplicaId() != 0) continue;
                    subRange.remove(r1);
                    for (HbckRegionInfo r2 : subRange) {
                        if (r2.getReplicaId() != 0) continue;
                        if (Bytes.compareTo(r1.getStartKey(), r2.getStartKey()) == 0) {
                            handler.handleDuplicateStartKeys(r1, r2);
                            continue;
                        }
                        if (Bytes.compareTo(r1.getEndKey(), r2.getStartKey()) == 0 && r1.getHdfsHRI().getRegionId() == r2.getHdfsHRI().getRegionId()) {
                            LOG.info("this is a split, log to splits");
                            handler.handleSplit(r1, r2);
                            continue;
                        }
                        handler.handleOverlapInRegionChain(r1, r2);
                    }
                }
            } else if (ranges.isEmpty()) {
                if (problemKey != null) {
                    LOG.warn("reached end of problem group: " + Bytes.toStringBinary(byArray));
                }
                problemKey = null;
                byte[] holeStopKey = this.sc.getSplits().higher(byArray);
                if (holeStopKey != null) {
                    handler.handleHoleInRegionChain(byArray, holeStopKey);
                }
            }
            prevKey = byArray;
        }
        if (prevKey != null) {
            handler.handleRegionEndKeyNotEmpty(prevKey);
        }
        if (this.hbck.getConf().getBoolean("hbasefsck.overlap.merge.parallel", true)) {
            boolean ok = this.handleOverlapsParallel(handler, prevKey);
            if (!ok) {
                return false;
            }
        } else {
            for (Collection collection : this.overlapGroups.asMap().values()) {
                handler.handleOverlapGroup(collection);
            }
        }
        if (HBaseFsck.shouldDisplayFullReport()) {
            this.hbck.getErrors().print("---- Table '" + this.tableName + "': region split map");
            this.dump(splits, regions);
            this.hbck.getErrors().print("---- Table '" + this.tableName + "': overlap groups");
            this.dumpOverlapProblems(this.overlapGroups);
            this.hbck.getErrors().print("There are " + this.overlapGroups.keySet().size() + " overlap groups with " + this.overlapGroups.size() + " overlapping regions");
        }
        if (!this.sidelinedRegions.isEmpty()) {
            LOG.warn("Sidelined big overlapped regions, please bulk load them!");
            this.hbck.getErrors().print("---- Table '" + this.tableName + "': sidelined big overlapped regions");
            this.dumpSidelinedRegions(this.sidelinedRegions);
        }
        return this.hbck.getErrors().getErrorList().size() == originalErrorsCount;
    }

    private boolean handleOverlapsParallel(TableIntegrityErrorHandler handler, byte[] prevKey) throws IOException {
        List rets;
        ArrayList<HBaseFsck.WorkItemOverlapMerge> merges = new ArrayList<HBaseFsck.WorkItemOverlapMerge>(this.overlapGroups.size());
        for (Collection<HbckRegionInfo> overlap : this.overlapGroups.asMap().values()) {
            merges.add(new HBaseFsck.WorkItemOverlapMerge(overlap, handler));
        }
        try {
            rets = this.hbck.executor.invokeAll(merges);
        }
        catch (InterruptedException e) {
            LOG.error("Overlap merges were interrupted", (Throwable)e);
            return false;
        }
        for (int i = 0; i < merges.size(); ++i) {
            HBaseFsck.WorkItemOverlapMerge work = (HBaseFsck.WorkItemOverlapMerge)merges.get(i);
            Future f = rets.get(i);
            try {
                f.get();
                continue;
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to merge overlap group" + work, e.getCause());
                continue;
            }
            catch (InterruptedException e) {
                LOG.error("Waiting for overlap merges was interrupted", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void dump(SortedSet<byte[]> splits, Multimap<byte[], HbckRegionInfo> regions) {
        StringBuilder sb = new StringBuilder();
        for (byte[] k : splits) {
            sb.setLength(0);
            sb.append(Bytes.toStringBinary(k) + ":\t");
            for (HbckRegionInfo r : regions.get(k)) {
                sb.append("[ " + r.toString() + ", " + Bytes.toStringBinary(r.getEndKey()) + "]\t");
            }
            this.hbck.getErrors().print(sb.toString());
        }
    }

    private void dumpOverlapProblems(Multimap<byte[], HbckRegionInfo> regions) {
        for (byte[] k : regions.keySet()) {
            this.hbck.getErrors().print(Bytes.toStringBinary(k) + ":");
            for (HbckRegionInfo r : regions.get(k)) {
                this.hbck.getErrors().print("[ " + r.toString() + ", " + Bytes.toStringBinary(r.getEndKey()) + "]");
            }
            this.hbck.getErrors().print("----");
        }
    }

    private void dumpSidelinedRegions(Map<Path, HbckRegionInfo> regions) {
        for (Map.Entry<Path, HbckRegionInfo> entry : regions.entrySet()) {
            TableName tableName = entry.getValue().getTableName();
            Path path = entry.getKey();
            this.hbck.getErrors().print("This sidelined region dir should be bulk loaded: " + path.toString());
            this.hbck.getErrors().print("Bulk load command looks like: completebulkload " + path.toUri().getPath() + " " + tableName);
        }
    }

    class HDFSIntegrityFixer
    extends IntegrityFixSuggester {
        Configuration conf;
        boolean fixOverlaps;

        HDFSIntegrityFixer(HbckTableInfo ti, HbckErrorReporter errors2, Configuration conf, boolean fixHoles, boolean fixOverlaps) {
            super(ti, errors2);
            this.fixOverlaps = true;
            this.conf = conf;
            this.fixOverlaps = fixOverlaps;
        }

        @Override
        public void handleRegionStartKeyNotEmpty(HbckRegionInfo next) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY, "First region should start with an empty key.  Creating a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo(), next);
            TableDescriptor htd = this.getTableInfo().getTableDescriptor();
            RegionInfo newRegion = RegionInfoBuilder.newBuilder(htd.getTableName()).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(next.getStartKey()).build();
            HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
            LOG.info("Table region start key was not empty.  Created new empty region: " + newRegion + " " + region);
            ++HbckTableInfo.this.hbck.fixes;
        }

        @Override
        public void handleRegionEndKeyNotEmpty(byte[] curEndKey) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.LAST_REGION_ENDKEY_NOT_EMPTY, "Last region should end with an empty key.  Creating a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo());
            TableDescriptor htd = this.getTableInfo().getTableDescriptor();
            RegionInfo newRegion = RegionInfoBuilder.newBuilder(htd.getTableName()).setStartKey(curEndKey).setEndKey(HConstants.EMPTY_START_ROW).build();
            HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
            LOG.info("Table region end key was not empty.  Created new empty region: " + newRegion + " " + region);
            ++HbckTableInfo.this.hbck.fixes;
        }

        @Override
        public void handleHoleInRegionChain(byte[] holeStartKey, byte[] holeStopKey) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN, "There is a hole in the region chain between " + Bytes.toStringBinary(holeStartKey) + " and " + Bytes.toStringBinary(holeStopKey) + ".  Creating a new regioninfo and region dir in hdfs to plug the hole.");
            TableDescriptor htd = this.getTableInfo().getTableDescriptor();
            RegionInfo newRegion = RegionInfoBuilder.newBuilder(htd.getTableName()).setStartKey(holeStartKey).setEndKey(holeStopKey).build();
            HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
            LOG.info("Plugged hole by creating new empty region: " + newRegion + " " + region);
            ++HbckTableInfo.this.hbck.fixes;
        }

        @Override
        public void handleOverlapGroup(Collection<HbckRegionInfo> overlap) throws IOException {
            Preconditions.checkNotNull(overlap);
            Preconditions.checkArgument(overlap.size() > 0);
            if (!this.fixOverlaps) {
                LOG.warn("Not attempting to repair overlaps.");
                return;
            }
            if (overlap.size() > HbckTableInfo.this.hbck.getMaxMerge()) {
                LOG.warn("Overlap group has " + overlap.size() + " overlapping regions which is greater than " + HbckTableInfo.this.hbck.getMaxMerge() + ", the max number of regions to merge");
                if (HbckTableInfo.this.hbck.shouldSidelineBigOverlaps()) {
                    this.sidelineBigOverlaps(overlap);
                }
                return;
            }
            if (HbckTableInfo.this.hbck.shouldRemoveParents()) {
                this.removeParentsAndFixSplits(overlap);
            }
            this.mergeOverlaps(overlap);
        }

        void removeParentsAndFixSplits(Collection<HbckRegionInfo> overlap) throws IOException {
            Pair<byte[], byte[]> range = null;
            HbckRegionInfo parent = null;
            HbckRegionInfo daughterA = null;
            HbckRegionInfo daughterB = null;
            ArrayList<HbckRegionInfo> daughters = new ArrayList<HbckRegionInfo>(overlap);
            String thread2 = Thread.currentThread().getName();
            LOG.info("== [" + thread2 + "] Attempting fix splits in overlap state.");
            if (overlap.size() > 3) {
                LOG.info("Too many overlaps were found on this group, falling back to regular merge.");
                return;
            }
            for (HbckRegionInfo hi : overlap) {
                if (range == null) {
                    range = new Pair<byte[], byte[]>(hi.getStartKey(), hi.getEndKey());
                    continue;
                }
                if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getStartKey(), (byte[])range.getFirst()) < 0) {
                    range.setFirst(hi.getStartKey());
                }
                if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getEndKey(), range.getSecond()) <= 0) continue;
                range.setSecond(hi.getEndKey());
            }
            LOG.info("This group range is [" + Bytes.toStringBinary((byte[])range.getFirst()) + ", " + Bytes.toStringBinary(range.getSecond()) + "]");
            for (HbckRegionInfo hi : overlap) {
                if (Bytes.compareTo(hi.getHdfsHRI().getStartKey(), range.getFirst()) != 0 || Bytes.compareTo(hi.getHdfsHRI().getEndKey(), range.getSecond()) != 0) continue;
                LOG.info("This is a parent for this group: " + hi.toString());
                parent = hi;
            }
            if (parent != null) {
                daughters.remove(parent);
            }
            for (HbckRegionInfo hi : daughters) {
                if (Bytes.compareTo(hi.getHdfsHRI().getStartKey(), range.getFirst()) == 0 && parent.getHdfsHRI().getRegionId() < hi.getHdfsHRI().getRegionId()) {
                    daughterA = hi;
                }
                if (Bytes.compareTo(hi.getHdfsHRI().getEndKey(), range.getSecond()) != 0 || parent.getHdfsHRI().getRegionId() >= hi.getHdfsHRI().getRegionId()) continue;
                daughterB = hi;
            }
            if (daughterA.getHdfsHRI().getRegionId() != daughterB.getHdfsHRI().getRegionId() || parent == null) {
                return;
            }
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            LOG.info("Found parent: " + parent.getRegionNameAsString());
            LOG.info("Found potential daughter a: " + daughterA.getRegionNameAsString());
            LOG.info("Found potential daughter b: " + daughterB.getRegionNameAsString());
            LOG.info("Trying to fix parent in overlap by removing the parent.");
            try {
                HbckTableInfo.this.hbck.closeRegion(parent);
            }
            catch (IOException ioe) {
                LOG.warn("Parent region could not be closed, continuing with regular merge...", (Throwable)ioe);
                return;
            }
            catch (InterruptedException ie) {
                LOG.warn("Parent region could not be closed, continuing with regular merge...", (Throwable)ie);
                return;
            }
            try {
                HbckTableInfo.this.hbck.offline(parent.getRegionName());
            }
            catch (IOException ioe) {
                LOG.warn("Unable to offline parent region: " + parent.getRegionNameAsString() + ".  Just continuing with regular merge... ", (Throwable)ioe);
                return;
            }
            try {
                HBaseFsckRepair.removeParentInMeta(this.conf, parent.getHdfsHRI());
            }
            catch (IOException ioe) {
                LOG.warn("Unable to remove parent region in META: " + parent.getRegionNameAsString() + ".  Just continuing with regular merge... ", (Throwable)ioe);
                return;
            }
            HbckTableInfo.this.hbck.sidelineRegionDir(fs, parent);
            LOG.info("[" + thread2 + "] Sidelined parent region dir " + parent.getHdfsRegionDir() + " into " + HbckTableInfo.this.hbck.getSidelineDir());
            HbckTableInfo.this.hbck.debugLsr(parent.getHdfsRegionDir());
            overlap.remove(parent);
            overlap.remove(daughterA);
            overlap.remove(daughterB);
            LOG.info("Done fixing split.");
        }

        void mergeOverlaps(Collection<HbckRegionInfo> overlap) throws IOException {
            String thread2 = Thread.currentThread().getName();
            LOG.info("== [" + thread2 + "] Merging regions into one region: " + Joiner.on(",").join(overlap));
            Pair<byte[], byte[]> range = null;
            for (HbckRegionInfo hi : overlap) {
                if (range == null) {
                    range = new Pair<byte[], byte[]>(hi.getStartKey(), hi.getEndKey());
                } else {
                    if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getStartKey(), (byte[])range.getFirst()) < 0) {
                        range.setFirst(hi.getStartKey());
                    }
                    if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getEndKey(), range.getSecond()) > 0) {
                        range.setSecond(hi.getEndKey());
                    }
                }
                LOG.debug("[" + thread2 + "] Closing region before moving data around: " + hi);
                LOG.debug("[" + thread2 + "] Contained region dir before close");
                HbckTableInfo.this.hbck.debugLsr(hi.getHdfsRegionDir());
                try {
                    LOG.info("[" + thread2 + "] Closing region: " + hi);
                    HbckTableInfo.this.hbck.closeRegion(hi);
                }
                catch (IOException ioe) {
                    LOG.warn("[" + thread2 + "] Was unable to close region " + hi + ".  Just continuing... ", (Throwable)ioe);
                }
                catch (InterruptedException e) {
                    LOG.warn("[" + thread2 + "] Was unable to close region " + hi + ".  Just continuing... ", (Throwable)e);
                }
                try {
                    LOG.info("[" + thread2 + "] Offlining region: " + hi);
                    HbckTableInfo.this.hbck.offline(hi.getRegionName());
                }
                catch (IOException ioe) {
                    LOG.warn("[" + thread2 + "] Unable to offline region from master: " + hi + ".  Just continuing... ", (Throwable)ioe);
                }
            }
            TableDescriptor htd = this.getTableInfo().getTableDescriptor();
            RegionInfo newRegion = RegionInfoBuilder.newBuilder(htd.getTableName()).setStartKey((byte[])range.getFirst()).setEndKey((byte[])range.getSecond()).build();
            HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
            LOG.info("[" + thread2 + "] Created new empty container region: " + newRegion + " to contain regions: " + Joiner.on(",").join(overlap));
            HbckTableInfo.this.hbck.debugLsr(region.getRegionFileSystem().getRegionDir());
            boolean didFix = false;
            Path target = region.getRegionFileSystem().getRegionDir();
            for (HbckRegionInfo contained : overlap) {
                LOG.info("[" + thread2 + "] Merging " + contained + " into " + target);
                int merges = HbckTableInfo.this.hbck.mergeRegionDirs(target, contained);
                if (merges <= 0) continue;
                didFix = true;
            }
            if (didFix) {
                ++HbckTableInfo.this.hbck.fixes;
            }
        }

        void sidelineBigOverlaps(Collection<HbckRegionInfo> bigOverlap) throws IOException {
            int overlapsToSideline = bigOverlap.size() - HbckTableInfo.this.hbck.getMaxMerge();
            if (overlapsToSideline > HbckTableInfo.this.hbck.getMaxOverlapsToSideline()) {
                overlapsToSideline = HbckTableInfo.this.hbck.getMaxOverlapsToSideline();
            }
            List<HbckRegionInfo> regionsToSideline = RegionSplitCalculator.findBigRanges(bigOverlap, overlapsToSideline);
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            for (HbckRegionInfo regionToSideline : regionsToSideline) {
                try {
                    LOG.info("Closing region: " + regionToSideline);
                    HbckTableInfo.this.hbck.closeRegion(regionToSideline);
                }
                catch (IOException ioe) {
                    LOG.warn("Was unable to close region " + regionToSideline + ".  Just continuing... ", (Throwable)ioe);
                }
                catch (InterruptedException e) {
                    LOG.warn("Was unable to close region " + regionToSideline + ".  Just continuing... ", (Throwable)e);
                }
                try {
                    LOG.info("Offlining region: " + regionToSideline);
                    HbckTableInfo.this.hbck.offline(regionToSideline.getRegionName());
                }
                catch (IOException ioe) {
                    LOG.warn("Unable to offline region from master: " + regionToSideline + ".  Just continuing... ", (Throwable)ioe);
                }
                LOG.info("Before sideline big overlapped region: " + regionToSideline.toString());
                Path sidelineRegionDir = HbckTableInfo.this.hbck.sidelineRegionDir(fs, HbckTableInfo.TO_BE_LOADED, regionToSideline);
                if (sidelineRegionDir == null) continue;
                HbckTableInfo.this.sidelinedRegions.put(sidelineRegionDir, regionToSideline);
                LOG.info("After sidelined big overlapped region: " + regionToSideline.getRegionNameAsString() + " to " + sidelineRegionDir.toString());
                ++HbckTableInfo.this.hbck.fixes;
            }
        }
    }

    class IntegrityFixSuggester
    extends TableIntegrityErrorHandlerImpl {
        HbckErrorReporter errors;

        IntegrityFixSuggester(HbckTableInfo ti, HbckErrorReporter errors2) {
            this.errors = errors2;
            this.setTableInfo(ti);
        }

        @Override
        public void handleRegionStartKeyNotEmpty(HbckRegionInfo hi) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY, "First region should start with an empty key.  You need to  create a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo(), hi);
        }

        @Override
        public void handleRegionEndKeyNotEmpty(byte[] curEndKey) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.LAST_REGION_ENDKEY_NOT_EMPTY, "Last region should end with an empty key. You need to create a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo());
        }

        @Override
        public void handleDegenerateRegion(HbckRegionInfo hi) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.DEGENERATE_REGION, "Region has the same start and end key.", this.getTableInfo(), hi);
        }

        @Override
        public void handleDuplicateStartKeys(HbckRegionInfo r1, HbckRegionInfo r2) throws IOException {
            byte[] key = r1.getStartKey();
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.DUPE_STARTKEYS, "Multiple regions have the same startkey: " + Bytes.toStringBinary(key), this.getTableInfo(), r1);
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.DUPE_STARTKEYS, "Multiple regions have the same startkey: " + Bytes.toStringBinary(key), this.getTableInfo(), r2);
        }

        @Override
        public void handleSplit(HbckRegionInfo r1, HbckRegionInfo r2) throws IOException {
            byte[] key = r1.getStartKey();
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.DUPE_ENDKEYS, "Multiple regions have the same regionID: " + Bytes.toStringBinary(key), this.getTableInfo(), r1);
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.DUPE_ENDKEYS, "Multiple regions have the same regionID: " + Bytes.toStringBinary(key), this.getTableInfo(), r2);
        }

        @Override
        public void handleOverlapInRegionChain(HbckRegionInfo hi1, HbckRegionInfo hi2) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN, "There is an overlap in the region chain.", this.getTableInfo(), hi1, hi2);
        }

        @Override
        public void handleHoleInRegionChain(byte[] holeStart, byte[] holeStop) throws IOException {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN, "There is a hole in the region chain between " + Bytes.toStringBinary(holeStart) + " and " + Bytes.toStringBinary(holeStop) + ".  You need to create a new .regioninfo and region dir in hdfs to plug the hole.");
        }
    }
}

