/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PoolMap<K, V> {
    private final Map<K, Pool<V>> pools = new HashMap<K, Pool<V>>();
    private final PoolType poolType;
    private final int poolMaxSize;

    public PoolMap(PoolType poolType, int poolMaxSize) {
        this.poolType = poolType;
        this.poolMaxSize = poolMaxSize;
    }

    public V getOrCreate(K key, PoolResourceSupplier<V> supplier) throws IOException {
        Map<K, Pool<V>> map2 = this.pools;
        synchronized (map2) {
            Pool<V> pool = this.pools.get(key);
            if (pool == null) {
                pool = this.createPool();
                this.pools.put(key, pool);
            }
            try {
                return pool.getOrCreate(supplier);
            }
            catch (IOException | Error | RuntimeException e) {
                if (pool.size() == 0) {
                    this.pools.remove(key);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V value) {
        Map<K, Pool<V>> map2 = this.pools;
        synchronized (map2) {
            Pool<V> pool = this.pools.get(key);
            if (pool == null) {
                return false;
            }
            boolean removed = pool.remove(value);
            if (removed && pool.size() == 0) {
                this.pools.remove(key);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> values() {
        ArrayList<V> values2 = new ArrayList<V>();
        Map<K, Pool<V>> map2 = this.pools;
        synchronized (map2) {
            for (Pool<V> pool : this.pools.values()) {
                Collection<V> poolValues = pool.values();
                if (poolValues == null) continue;
                values2.addAll(poolValues);
            }
        }
        return values2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, Pool<V>> map2 = this.pools;
        synchronized (map2) {
            for (Pool<V> pool : this.pools.values()) {
                pool.clear();
            }
            this.pools.clear();
        }
    }

    protected static <V> V createResource(PoolResourceSupplier<V> supplier) throws IOException {
        V resource = supplier.get();
        return Objects.requireNonNull(resource, "resource cannot be null.");
    }

    protected Pool<V> createPool() {
        switch (this.poolType) {
            case RoundRobin: {
                return new RoundRobinPool(this.poolMaxSize);
            }
            case ThreadLocal: {
                return new ThreadLocalPool();
            }
        }
        return new RoundRobinPool(this.poolMaxSize);
    }

    static class ThreadLocalPool<R>
    implements Pool<R> {
        private final Map<Thread, R> resources = new HashMap<Thread, R>();

        @Override
        public R getOrCreate(PoolResourceSupplier<R> supplier) throws IOException {
            Thread myself = Thread.currentThread();
            R resource = this.resources.get(myself);
            if (resource == null) {
                resource = PoolMap.createResource(supplier);
                this.resources.put(myself, resource);
            }
            return resource;
        }

        @Override
        public boolean remove(R resource) {
            return this.resources.values().remove(resource);
        }

        @Override
        public int size() {
            return this.resources.size();
        }

        @Override
        public void clear() {
            this.resources.clear();
        }

        @Override
        public Collection<R> values() {
            return this.resources.values();
        }
    }

    static class RoundRobinPool<R>
    implements Pool<R> {
        private final List<R> resources;
        private final int maxSize;
        private int nextIndex;

        public RoundRobinPool(int maxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("maxSize must be positive");
            }
            this.resources = new ArrayList<R>(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        public R getOrCreate(PoolResourceSupplier<R> supplier) throws IOException {
            R resource;
            int size = this.resources.size();
            if (size < this.maxSize) {
                resource = PoolMap.createResource(supplier);
                this.resources.add(resource);
            } else {
                resource = this.resources.get(this.nextIndex);
                this.nextIndex = (this.nextIndex + 1) % size;
            }
            return resource;
        }

        @Override
        public boolean remove(R resource) {
            return this.resources.remove(resource);
        }

        @Override
        public void clear() {
            this.resources.clear();
        }

        @Override
        public Collection<R> values() {
            return this.resources;
        }

        @Override
        public int size() {
            return this.resources.size();
        }
    }

    public static enum PoolType {
        ThreadLocal,
        RoundRobin;


        public static PoolType valueOf(String poolTypeName, PoolType defaultPoolType) {
            PoolType poolType = PoolType.fuzzyMatch(poolTypeName);
            return poolType != null ? poolType : defaultPoolType;
        }

        public static String fuzzyNormalize(String name2) {
            return name2 != null ? name2.replaceAll("-", "").trim().toLowerCase(Locale.ROOT) : "";
        }

        public static PoolType fuzzyMatch(String name2) {
            for (PoolType poolType : PoolType.values()) {
                if (!PoolType.fuzzyNormalize(name2).equals(PoolType.fuzzyNormalize(poolType.name()))) continue;
                return poolType;
            }
            return null;
        }
    }

    protected static interface Pool<R> {
        public R getOrCreate(PoolResourceSupplier<R> var1) throws IOException;

        public boolean remove(R var1);

        public void clear();

        public Collection<R> values();

        public int size();
    }

    public static interface PoolResourceSupplier<R> {
        public R get() throws IOException;
    }
}

