/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RollingStatCalculator {
    private double currentSum;
    private double currentSqrSum;
    private long numberOfDataValues;
    private int rollingPeriod;
    private int currentIndexPosition;
    private long[] dataValues;

    public RollingStatCalculator(int rollingPeriod) {
        this.rollingPeriod = rollingPeriod;
        this.dataValues = this.fillWithZeros(rollingPeriod);
        this.currentSum = 0.0;
        this.currentSqrSum = 0.0;
        this.currentIndexPosition = 0;
        this.numberOfDataValues = 0L;
    }

    public void insertDataValue(long data2) {
        if (this.numberOfDataValues >= (long)this.rollingPeriod && this.rollingPeriod > 0) {
            this.removeData(this.dataValues[this.currentIndexPosition]);
        }
        ++this.numberOfDataValues;
        this.currentSum += (double)data2;
        this.currentSqrSum += (double)data2 * (double)data2;
        if (this.rollingPeriod > 0) {
            this.dataValues[this.currentIndexPosition] = data2;
            this.currentIndexPosition = (this.currentIndexPosition + 1) % this.rollingPeriod;
        }
    }

    private void removeData(long data2) {
        this.currentSum -= (double)data2;
        this.currentSqrSum -= (double)data2 * (double)data2;
        --this.numberOfDataValues;
    }

    public double getMean() {
        return this.currentSum / (double)this.numberOfDataValues;
    }

    public double getDeviation() {
        double variance = (this.currentSqrSum - this.currentSum * this.currentSum / (double)this.numberOfDataValues) / (double)this.numberOfDataValues;
        return Math.sqrt(variance);
    }

    private long[] fillWithZeros(int size) {
        long[] zeros = new long[size];
        for (int i = 0; i < size; ++i) {
            zeros[i] = 0L;
        }
        return zeros;
    }
}

