/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.aws.transaction.lock.DynamoDBBasedLockProviderBase;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@NotThreadSafe
public class DynamoDBBasedImplicitPartitionKeyLockProvider
extends DynamoDBBasedLockProviderBase {
    protected static final Logger LOG = LoggerFactory.getLogger(DynamoDBBasedImplicitPartitionKeyLockProvider.class);
    private final String hudiTableBasePath;

    public DynamoDBBasedImplicitPartitionKeyLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf) {
        this(lockConfiguration, conf, null);
    }

    public DynamoDBBasedImplicitPartitionKeyLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf, DynamoDbClient dynamoDB) {
        super(lockConfiguration, conf, dynamoDB);
        this.hudiTableBasePath = FSUtils.s3aToS3(lockConfiguration.getConfig().getString(HoodieCommonConfig.BASE_PATH.key()));
    }

    @Override
    public String getDynamoDBPartitionKey(LockConfiguration lockConfiguration) {
        String hudiTableBasePathNormalized = FSUtils.s3aToS3(lockConfiguration.getConfig().getString(HoodieCommonConfig.BASE_PATH.key()));
        String partitionKey = HashID.generateXXHashAsString(hudiTableBasePathNormalized, HashID.Size.BITS_64);
        LOG.info(String.format("The DynamoDB partition key of the lock provider for the base path %s is %s", hudiTableBasePathNormalized, partitionKey));
        return partitionKey;
    }

    @Override
    protected String generateLogSuffixString() {
        return StringUtils.join("DynamoDb table = ", this.tableName, ", partition key = ", this.dynamoDBPartitionKey, ", hudi table base path = ", this.hudiTableBasePath);
    }
}

