/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import com.amazonaws.services.dynamodbv2.AcquireLockOptions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClientOptions;
import com.amazonaws.services.dynamodbv2.LockItem;
import com.amazonaws.services.dynamodbv2.model.LockNotGrantedException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.aws.credentials.HoodieAWSCredentialsProviderFactory;
import org.apache.hudi.aws.utils.DynamoTableUtils;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.DynamoDbBasedLockConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

@NotThreadSafe
public abstract class DynamoDBBasedLockProviderBase
implements LockProvider<LockItem> {
    protected static final Logger LOG = LoggerFactory.getLogger(DynamoDBBasedLockProviderBase.class);
    protected static final String DYNAMODB_ATTRIBUTE_NAME = "key";
    protected final DynamoDbBasedLockConfig dynamoDbBasedLockConfig;
    protected final AmazonDynamoDBLockClient client;
    protected final String tableName;
    protected final String dynamoDBPartitionKey;
    protected volatile LockItem lock;

    protected DynamoDBBasedLockProviderBase(LockConfiguration lockConfiguration, StorageConfiguration<?> conf, DynamoDbClient dynamoDB) {
        this.dynamoDbBasedLockConfig = new DynamoDbBasedLockConfig.Builder().fromProperties(lockConfiguration.getConfig()).build();
        this.tableName = this.dynamoDbBasedLockConfig.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME);
        long leaseDuration = this.dynamoDbBasedLockConfig.getInt(DynamoDbBasedLockConfig.LOCK_ACQUIRE_WAIT_TIMEOUT_MS_PROP_KEY).intValue();
        this.dynamoDBPartitionKey = this.getDynamoDBPartitionKey(lockConfiguration);
        if (dynamoDB == null) {
            dynamoDB = DynamoDBBasedLockProviderBase.getDynamoDBClient(this.dynamoDbBasedLockConfig);
        }
        this.client = new AmazonDynamoDBLockClient(AmazonDynamoDBLockClientOptions.builder((DynamoDbClient)dynamoDB, (String)this.tableName).withTimeUnit(TimeUnit.MILLISECONDS).withLeaseDuration(Long.valueOf(leaseDuration)).withHeartbeatPeriod(Long.valueOf(leaseDuration / 3L)).withCreateHeartbeatBackgroundThread(Boolean.valueOf(true)).build());
        if (!this.client.lockTableExists()) {
            this.createLockTableInDynamoDB(dynamoDB, this.tableName);
        }
    }

    public abstract String getDynamoDBPartitionKey(LockConfiguration var1);

    public String getPartitionKey() {
        return this.dynamoDBPartitionKey;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        LOG.info(this.generateLogStatement(LockState.ACQUIRING, this.generateLogSuffixString()));
        try {
            this.lock = this.client.acquireLock(AcquireLockOptions.builder((String)this.dynamoDBPartitionKey).withAdditionalTimeToWaitForLock(Long.valueOf(time)).withTimeUnit(TimeUnit.MILLISECONDS).build());
            LOG.info(this.generateLogStatement(LockState.ACQUIRED, this.generateLogSuffixString()));
        }
        catch (InterruptedException e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()), e);
        }
        catch (LockNotGrantedException e) {
            return false;
        }
        return this.lock != null && !this.lock.isExpired();
    }

    @Override
    public void unlock() {
        try {
            LOG.info(this.generateLogStatement(LockState.RELEASING, this.generateLogSuffixString()));
            if (this.lock == null) {
                return;
            }
            if (!this.client.releaseLock(this.lock)) {
                LOG.warn("The lock has already been stolen");
            }
            this.lock = null;
            LOG.info(this.generateLogStatement(LockState.RELEASED, this.generateLogSuffixString()));
        }
        catch (Exception e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()), e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.lock != null) {
                if (!this.client.releaseLock(this.lock)) {
                    LOG.warn("The lock has already been stolen");
                }
                this.lock = null;
            }
            this.client.close();
        }
        catch (Exception e) {
            LOG.error(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()));
        }
    }

    @Override
    public LockItem getLock() {
        return this.lock;
    }

    private static DynamoDbClient getDynamoDBClient(DynamoDbBasedLockConfig dynamoDbBasedLockConfig) {
        String endpointURL;
        String region = dynamoDbBasedLockConfig.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_REGION);
        String string = endpointURL = dynamoDbBasedLockConfig.contains(DynamoDbBasedLockConfig.DYNAMODB_ENDPOINT_URL.key()) ? dynamoDbBasedLockConfig.getString(DynamoDbBasedLockConfig.DYNAMODB_ENDPOINT_URL) : DynamoDbClient.serviceMetadata().endpointFor(Region.of((String)region)).toString();
        if (!endpointURL.startsWith("https://") && !endpointURL.startsWith("http://")) {
            endpointURL = "https://" + endpointURL;
        }
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().endpointOverride(URI.create(endpointURL))).credentialsProvider(HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider(dynamoDbBasedLockConfig.getProps()))).build();
    }

    private void createLockTableInDynamoDB(DynamoDbClient dynamoDB, String tableName) {
        String billingMode = this.dynamoDbBasedLockConfig.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_BILLING_MODE);
        KeySchemaElement partitionKeyElement = (KeySchemaElement)KeySchemaElement.builder().attributeName(DYNAMODB_ATTRIBUTE_NAME).keyType(KeyType.HASH).build();
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(partitionKeyElement);
        ArrayList<Object> attributeDefinitions = new ArrayList<Object>();
        attributeDefinitions.add(AttributeDefinition.builder().attributeName(DYNAMODB_ATTRIBUTE_NAME).attributeType(ScalarAttributeType.S).build());
        CreateTableRequest.Builder createTableRequestBuilder = CreateTableRequest.builder();
        if (billingMode.equals(BillingMode.PROVISIONED.name())) {
            createTableRequestBuilder.provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.dynamoDbBasedLockConfig.getLong(DynamoDbBasedLockConfig.DYNAMODB_LOCK_READ_CAPACITY)).writeCapacityUnits(this.dynamoDbBasedLockConfig.getLong(DynamoDbBasedLockConfig.DYNAMODB_LOCK_WRITE_CAPACITY)).build());
        }
        createTableRequestBuilder.tableName(tableName).keySchema(keySchema).attributeDefinitions(attributeDefinitions).billingMode(billingMode);
        dynamoDB.createTable((CreateTableRequest)createTableRequestBuilder.build());
        LOG.info("Creating dynamoDB table " + tableName + ", waiting for table to be active");
        try {
            DynamoTableUtils.waitUntilActive(dynamoDB, tableName, this.dynamoDbBasedLockConfig.getInt(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT), 20000);
        }
        catch (DynamoTableUtils.TableNeverTransitionedToStateException e) {
            throw new HoodieLockException("Created dynamoDB table never transits to active", (Throwable)((Object)e));
        }
        catch (InterruptedException e) {
            throw new HoodieLockException("Thread interrupted while waiting for dynamoDB table to turn active", e);
        }
        LOG.info("Created dynamoDB table " + tableName);
    }

    protected String generateLogSuffixString() {
        return StringUtils.join("DynamoDb table = ", this.tableName, ", partition key = ", this.dynamoDBPartitionKey);
    }

    protected String generateLogStatement(LockState state, String suffix) {
        return StringUtils.join(state.name(), " lock at ", suffix);
    }
}

