/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.clustering.plan.strategy.FlinkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringPlanActionExecutor;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkSizeBasedClusteringPlanStrategyRecently<T>
extends FlinkSizeBasedClusteringPlanStrategy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkSizeBasedClusteringPlanStrategy.class);

    public FlinkSizeBasedClusteringPlanStrategyRecently(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
        if (!table.getConfig().getTableType().equals((Object)HoodieTableType.COPY_ON_WRITE)) {
            throw new UnsupportedOperationException("FlinkSizeBasedClusteringPlanStrategyRecently only support cow table for now.");
        }
    }

    @Override
    public Option<HoodieClusteringPlan> generateClusteringPlan(ClusteringPlanActionExecutor executor, Lazy<List<String>> partitions) {
        if (!this.checkPrecondition()) {
            return Option.empty();
        }
        HoodieTableMetaClient metaClient = this.getHoodieTable().getMetaClient();
        LOG.info("Scheduling clustering for {}", (Object)metaClient.getBasePath());
        List<String> partitionPaths = this.getPartitionPathInActiveTimeline(this.hoodieTable);
        partitionPaths = this.filterPartitionPaths(this.getWriteConfig(), partitionPaths).getLeft();
        if (partitionPaths.isEmpty()) {
            return Option.empty();
        }
        List<HoodieClusteringGroup> clusteringGroups = this.getEngineContext().flatMap(partitionPaths, partitionPath -> {
            List<FileSlice> fileSlicesEligible = this.getFileSlicesEligibleForClustering((String)partitionPath).collect(Collectors.toList());
            return this.buildClusteringGroupsForPartition((String)partitionPath, fileSlicesEligible).getLeft().limit(this.getWriteConfig().getClusteringMaxNumGroups());
        }, partitionPaths.size()).stream().limit(this.getWriteConfig().getClusteringMaxNumGroups()).collect(Collectors.toList());
        if (clusteringGroups.isEmpty()) {
            LOG.info("No data available to cluster");
            return Option.empty();
        }
        HoodieClusteringStrategy strategy = HoodieClusteringStrategy.newBuilder().setStrategyClassName(this.getWriteConfig().getClusteringExecutionStrategyClass()).setStrategyParams(this.getStrategyParams()).build();
        return Option.of(HoodieClusteringPlan.newBuilder().setStrategy(strategy).setInputGroups(clusteringGroups).setExtraMetadata(this.getExtraMetadata()).setVersion(this.getPlanVersion()).setPreserveHoodieMetadata(true).build());
    }

    private List<String> getPartitionPathInActiveTimeline(HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> hoodieTable) {
        HashSet partitions = new HashSet();
        HoodieTimeline cowCommitTimeline = hoodieTable.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet("commit")).filterCompletedInstants();
        cowCommitTimeline.getInstants().forEach(instant -> {
            try {
                HoodieCommitMetadata metadata2 = cowCommitTimeline.readCommitMetadata((HoodieInstant)instant);
                partitions.addAll(metadata2.getWritePartitionPaths());
            }
            catch (IOException e) {
                LOG.warn("Exception while get instant details from commit metadata.", (Throwable)e);
            }
        });
        LOG.info("Partitions related to active timeline: " + partitions);
        return new ArrayList<String>(partitions);
    }
}

