/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.model;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.typeutils.StringDataSerializer;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.client.model.HoodieFlinkInternalRow;

public class HoodieFlinkInternalRowSerializer
extends TypeSerializer<HoodieFlinkInternalRow> {
    private static final long serialVersionUID = 1L;
    protected RowType rowType;
    protected RowDataSerializer rowDataSerializer;
    protected StringDataSerializer stringDataSerializer;

    public HoodieFlinkInternalRowSerializer(RowType rowType) {
        this.rowType = rowType;
        this.rowDataSerializer = new RowDataSerializer(rowType);
        this.stringDataSerializer = StringDataSerializer.INSTANCE;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<HoodieFlinkInternalRow> duplicate() {
        return new HoodieFlinkInternalRowSerializer(this.rowType);
    }

    @Override
    public HoodieFlinkInternalRow createInstance() {
        throw new UnsupportedOperationException("HoodieFlinkInternalRow doesn't allow creation with some defaults.");
    }

    @Override
    public HoodieFlinkInternalRow copy(HoodieFlinkInternalRow from) {
        return from.copy(this.rowDataSerializer);
    }

    @Override
    public HoodieFlinkInternalRow copy(HoodieFlinkInternalRow from, HoodieFlinkInternalRow reuse) {
        throw new UnsupportedOperationException("HoodieFlinkInternalRow doesn't allow reusing.");
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(HoodieFlinkInternalRow record, DataOutputView target) throws IOException {
        boolean isIndexRecord = record.isIndexRecord();
        target.writeBoolean(isIndexRecord);
        this.stringDataSerializer.serialize(StringData.fromString((String)record.getRecordKey()), target);
        this.stringDataSerializer.serialize(StringData.fromString((String)record.getPartitionPath()), target);
        this.stringDataSerializer.serialize(StringData.fromString((String)record.getFileId()), target);
        this.stringDataSerializer.serialize(StringData.fromString((String)record.getInstantTime()), target);
        this.stringDataSerializer.serialize(StringData.fromString((String)record.getOperationType()), target);
        if (!isIndexRecord) {
            this.rowDataSerializer.serialize(record.getRowData(), target);
        }
    }

    @Override
    public HoodieFlinkInternalRow deserialize(DataInputView source) throws IOException {
        HoodieFlinkInternalRow record;
        boolean isIndexRecord = source.readBoolean();
        StringData recordKey = this.stringDataSerializer.deserialize(source);
        StringData partition = this.stringDataSerializer.deserialize(source);
        StringData fileId = this.stringDataSerializer.deserialize(source);
        StringData instantTime = this.stringDataSerializer.deserialize(source);
        StringData operationType = this.stringDataSerializer.deserialize(source);
        if (!isIndexRecord) {
            RowData rowData = this.rowDataSerializer.deserialize(source);
            record = new HoodieFlinkInternalRow(recordKey.toString(), partition.toString(), fileId.toString(), instantTime.toString(), operationType.toString(), isIndexRecord, rowData);
        } else {
            record = new HoodieFlinkInternalRow(recordKey.toString(), partition.toString(), fileId.toString(), instantTime.toString());
        }
        return record;
    }

    @Override
    public HoodieFlinkInternalRow deserialize(HoodieFlinkInternalRow reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        boolean isIndexRecord = source.readBoolean();
        target.writeBoolean(isIndexRecord);
        this.stringDataSerializer.copy(source, target);
        this.stringDataSerializer.copy(source, target);
        this.stringDataSerializer.copy(source, target);
        this.stringDataSerializer.copy(source, target);
        this.stringDataSerializer.copy(source, target);
        if (!isIndexRecord) {
            this.rowDataSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        HoodieFlinkInternalRowSerializer that = (HoodieFlinkInternalRowSerializer)obj;
        return Objects.equals(this.rowDataSerializer, that.rowDataSerializer) && Objects.equals(this.stringDataSerializer, that.stringDataSerializer);
    }

    @Override
    public int hashCode() {
        return 31 * Objects.hashCode(this.rowDataSerializer) + Objects.hashCode(this.stringDataSerializer);
    }

    @Override
    public TypeSerializerSnapshot<HoodieFlinkInternalRow> snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }
}

