/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;

public class LazyConcatenatingIterator<T>
implements ClosableIterator<T> {
    private final Queue<Supplier<ClosableIterator<T>>> iteratorSuppliers;
    private ClosableIterator<T> itr;
    private boolean initialed = false;
    private boolean closed = false;

    public LazyConcatenatingIterator(List<Supplier<ClosableIterator<T>>> iteratorSuppliers) {
        this.iteratorSuppliers = new LinkedList<Supplier<ClosableIterator<T>>>(iteratorSuppliers);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.itr != null) {
                this.itr.close();
                this.itr = null;
            }
            this.iteratorSuppliers.clear();
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.init();
        while (this.itr != null) {
            if (this.itr.hasNext()) {
                return true;
            }
            this.itr.close();
            if (!this.iteratorSuppliers.isEmpty()) {
                this.itr = this.iteratorSuppliers.poll().get();
                continue;
            }
            this.itr = null;
        }
        return false;
    }

    @Override
    public T next() {
        ValidationUtils.checkState(this.hasNext(), "No more elements left");
        return (T)this.itr.next();
    }

    private void init() {
        if (!this.initialed) {
            if (!this.iteratorSuppliers.isEmpty()) {
                this.itr = this.iteratorSuppliers.poll().get();
            }
            this.initialed = true;
        }
    }
}

