/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class SizeAwareDataInputStream {
    private final DataInputStream dis;
    private final AtomicInteger numberOfBytesRead;

    public SizeAwareDataInputStream(DataInputStream dis) {
        this.dis = dis;
        this.numberOfBytesRead = new AtomicInteger(0);
    }

    public int readInt() throws IOException {
        int value = this.dis.readInt();
        this.numberOfBytesRead.addAndGet(4);
        return value;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dis.readFully(b, off, len);
        this.numberOfBytesRead.addAndGet(len);
    }

    public void readFully(byte[] b) throws IOException {
        this.dis.readFully(b);
        this.numberOfBytesRead.addAndGet(b.length);
    }

    public int skipBytes(int n) throws IOException {
        int numOfBytes = this.dis.skipBytes(n);
        this.numberOfBytesRead.addAndGet(numOfBytes);
        return numOfBytes;
    }

    public void close() throws IOException {
        this.dis.close();
    }

    public int getNumberOfBytesRead() {
        return this.numberOfBytesRead.get();
    }
}

