/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodiePartitionMetadata {
    public static final String HOODIE_PARTITION_METAFILE_PREFIX = ".hoodie_partition_metadata";
    private static final String PARTITION_DEPTH_KEY = "partitionDepth";
    private static final Logger LOG = LoggerFactory.getLogger(HoodiePartitionMetadata.class);
    private final Properties props;
    private final StoragePath partitionPath;
    private final HoodieStorage storage;
    private Option<HoodieFileFormat> format;

    public HoodiePartitionMetadata(HoodieStorage storage2, StoragePath partitionPath) {
        this.storage = storage2;
        this.props = new Properties();
        this.partitionPath = partitionPath;
        this.format = Option.empty();
    }

    public HoodiePartitionMetadata(HoodieStorage storage2, String instantTime, StoragePath basePath, StoragePath partitionPath, Option<HoodieFileFormat> format) {
        this(storage2, partitionPath);
        this.format = format;
        this.props.setProperty("commitTime", instantTime);
        this.props.setProperty(PARTITION_DEPTH_KEY, String.valueOf(partitionPath.depth() - basePath.depth()));
    }

    public int getPartitionDepth() {
        if (!this.props.containsKey(PARTITION_DEPTH_KEY)) {
            throw new HoodieException("Could not find partitionDepth in partition metafile");
        }
        return Integer.parseInt(this.props.getProperty(PARTITION_DEPTH_KEY));
    }

    public void trySave() throws HoodieIOException {
        StoragePath metaPath = new StoragePath(this.partitionPath, HOODIE_PARTITION_METAFILE_PREFIX + this.getMetafileExtension());
        RetryHelper retryHelper = new RetryHelper(1000L, 3, 1000L, HoodieIOException.class.getName()).tryWith(() -> {
            if (!this.storage.exists(metaPath)) {
                if (this.format.isPresent()) {
                    this.writeMetafileInFormat(metaPath, this.format.get());
                } else {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        this.props.store(os, "partition metadata");
                        Option<byte[]> content = Option.of(os.toByteArray());
                        this.storage.createImmutableFileInPath(metaPath, content.map(HoodieInstantWriter::convertByteArrayToWriter));
                    }
                }
            }
            return null;
        });
        retryHelper.start();
    }

    private String getMetafileExtension() {
        return this.format.isPresent() ? this.format.get().getFileExtension() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetafileInFormat(StoragePath filePath, HoodieFileFormat format) throws IOException {
        StoragePath tmpPath = new StoragePath(this.partitionPath, ".hoodie_partition_metadata_" + UUID.randomUUID() + this.getMetafileExtension());
        try {
            HoodieIOFactory.getIOFactory(this.storage).getFileFormatUtils(format).writeMetaFile(this.storage, tmpPath, this.props);
            this.storage.rename(tmpPath, filePath);
        }
        finally {
            try {
                if (this.storage.exists(tmpPath)) {
                    this.storage.deleteFile(tmpPath);
                }
            }
            catch (IOException ioe) {
                LOG.warn("Error trying to clean up temporary files for " + this.partitionPath, (Throwable)ioe);
            }
        }
    }

    public void readFromFS() throws IOException {
        boolean readFile = this.readTextFormatMetaFile();
        if (!readFile) {
            readFile = this.readBaseFormatMetaFile();
        }
        if (!readFile) {
            throw new HoodieException("Unable to read any partition meta file to locate the table timeline.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readTextFormatMetaFile() {
        StoragePath metafilePath = HoodiePartitionMetadata.textFormatMetaFilePath(this.partitionPath);
        try (InputStream is = this.storage.open(metafilePath);){
            this.props.load(is);
            this.format = Option.empty();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LOG.debug("Unable to read partition meta properties file for partition " + this.partitionPath);
            return false;
        }
    }

    private boolean readBaseFormatMetaFile() {
        for (StoragePath metafilePath : HoodiePartitionMetadata.baseFormatMetaFilePaths(this.partitionPath)) {
            try {
                FileFormatUtils reader = HoodieIOFactory.getIOFactory(this.storage).getFileFormatUtils(metafilePath);
                Map<String, String> metadata2 = reader.readFooter(this.storage, true, metafilePath, PARTITION_DEPTH_KEY, "commitTime");
                this.props.clear();
                this.props.putAll(metadata2);
                this.format = Option.of(reader.getFormat());
                return true;
            }
            catch (Throwable t) {
                LOG.debug("Unable to read partition metadata " + metafilePath.getName() + " for partition " + this.partitionPath);
            }
        }
        return false;
    }

    public Option<String> readPartitionCreatedCommitTime() {
        try {
            if (!this.props.containsKey("commitTime")) {
                this.readFromFS();
            }
            return Option.of(this.props.getProperty("commitTime"));
        }
        catch (IOException ioe) {
            LOG.warn("Error fetch Hoodie partition metadata for " + this.partitionPath, (Throwable)ioe);
            return Option.empty();
        }
    }

    public static boolean hasPartitionMetadata(HoodieStorage storage2, StoragePath partitionPath) {
        try {
            return HoodiePartitionMetadata.textFormatMetaPathIfExists(storage2, partitionPath).isPresent() || HoodiePartitionMetadata.baseFormatMetaPathIfExists(storage2, partitionPath).isPresent();
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error checking presence of partition meta file for " + partitionPath, ioe);
        }
    }

    public static Option<StoragePath> getPartitionMetafilePath(HoodieStorage storage2, StoragePath partitionPath) {
        try {
            Option<StoragePath> textFormatPath = HoodiePartitionMetadata.textFormatMetaPathIfExists(storage2, partitionPath);
            if (textFormatPath.isPresent()) {
                return textFormatPath;
            }
            return HoodiePartitionMetadata.baseFormatMetaPathIfExists(storage2, partitionPath);
        }
        catch (IOException ioe) {
            throw new HoodieException("Error checking Hoodie partition metadata for " + partitionPath, ioe);
        }
    }

    public static Option<StoragePath> baseFormatMetaPathIfExists(HoodieStorage storage2, StoragePath partitionPath) throws IOException {
        for (StoragePath metafilePath : HoodiePartitionMetadata.baseFormatMetaFilePaths(partitionPath)) {
            if (!storage2.exists(metafilePath)) continue;
            return Option.of(metafilePath);
        }
        return Option.empty();
    }

    public static Option<StoragePath> textFormatMetaPathIfExists(HoodieStorage storage2, StoragePath partitionPath) throws IOException {
        StoragePath path = HoodiePartitionMetadata.textFormatMetaFilePath(partitionPath);
        return Option.ofNullable(storage2.exists(path) ? path : null);
    }

    static StoragePath textFormatMetaFilePath(StoragePath partitionPath) {
        return new StoragePath(partitionPath, HOODIE_PARTITION_METAFILE_PREFIX);
    }

    static List<StoragePath> baseFormatMetaFilePaths(StoragePath partitionPath) {
        return Stream.of(HoodieFileFormat.PARQUET.getFileExtension(), HoodieFileFormat.ORC.getFileExtension()).map(ext -> new StoragePath(partitionPath, HOODIE_PARTITION_METAFILE_PREFIX + ext)).collect(Collectors.toList());
    }
}

