/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Locale;
import org.apache.hudi.common.config.EnumDescription;

@EnumDescription(value="Concurrency modes for write operations.")
public enum WriteConcurrencyMode {
    SINGLE_WRITER,
    OPTIMISTIC_CONCURRENCY_CONTROL,
    NON_BLOCKING_CONCURRENCY_CONTROL;


    public boolean supportsMultiWriter() {
        return this == OPTIMISTIC_CONCURRENCY_CONTROL || this == NON_BLOCKING_CONCURRENCY_CONTROL;
    }

    public static boolean supportsMultiWriter(String name2) {
        return WriteConcurrencyMode.valueOf(name2.toUpperCase(Locale.ROOT)).supportsMultiWriter();
    }

    public boolean isOptimisticConcurrencyControl() {
        return this == OPTIMISTIC_CONCURRENCY_CONTROL;
    }

    public boolean isNonBlockingConcurrencyControl() {
        return this == NON_BLOCKING_CONCURRENCY_CONTROL;
    }

    public static boolean isNonBlockingConcurrencyControl(String name2) {
        return WriteConcurrencyMode.valueOf(name2.toUpperCase()).isNonBlockingConcurrencyControl();
    }
}

