/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;

public class HoodieCDCLogRecordIterator
implements ClosableIterator<IndexedRecord> {
    private final HoodieStorage storage;
    private final Schema cdcSchema;
    private final Iterator<HoodieLogFile> cdcLogFileIter;
    private HoodieLogFormat.Reader reader;
    private ClosableIterator<IndexedRecord> itr;
    private IndexedRecord record;

    public HoodieCDCLogRecordIterator(HoodieStorage storage2, HoodieLogFile[] cdcLogFiles, Schema cdcSchema) {
        this.storage = storage2;
        this.cdcSchema = cdcSchema;
        this.cdcLogFileIter = Arrays.stream(cdcLogFiles).iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.record != null) {
            return true;
        }
        if (this.itr == null || !this.itr.hasNext()) {
            if (!(this.reader != null && this.reader.hasNext() || this.loadReader())) {
                return false;
            }
            if (!this.loadItr()) {
                return false;
            }
        }
        this.record = (IndexedRecord)this.itr.next();
        return true;
    }

    private boolean loadReader() {
        try {
            this.closeReader();
            if (this.cdcLogFileIter.hasNext()) {
                this.reader = new HoodieLogFileReader(this.storage, this.cdcLogFileIter.next(), this.cdcSchema, 0x1000000);
                return this.reader.hasNext();
            }
            return false;
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage());
        }
    }

    private boolean loadItr() {
        HoodieDataBlock dataBlock = (HoodieDataBlock)this.reader.next();
        this.closeItr();
        this.itr = new CloseableMappingIterator<Object, Object>(dataBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO), record -> (IndexedRecord)((HoodieAvroIndexedRecord)record).getData());
        return this.itr.hasNext();
    }

    @Override
    public IndexedRecord next() {
        IndexedRecord ret = this.record;
        this.record = null;
        return ret;
    }

    @Override
    public void close() {
        try {
            this.closeItr();
            this.closeReader();
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage());
        }
    }

    private void closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private void closeItr() {
        if (this.itr != null) {
            this.itr.close();
            this.itr = null;
        }
    }
}

