/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class PositionBasedSchemaHandler<T>
extends FileGroupReaderSchemaHandler<T> {
    public PositionBasedSchemaHandler(HoodieReaderContext<T> readerContext, Schema dataSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, HoodieTableConfig hoodieTableConfig, TypedProperties properties2) {
        super(readerContext, dataSchema, requestedSchema, internalSchemaOpt, hoodieTableConfig, properties2);
    }

    @Override
    protected Schema prepareRequiredSchema() {
        Schema preMergeSchema = super.prepareRequiredSchema();
        return this.readerContext.getShouldMergeUseRecordPosition() && this.readerContext.getHasLogFiles() ? PositionBasedSchemaHandler.addPositionalMergeCol(preMergeSchema) : preMergeSchema;
    }

    @Override
    protected Option<InternalSchema> getInternalSchemaOpt(Option<InternalSchema> internalSchemaOpt) {
        return internalSchemaOpt.map(PositionBasedSchemaHandler::addPositionalMergeCol);
    }

    @Override
    protected InternalSchema doPruneInternalSchema(Schema requiredSchema, InternalSchema internalSchema) {
        if (!this.readerContext.getShouldMergeUseRecordPosition() || !this.readerContext.getHasLogFiles()) {
            return super.doPruneInternalSchema(requiredSchema, internalSchema);
        }
        InternalSchema withRowIndex = PositionBasedSchemaHandler.addPositionalMergeCol(internalSchema);
        return super.doPruneInternalSchema(requiredSchema, withRowIndex);
    }

    private static InternalSchema addPositionalMergeCol(InternalSchema internalSchema) {
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(internalSchema);
        addChange.addColumns("", "_tmp_metadata_row_index", Types.LongType.get(), null);
        return SchemaChangeUtils.applyTableChanges2Schema(internalSchema, addChange);
    }

    @Override
    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapRequiredFields() {
        Pair<List<Schema.Field>, List<Schema.Field>> dataAndMetaCols = super.getBootstrapRequiredFields();
        if (this.readerContext.supportsParquetRowIndex() && !dataAndMetaCols.getLeft().isEmpty() && !dataAndMetaCols.getRight().isEmpty()) {
            dataAndMetaCols.getLeft().add(PositionBasedSchemaHandler.getPositionalMergeField());
            dataAndMetaCols.getRight().add(PositionBasedSchemaHandler.getPositionalMergeField());
        }
        return dataAndMetaCols;
    }

    private static Schema addPositionalMergeCol(Schema input) {
        return AvroSchemaUtils.appendFieldsToSchemaDedupNested(input, Collections.singletonList(PositionBasedSchemaHandler.getPositionalMergeField()));
    }

    private static Schema.Field getPositionalMergeField() {
        return new Schema.Field("_tmp_metadata_row_index", Schema.create((Schema.Type)Schema.Type.LONG), "", (Object)-1L);
    }
}

