/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.BaseTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantFileNameGeneratorV1;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveTimelineV1
extends BaseTimelineV1
implements HoodieActiveTimeline {
    public static final Set<String> VALID_EXTENSIONS_IN_ACTIVE_TIMELINE = new HashSet<String>(Arrays.asList(".commit", ".inflight", ".commit.requested", ".deltacommit", ".deltacommit.inflight", ".deltacommit.requested", ".savepoint", ".savepoint.inflight", ".clean", ".clean.requested", ".clean.inflight", INFLIGHT_COMPACTION_EXTENSION, REQUESTED_COMPACTION_EXTENSION, ".restore.requested", ".restore.inflight", ".restore", INFLIGHT_LOG_COMPACTION_EXTENSION, REQUESTED_LOG_COMPACTION_EXTENSION, ".rollback", ".rollback.requested", ".rollback.inflight", ".replacecommit.requested", ".replacecommit.inflight", ".replacecommit", ".indexing.requested", ".indexing.inflight", ".indexing", ".schemacommit.requested", ".schemacommit.inflight", ".schemacommit"));
    private static final Logger LOG = LoggerFactory.getLogger(ActiveTimelineV1.class);
    protected HoodieTableMetaClient metaClient;
    private final InstantFileNameGenerator instantFileNameGenerator = new InstantFileNameGeneratorV1();

    protected ActiveTimelineV1(HoodieTableMetaClient metaClient, Set<String> includedExtensions, boolean applyLayoutFilters) {
        try {
            this.setInstants(metaClient.scanHoodieInstantsFromFileSystem(metaClient.getTimelinePath(), includedExtensions, applyLayoutFilters));
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to scan metadata", e);
        }
        this.metaClient = metaClient;
        LOG.info("Loaded instants upto : " + this.lastInstant());
    }

    public ActiveTimelineV1(HoodieTableMetaClient metaClient) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), true);
    }

    public ActiveTimelineV1(HoodieTableMetaClient metaClient, boolean applyLayoutFilter) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), applyLayoutFilter);
    }

    @Deprecated
    public ActiveTimelineV1() {
    }

    @Deprecated
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public Set<String> getValidExtensionsInActiveTimeline() {
        return Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE);
    }

    @Override
    public void createCompleteInstant(HoodieInstant instant) {
        LOG.info("Creating a new complete instant " + instant);
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.empty(), false);
    }

    @Override
    public void createNewInstant(HoodieInstant instant) {
        LOG.info("Creating a new instant " + instant);
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.empty(), false);
    }

    @Override
    public void createRequestedCommitWithReplaceMetadata(String instantTime, String actionType) {
        HoodieInstant instant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, actionType, instantTime);
        LOG.info("Creating a new instant " + instant);
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of(new HoodieRequestedReplaceMetadata()), false);
    }

    @Override
    public <T> void saveAsComplete(HoodieInstant instant, Option<T> metadata2) {
        LOG.info("Marking instant complete " + instant);
        ValidationUtils.checkArgument(instant.isInflight(), "Could not mark an already completed instant as complete again " + instant);
        this.transitionState(instant, this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, instant.getAction(), instant.requestedTime()), metadata2);
        LOG.info("Completed " + instant);
    }

    @Override
    public <T> void saveAsComplete(boolean shouldLock, HoodieInstant instant, Option<T> metadata2) {
        this.saveAsComplete(instant, metadata2);
    }

    @Override
    public HoodieInstant revertToInflight(HoodieInstant instant) {
        LOG.info("Reverting instant to inflight " + instant);
        HoodieInstant inflight = TimelineUtils.getInflightInstant(instant, this.metaClient);
        this.revertCompleteToInflight(instant, inflight);
        LOG.info("Reverted " + instant + " to inflight " + inflight);
        return inflight;
    }

    @Override
    public void deleteInflight(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isInflight());
        this.deleteInstantFile(instant);
    }

    @Override
    public void deletePending(HoodieInstant instant) {
        ValidationUtils.checkArgument(!instant.isCompleted());
        this.deleteInstantFile(instant);
    }

    @Override
    public void deleteCompletedRollback(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isCompleted());
        this.deleteInstantFile(instant);
    }

    @Override
    public void deleteEmptyInstantIfExists(HoodieInstant instant) {
        ValidationUtils.checkArgument(this.isEmpty(instant));
        this.deleteInstantFileIfExists(instant);
    }

    @Override
    public void deleteCompactionRequested(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isRequested());
        ValidationUtils.checkArgument(Objects.equals(instant.getAction(), "compaction"));
        this.deleteInstantFile(instant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteInstantFileIfExists(HoodieInstant instant) {
        LOG.info("Deleting instant " + instant);
        StoragePath commitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        try {
            if (this.metaClient.getStorage().exists(commitFilePath)) {
                boolean result2 = this.metaClient.getStorage().deleteFile(commitFilePath);
                if (!result2) throw new HoodieIOException("Could not delete instant " + instant + " with path " + commitFilePath);
                LOG.info("Removed instant " + instant);
                return;
            } else {
                LOG.warn("The commit " + commitFilePath + " to remove does not exist");
            }
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove commit " + commitFilePath, e);
        }
    }

    private void deleteInstantFile(HoodieInstant instant) {
        LOG.info("Deleting instant " + instant);
        StoragePath inFlightCommitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        try {
            boolean result2 = this.metaClient.getStorage().deleteFile(inFlightCommitFilePath);
            if (!result2) {
                throw new HoodieIOException("Could not delete instant " + instant + " with path " + inFlightCommitFilePath);
            }
            LOG.info("Removed instant " + instant);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove inflight commit " + inFlightCommitFilePath, e);
        }
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        StoragePath detailPath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        return this.readDataFromPath(detailPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Option<byte[]> readDataFromPath(StoragePath filePath) {
        try (InputStream inputStream = this.readDataStreamFromPath(filePath);){
            Option<byte[]> option = Option.of(FileIOUtils.readAsByteArray(inputStream));
            return option;
        }
        catch (IOException ex) {
            throw new HoodieIOException("Could not read commit details from " + filePath, ex);
        }
    }

    @Override
    public InputStream getContentStream(HoodieInstant instant) {
        StoragePath filePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        return this.readDataStreamFromPath(filePath);
    }

    @Override
    public HoodieInstantReader getInstantReader() {
        return this;
    }

    @Override
    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidSchema() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> WriteOperationType.canUpdateSchema(((HoodieCommitMetadata)instantCommitMetadataPair.getRight()).getOperationType()) && !StringUtils.isNullOrEmpty(((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getMetadata("schema"))).findFirst());
    }

    @Override
    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidData() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> !((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getFileIdAndRelativePaths().isEmpty()).findFirst());
    }

    private Stream<Pair<HoodieInstant, HoodieCommitMetadata>> getCommitMetadataStream() {
        return this.getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().sorted(Comparator.comparing(HoodieInstant::requestedTime).reversed()).map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = this.readCommitMetadata((HoodieInstant)instant);
                return Pair.of(instant, commitMetadata);
            }
            catch (IOException e) {
                throw new HoodieIOException(String.format("Failed to fetch HoodieCommitMetadata for instant (%s)", instant), e);
            }
        });
    }

    @Override
    public Option<byte[]> readCleanerInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant)));
    }

    @Override
    public Option<byte[]> readCompactionPlanAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(new StoragePath(this.metaClient.getTimelinePath(), this.instantFileNameGenerator.getFileName(instant)));
    }

    @Override
    public HoodieInstant revertInstantFromInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant requestedInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, inflightInstant.getAction(), inflightInstant.requestedTime());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    @Override
    public HoodieInstant revertLogCompactionInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant requestedInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "logcompaction", inflightInstant.requestedTime());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    @Override
    public HoodieInstant transitionCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionLogCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "logcompaction", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionCompactionInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieCommitMetadata metadata2) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, Option.of(metadata2));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionLogCompactionInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieCommitMetadata metadata2) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, Option.of(metadata2));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionCleanInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<HoodieCleanMetadata> metadata2) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "clean", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, metadata2);
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionCleanRequestedToInflight(HoodieInstant requestedInstant, Option<HoodieCleanerPlan> metadata2) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "clean", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflight, metadata2);
        return inflight;
    }

    @Override
    public HoodieInstant transitionRollbackInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieRollbackMetadata metadata2) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "rollback", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, Option.of(metadata2));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionRollbackRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "rollback", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    @Override
    public HoodieInstant transitionRestoreRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("restore"), "Transition to inflight requested for a restore instant with diff action " + requestedInstant);
        ValidationUtils.checkArgument(requestedInstant.isRequested(), "Transition to inflight requested for an instant not in requested state " + requestedInstant);
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "restore", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    @Override
    public <T> HoodieInstant transitionReplaceRequestedToInflight(HoodieInstant requestedInstant, Option<T> metadata2) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, metadata2);
        return inflightInstant;
    }

    @Override
    public <T> HoodieInstant transitionClusterRequestedToInflight(HoodieInstant requestedInstant, Option<T> metadata2) {
        return this.transitionReplaceRequestedToInflight(requestedInstant, metadata2);
    }

    @Override
    public HoodieInstant transitionReplaceInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieReplaceCommitMetadata metadata2) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, Option.of(metadata2));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionClusterInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieReplaceCommitMetadata metadata2) {
        return this.transitionReplaceInflightToComplete(shouldLock, inflightInstant, metadata2);
    }

    private <T> void transitionState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<T> metadata2) {
        this.transitionState(fromInstant, toInstant, metadata2, false);
    }

    protected <T> void transitionState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<T> metadata2, boolean allowRedundantTransitions) {
        ValidationUtils.checkArgument(fromInstant.requestedTime().equals(toInstant.requestedTime()), String.format("%s and %s are not consistent when transition state.", fromInstant, toInstant));
        try {
            HoodieStorage storage2 = this.metaClient.getStorage();
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(fromInstant), metadata2, allowRedundantTransitions);
                StoragePath fromInstantPath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(fromInstant));
                StoragePath toInstantPath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant));
                boolean success = storage2.rename(fromInstantPath, toInstantPath);
                if (!success) {
                    throw new HoodieIOException("Could not rename " + fromInstantPath + " to " + toInstantPath);
                }
            } else {
                ValidationUtils.checkArgument(storage2.exists(this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(fromInstant))), "File " + this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(fromInstant)) + " does not exist!");
                if (allowRedundantTransitions) {
                    FileIOUtils.createFileInPath(storage2, this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant)), TimelineUtils.getHoodieInstantWriterOption(this, metadata2));
                } else {
                    storage2.createImmutableFileInPath(this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant)), TimelineUtils.getHoodieInstantWriterOption(this, metadata2));
                }
                LOG.info("Create new file for toInstant ?" + this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant)));
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete " + fromInstant, e);
        }
    }

    protected void revertCompleteToInflight(HoodieInstant completed, HoodieInstant inflight) {
        ValidationUtils.checkArgument(completed.requestedTime().equals(inflight.requestedTime()));
        StoragePath inFlightCommitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(inflight));
        StoragePath commitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(completed));
        try {
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                boolean success;
                if (!this.metaClient.getStorage().exists(inFlightCommitFilePath) && !(success = this.metaClient.getStorage().rename(commitFilePath, inFlightCommitFilePath))) {
                    throw new HoodieIOException("Could not rename " + commitFilePath + " to " + inFlightCommitFilePath);
                }
            } else {
                StoragePath requestedInstantFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.requestedTime())));
                if (!this.metaClient.getStorage().exists(requestedInstantFilePath)) {
                    this.metaClient.getStorage().create(requestedInstantFilePath, false).close();
                }
                if (!this.metaClient.getStorage().exists(inFlightCommitFilePath)) {
                    this.metaClient.getStorage().create(inFlightCommitFilePath, false).close();
                }
                boolean success = this.metaClient.getStorage().deleteFile(commitFilePath);
                ValidationUtils.checkArgument(success, "State Reverting failed");
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete revert " + completed, e);
        }
    }

    private StoragePath getInstantFileNamePath(String fileName) {
        return new StoragePath(fileName.contains("schemacommit") ? this.metaClient.getSchemaFolderName() : this.metaClient.getTimelinePath().toString(), fileName);
    }

    @Override
    public void transitionRequestedToInflight(String commitType, String inFlightInstant) {
        HoodieInstant requested = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, commitType, inFlightInstant);
        this.transitionRequestedToInflight(requested, Option.empty(), false);
    }

    @Override
    public <T> void transitionRequestedToInflight(HoodieInstant requested, Option<T> metadata2) {
        this.transitionRequestedToInflight(requested, metadata2, false);
    }

    @Override
    public <T> void transitionRequestedToInflight(HoodieInstant requested, Option<T> metadata2, boolean allowRedundantTransitions) {
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, requested.getAction(), requested.requestedTime());
        ValidationUtils.checkArgument(requested.isRequested(), "Instant " + requested + " in wrong state");
        this.transitionState(requested, inflight, metadata2, allowRedundantTransitions);
    }

    @Override
    public void saveToCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata2) {
        this.saveToCompactionRequested(instant, metadata2, false);
    }

    @Override
    public void saveToCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata2, boolean overwrite) {
        ValidationUtils.checkArgument(instant.getAction().equals("compaction"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of(metadata2), overwrite);
    }

    @Override
    public void saveToLogCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata2) {
        this.saveToLogCompactionRequested(instant, metadata2, false);
    }

    @Override
    public void saveToLogCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata2, boolean overwrite) {
        ValidationUtils.checkArgument(instant.getAction().equals("logcompaction"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of(metadata2), overwrite);
    }

    @Override
    public void saveToPendingReplaceCommit(HoodieInstant instant, HoodieRequestedReplaceMetadata metadata2) {
        ValidationUtils.checkArgument(instant.getAction().equals("replacecommit"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of(metadata2), false);
    }

    @Override
    public void saveToPendingClusterCommit(HoodieInstant instant, HoodieRequestedReplaceMetadata metadata2) {
        this.saveToPendingReplaceCommit(instant, metadata2);
    }

    @Override
    public void saveToCleanRequested(HoodieInstant instant, Option<HoodieCleanerPlan> metadata2) {
        ValidationUtils.checkArgument(instant.getAction().equals("clean"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), metadata2, false);
    }

    @Override
    public void saveToRollbackRequested(HoodieInstant instant, HoodieRollbackPlan metadata2) {
        ValidationUtils.checkArgument(instant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of(metadata2), false);
    }

    @Override
    public void saveToRestoreRequested(HoodieInstant instant, HoodieRestorePlan metadata2) {
        ValidationUtils.checkArgument(instant.getAction().equals("restore"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of(metadata2), false);
    }

    @Override
    public HoodieInstant transitionIndexRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("indexing"), String.format("%s is not equal to %s action", requestedInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument(requestedInstant.isRequested(), String.format("Instant %s not in requested state", requestedInstant.requestedTime()));
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "indexing", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public void saveToPendingIndexAction(HoodieInstant instant, HoodieIndexPlan metadata2) {
        ValidationUtils.checkArgument(instant.getAction().equals("indexing"), String.format("%s is not equal to %s action", instant.getAction(), "indexing"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of(metadata2), false);
    }

    public <T> void createFileInMetaPath(String filename, Option<T> metadata2, boolean allowOverwrite) {
        StoragePath fullPath = this.getInstantFileNamePath(filename);
        Option<HoodieInstantWriter> writerOption = TimelineUtils.getHoodieInstantWriterOption(this, metadata2);
        if (allowOverwrite || this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            FileIOUtils.createFileInPath(this.metaClient.getStorage(this.metaClient.getTimelinePath()), fullPath, writerOption);
        } else {
            this.metaClient.getStorage(this.metaClient.getTimelinePath()).createImmutableFileInPath(fullPath, writerOption);
        }
    }

    protected InputStream readDataStreamFromPath(StoragePath filePath) {
        try {
            return this.metaClient.getStorage().open(filePath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read commit details from " + filePath, e);
        }
    }

    @Override
    public HoodieActiveTimeline reload() {
        return new ActiveTimelineV1(this.metaClient);
    }

    @Override
    public void copyInstant(HoodieInstant instant, StoragePath dstDir) {
        StoragePath srcPath = new StoragePath(this.metaClient.getTimelinePath(), this.instantFileNameGenerator.getFileName(instant));
        StoragePath dstPath = new StoragePath(dstDir, this.instantFileNameGenerator.getFileName(instant));
        try {
            HoodieStorage storage2 = this.metaClient.getStorage();
            storage2.createDirectory(dstDir);
            FileIOUtils.copy(storage2, srcPath, storage2, dstPath, false, true);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not copy instant from " + srcPath + " to " + dstPath, e);
        }
    }

    @Override
    public Set<String> getValidExtensions() {
        return Collections.emptySet();
    }

    @Override
    public boolean isEmpty(HoodieInstant instant) {
        return TimelineUtils.isEmpty(this.metaClient, instant);
    }
}

