/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieHBaseKVComparator;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileUtils
extends FileFormatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HFileUtils.class);
    private static final int DEFAULT_BLOCK_SIZE_FOR_LOG_FILE = 0x100000;

    public static Compression.Algorithm getHFileCompressionAlgorithm(Map<String, String> paramsMap) {
        String algoName = paramsMap.get(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.key());
        if (StringUtils.isNullOrEmpty(algoName)) {
            return Compression.Algorithm.GZ;
        }
        return Compression.Algorithm.valueOf(algoName.toUpperCase());
    }

    @Override
    public List<GenericRecord> readAvroRecords(HoodieStorage storage2, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support readAvroRecords");
    }

    @Override
    public List<GenericRecord> readAvroRecords(HoodieStorage storage2, StoragePath filePath, Schema schema) {
        throw new UnsupportedOperationException("HFileUtils does not support readAvroRecords");
    }

    @Override
    public Map<String, String> readFooter(HoodieStorage storage2, boolean required, StoragePath filePath, String ... footerNames) {
        throw new UnsupportedOperationException("HFileUtils does not support readFooter");
    }

    @Override
    public long getRowCount(HoodieStorage storage2, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support getRowCount");
    }

    @Override
    public Set<Pair<String, Long>> filterRowKeys(HoodieStorage storage2, StoragePath filePath, Set<String> filter) {
        throw new UnsupportedOperationException("HFileUtils does not support filterRowKeys");
    }

    @Override
    public ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage2, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support fetchRecordKeysWithPositions");
    }

    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage2, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt, Option<String> partitionPath) {
        throw new UnsupportedOperationException("HFileUtils does not support getHoodieKeyIterator");
    }

    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage2, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support getHoodieKeyIterator");
    }

    @Override
    public ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage2, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt, Option<String> partitionPath) {
        throw new UnsupportedOperationException("HFileUtils does not support fetchRecordKeysWithPositions");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Schema readAvroSchema(HoodieStorage storage2, StoragePath filePath) {
        LOG.info("Reading schema from {}", (Object)filePath);
        try (HoodieFileReader fileReader = HoodieIOFactory.getIOFactory(storage2).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, filePath);){
            Schema schema = fileReader.getSchema();
            return schema;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read schema from HFile", e);
        }
    }

    @Override
    public List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage storage2, StoragePath filePath, List<String> columnList) {
        throw new UnsupportedOperationException("Reading column statistics from metadata is not supported for HFile format yet");
    }

    @Override
    public HoodieFileFormat getFormat() {
        return HoodieFileFormat.HFILE;
    }

    @Override
    public void writeMetaFile(HoodieStorage storage2, StoragePath filePath, Properties props) throws IOException {
        throw new UnsupportedOperationException("HFileUtils does not support writeMetaFile");
    }

    @Override
    public ByteArrayOutputStream serializeRecordsToLogBlock(HoodieStorage storage2, List<HoodieRecord> records, Schema writerSchema, Schema readerSchema, String keyFieldName, Map<String, String> paramsMap) throws IOException {
        Compression.Algorithm compressionAlgorithm = HFileUtils.getHFileCompressionAlgorithm(paramsMap);
        HFileContext context = new HFileContextBuilder().withBlockSize(0x100000).withCompression(compressionAlgorithm).withCellComparator(new HoodieHBaseKVComparator()).build();
        Configuration conf = storage2.getConf().unwrapAs(Configuration.class);
        CacheConfig cacheConfig = new CacheConfig(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FSDataOutputStream ostream = new FSDataOutputStream((OutputStream)baos, null);
        boolean useIntegerKey = !HFileUtils.getRecordKey(records.get(0), readerSchema, keyFieldName).isPresent();
        int keyWidth = useIntegerKey ? (int)Math.ceil(Math.log(records.size())) + 1 : -1;
        TreeMap<String, byte[]> sortedRecordsMap = new TreeMap<String, byte[]>();
        Iterator<HoodieRecord> itr = records.iterator();
        int id = 0;
        while (itr.hasNext()) {
            HoodieRecord record = itr.next();
            String recordKey2 = useIntegerKey ? String.format("%" + keyWidth + "s", id++) : HFileUtils.getRecordKey(record, readerSchema, keyFieldName).get();
            byte[] recordBytes2 = HFileUtils.serializeRecord(record, writerSchema, keyFieldName);
            if (sortedRecordsMap.containsKey(recordKey2)) {
                LOG.error("Found duplicate record with recordKey: {} ", (Object)recordKey2);
                this.logRecordMetadata("Previous record", (byte[])sortedRecordsMap.get(recordKey2), writerSchema);
                this.logRecordMetadata("Current record", recordBytes2, writerSchema);
                throw new HoodieException(String.format("Writing multiple records with same key %s not supported for Hfile format with Metadata table", recordKey2));
            }
            sortedRecordsMap.put(recordKey2, recordBytes2);
        }
        HFile.Writer writer = HFile.getWriterFactory(conf, cacheConfig).withOutputStream(ostream).withFileContext(context).create();
        sortedRecordsMap.forEach((recordKey, recordBytes) -> {
            try {
                KeyValue kv = new KeyValue(recordKey.getBytes(), null, null, (byte[])recordBytes);
                writer.append(kv);
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException serializing records", e);
            }
        });
        writer.appendFileInfo(StringUtils.getUTF8Bytes("schema"), StringUtils.getUTF8Bytes(readerSchema.toString()));
        writer.close();
        ostream.flush();
        ostream.close();
        return baos;
    }

    private void logRecordMetadata(String msg, byte[] bs, Schema schema) throws IOException {
        GenericRecord record = HoodieAvroUtils.bytesToAvro(bs, schema);
        if (schema.getField(HoodieRecord.RECORD_KEY_METADATA_FIELD) != null) {
            LOG.error("{}: Hudi meta field values -> Record key: {}, Partition Path: {}, FileName: {}, CommitTime: {}, CommitSeqNo: {}", new Object[]{msg, record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD), record.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD), record.get(HoodieRecord.FILENAME_METADATA_FIELD), record.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD), record.get(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD)});
        }
    }

    private static Option<String> getRecordKey(HoodieRecord record, Schema readerSchema, String keyFieldName) {
        return Option.ofNullable(record.getRecordKey(readerSchema, keyFieldName));
    }

    private static byte[] serializeRecord(HoodieRecord<?> record, Schema schema, String keyFieldName) throws IOException {
        Option<Schema.Field> keyField = Option.ofNullable(schema.getField(keyFieldName));
        if (keyField.isPresent()) {
            record.truncateRecordKey(schema, new Properties(), keyField.get().name());
        }
        return HoodieAvroUtils.recordToBytes(record, schema).get();
    }
}

