/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Map;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;

@ConfigClassProperty(name="DynamoDB based Locks Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, subGroupName=ConfigGroups.SubGroupNames.LOCK, description="Configs that control DynamoDB based locking mechanisms required for concurrency control  between writers to a Hudi table. Concurrency between Hudi's own table services  are auto managed internally.")
public class DynamoDbBasedLockConfig
extends HoodieConfig {
    public static final String DYNAMODB_BASED_LOCK_PROPERTY_PREFIX = "hoodie.write.lock.dynamodb.";
    public static final ConfigProperty<String> DYNAMODB_LOCK_TABLE_NAME = ConfigProperty.key("hoodie.write.lock.dynamodb.table").defaultValue("hudi_locks").markAdvanced().sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, the name of the DynamoDB table acting as lock table");
    public static final ConfigProperty<String> DYNAMODB_LOCK_PARTITION_KEY = ConfigProperty.key("hoodie.write.lock.dynamodb.partition_key").noDefaultValue().markAdvanced().sinceVersion("0.10.0").withInferFunction(cfg -> {
        if (cfg.contains(HoodieTableConfig.NAME)) {
            return Option.of(cfg.getString(HoodieTableConfig.NAME));
        }
        return Option.empty();
    }).withDocumentation("For DynamoDB based lock provider, the partition key for the DynamoDB lock table. Each Hudi dataset should has it's unique key so concurrent writers could refer to the same partition key. By default we use the Hudi table name specified to be the partition key");
    public static final ConfigProperty<String> DYNAMODB_LOCK_REGION = ConfigProperty.key("hoodie.write.lock.dynamodb.region").defaultValue("us-east-1").markAdvanced().sinceVersion("0.10.0").withInferFunction(cfg -> {
        String regionFromEnv = System.getenv("AWS_REGION");
        if (regionFromEnv != null) {
            return Option.of(RegionMetadata.of((Region)Region.of((String)regionFromEnv)).id());
        }
        return Option.empty();
    }).withDocumentation("For DynamoDB based lock provider, the region used in endpoint for Amazon DynamoDB service. Would try to first get it from AWS_REGION environment variable. If not find, by default use us-east-1");
    public static final ConfigProperty<String> DYNAMODB_LOCK_BILLING_MODE = ConfigProperty.key("hoodie.write.lock.dynamodb.billing_mode").defaultValue(BillingMode.PAY_PER_REQUEST.name()).markAdvanced().sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, by default it is `PAY_PER_REQUEST` mode. Alternative is `PROVISIONED`.");
    public static final ConfigProperty<String> DYNAMODB_LOCK_READ_CAPACITY = ConfigProperty.key("hoodie.write.lock.dynamodb.read_capacity").defaultValue("20").markAdvanced().sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, read capacity units when using PROVISIONED billing mode");
    public static final ConfigProperty<String> DYNAMODB_LOCK_WRITE_CAPACITY = ConfigProperty.key("hoodie.write.lock.dynamodb.write_capacity").defaultValue("10").markAdvanced().sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, write capacity units when using PROVISIONED billing mode");
    public static final ConfigProperty<String> DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT = ConfigProperty.key("hoodie.write.lock.dynamodb.table_creation_timeout").defaultValue(String.valueOf(120000)).markAdvanced().sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, the maximum number of milliseconds to wait for creating DynamoDB table");
    public static final ConfigProperty<String> DYNAMODB_ENDPOINT_URL = ConfigProperty.key("hoodie.write.lock.dynamodb.endpoint_url").noDefaultValue().markAdvanced().sinceVersion("0.10.1").withDocumentation("For DynamoDB based lock provider, the url endpoint used for Amazon DynamoDB service. Useful for development with a local dynamodb instance.");
    public static final ConfigProperty<Integer> LOCK_ACQUIRE_WAIT_TIMEOUT_MS_PROP_KEY = ConfigProperty.key("hoodie.write.lock.wait_time_ms").defaultValue(60000).markAdvanced().sinceVersion("0.10.0").withDocumentation("Lock Acquire Wait Timeout in milliseconds");

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final DynamoDbBasedLockConfig lockConfig = new DynamoDbBasedLockConfig();

        public DynamoDbBasedLockConfig build() {
            this.lockConfig.setDefaults(DynamoDbBasedLockConfig.class.getName());
            this.checkRequiredProps();
            return this.lockConfig;
        }

        public Builder fromProperties(TypedProperties props) {
            this.lockConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        private void checkRequiredProps() {
            String errorMsg = "Config key is not found: ";
            ValidationUtils.checkArgument(this.lockConfig.contains(DYNAMODB_LOCK_TABLE_NAME.key()), errorMsg + DYNAMODB_LOCK_TABLE_NAME.key());
            ValidationUtils.checkArgument(this.lockConfig.contains(DYNAMODB_LOCK_REGION.key()), errorMsg + DYNAMODB_LOCK_REGION.key());
        }
    }
}

